/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<des.h>
#include	"mode.h"
#include	"config.h"
#include	"version.h"


#ifdef __SDTC__
const
#endif
	crypt_mode	mode_list[] = {
				{
					"CBC",
					(crypt_func) des_cbc_encrypt,
					(file_func) crypt_file_padding
				},
				{
					"ECB",
					(crypt_func) des_ecb2_encrypt,
					(file_func) crypt_file_padding
				},
				{
					"CFB8",
					(crypt_func) des_cfb8_encrypt,
					(file_func) crypt_file_plain
				},
				{
					"OFB8",
					(crypt_func) des_ofb8_encrypt,
					(file_func) crypt_file_plain
				},
				{
					"PCBC",
					(crypt_func) des_pcbc_encrypt,
					(file_func) crypt_file_padding
				},
				{
					(char *) 0,
					(crypt_func) 0,
					(file_func) 0
				}
			},
			mode_chksum = {
				"CBC CHKSUM",
				(crypt_func) des_cbc_cksum,
				(file_func) crypt_file_checksum
			};

