/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<des.h>
#include	"read.h"
#include	"env.h"
#include	"str.h"
#include	"getivec.h"
#include	"config.h"
#include	"version.h"



/*
 * getivec_file
 *
 *	This routine reads multiple ivecs from `file'.
 *	A file name of - indicates that the ivec should be read from stdin.
 *
 *	`getivec_file' returns number of ivecs read. -1 indicates an i/o error.
 *
 */

int	getivec_file(
#ifdef __STDC__
	des_cblock	ivec,
	char		*file)
#else
	ivec, file)
des_cblock	ivec;
char		*file;
#endif
{
	register char	*line = NULL;
	FILE		*fd;


	if (file[0] != '-' || file[1] != '\0') {
		fd = fopen(file, "r");
		if (fd == NULL)
			goto error;
	} else
		fd = stdin;

	if (!(line = read_line(fd, NULL, 0)))
		goto error;

	if (des_hex_to_cblock(line, (des_cblock *) ivec))
		goto error;

	free(line);

	if (fd != stdin)
		(void) fclose(fd);

	return 1;

error:
	if (fd != NULL && fd != stdin)
		(void) fclose(fd);
	if (line)
		free(line);
	return -1;
}

/*
 * putivec_file
 *
 *	This routine qwrites an ivec to `file'.
 *
 *	`putivec_file' returns 1 om success. -1 indicates an i/o error.
 *
 */

int	putivec_file(
#ifdef __STDC__
	des_cblock	ivec,
	char		*file)
#else
	ivec, file)
des_cblock	ivec;
char		*file;
#endif
{
	FILE	*fd = NULL;


	if (file[0] != '-' || file[1] != '\0') {
		fd = fopen(file, "w");
		if (fd == NULL)
			goto error;
	} else
		fd = stdout;

	if (des_print_cblock(fd, (des_cblock *) ivec, 1) != 1)
		goto error;

	if (fd != stdout)
		if (fclose(fd) == EOF) {
			fd = NULL;
			goto error;
		}

	return 1;

error:
	if (fd != NULL && fd != stdout)
		(void) fclose(fd);
	return -1;
}


/*
 * getivec_env
 *
 *	`getivec_env' returns ivecs found through environment varibales.
 */

int	getivec_env(
#ifdef __STDC__
	des_cblock	ivec)
#else
	ivec)
des_cblock	ivec;
#endif
{
#if defined(DES_XIVEC) || defined(DES_XIVECFILE)
	register char	*val;


#ifdef DES_XIVECFILE
	if (val = getenv(DES_XIVECFILE))
		if (getivec_file(ivec, val) == 1)
			return 1;
#endif /* DES_XIVECFILE */
#ifdef DES_XIVEC
	if (val = getenv(DES_XIVEC))
		if (des_hex_to_cblock(val, (des_cblock *) ivec))
			(void) fprintf(stderr, "Warning: %s (%s) is not a 64-bit hex number\n", val, DES_XIVEC);
		else
			return 1;
#endif /* DES_IVEC */
#endif /* DES_XIVEC || DES_XIVECFILE */

	return -1;
}

/*
 * getivec_prompt
 *
 *	This routine prompts for multiple ivecs. The ivecs found are returned
 *	through `ivec'.
 *
 *	`getivec_prompt' returns number of ivecs read. -1 indicates an internal
 *	error.
 *
 */

int	getivec_prompt(
#ifdef __STDC__
	des_cblock	ivec,
	int		flags)
#else
	ivec, flags)
des_cblock	ivec;
int		flags;
#endif
{
	if (des_read_cblock((des_cblock *) ivec, "Ivec: ", flags & IVEC_VERIFY_FLAG))
		goto error;

	return 1;

error:
	return -1;
}


/*
 * getivec
 *
 *	This routine reads multiple ivecs from a file, argument or prompts for
 *	them. The method to get the ivec is selected through `flags'.
 *	The ivecs found are returned through `ivec'.
 *
 *	`getivec' returns number of ivecs read. -1 indicates an internal error.
 *
 */

int	getivec(
#ifdef __STDC__
	des_cblock	ivec,
	char		*ivec_spec,
	int		flags)
#else
	ivec, ivec_spec, flags)
des_cblock	ivec;
char		*ivec_spec;
int		flags;
#endif
{
	if (flags & IVEC_STRING_FLAG) {
		if (des_hex_to_cblock(ivec_spec, (des_cblock *) ivec)) {
			fprintf(stderr, "ivec is not a 64 bit hexadecimal number\n");
			goto error;
		}
		return 1;
	}

	if (flags & IVEC_PROMPT_FLAG)
		return getivec_prompt(ivec, flags);

	if (flags & IVEC_FILE_FLAG)
		return getivec_file(ivec, ivec_spec);

	if (getivec_env(ivec) == 1)
		return 1;

	DES_ZERO_CBLOCK(ivec);
	return 0;

error:
	return -1;
}
