/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	"des.h"
#include	"local_def.h"
#include	"version.h"



/*
 * des_strkey_sun
 *
 *	Transfomration of a an arbitrary null terminated string to a 64 bit
 *	block.
 *
 *	This is the alogorithm used by SUN (or so I belive).
 *	It has only been tested with up to eight characters.
 *
 */

int	des_strkey_sun(
#ifdef __STDC__
	char		*str,
	des_cblock	key)
#else
	str, key)
char		*str;
des_cblock	key;
#endif
{
	register int		i, bit;
	register unsigned char	*cp, c, p;


	cp = (unsigned char *) str;
	for (i = 0; *cp && i < DES_BLOCK_BYTES; i++) {

		c = *cp++ & 0x7F; /* Mask out the 7 lower bits */

		/* Set the high bit to odd parity */
		p = 0x80;
		for (bit = 0x01; bit < 0x80; bit <<= 1)
			if (c & bit)
				p ^= 0x80;
		c |= p;
#ifdef DES_LSB_FIRST
		CHAR_ROTATE(c);	
#endif /* DES_LSB_FIRST */

		key[i] = c;
	}

	/* Zero padd with odd parity */
	for (; i < DES_BLOCK_BYTES; i++)
#ifdef DES_LSB_FIRST
		key[i] = 0x01;
#else  /* DES_LSB_FIRST */
		key[i] = 0x80;
#endif /* DES_LSB_FIRST */


	return 0;
}
