/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	"des.h"
#include	"local_def.h"
#include	"version.h"



/*
 * des_strkey_cth
 *
 *	Transfomration of a an arbitrary null terminated string to a 64 bit
 *	block.
 *
 *	This is my own algorithm. This algorithm is the same as the MIT
 *	algorithm for strings <= eight characters. This algorithm is
 *	obsolete and is only present for backward compability.
 *
 */

int	des_strkey_cth(
#ifdef __STDC__
	char		*str,
	des_cblock	key)
#else
	str, key)
char		*str;
des_cblock	key;
#endif
{
	register int		i;
	register unsigned char	*cp;
#ifdef DES_LSB_FIRST
	register unsigned char  c;
#endif /* DES_LSB_FIRST */
	des_cblock		ivec;
	des_key_schedule	schedule;


	DES_ZERO_CBLOCK(ivec);
	cp = (unsigned char *) str;
	while (*cp)
		for (i = 0; *cp && i < DES_BLOCK_BYTES; i++) {
		/* Shift the character "away" from the parity	*/
		/* bit. Since the key characters (mostly) are	*/
		/* in the range 1 .. 127, the shift ensures	*/
		/* usage of all character bits in the key.	*/
#ifdef DES_LSB_FIRST
			c = *cp++;
			CHAR_ROTATE(c);	
			ivec[i] ^= c;
#else  /* DES_LSB_FIRST */
			ivec[i] ^= *cp++;
#endif /* DES_LSB_FIRST */
		}
	for (i = 0; i < DES_BLOCK_BYTES; i++)
#ifdef DES_LSB_FIRST
		ivec[i] >>= 1;
#else  /* DES_LSB_FIRST */
		ivec[i] <<= 1;
#endif /* DES_LSB_FIRST */
	i = (int) (cp - (unsigned char *) str);

	(void) des_fixup_key_parity((des_cblock *) ivec);
	(void) des_sched((des_cblock *) ivec, schedule);
	(void) des_cbc_cksum((des_cblock *) str, (des_cblock *) key, i,
			     schedule, (des_cblock *) ivec);

	return 0;
}
