/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#define NEED_SIGACTION

#include	<signal.h>
#include	"sig.h"
#include	"config.h"

/*
 * Functions to store and restore signal status.
 * The stack has only one level.
 */

static struct sigaction	orig_sig[4];



push_signals(
#ifdef __STDC__
	SIGRETURN (*func)())
#else
	func)
SIGRETURN (*func)();
#endif
{
	struct sigaction	new_action;


	new_action.sa_handler = func;
	(void) sigemptyset(&new_action.sa_mask);
	(void) sigaddset(&new_action.sa_mask, SIGHUP);
	(void) sigaddset(&new_action.sa_mask, SIGINT);
	(void) sigaddset(&new_action.sa_mask, SIGTERM);
	(void) sigaddset(&new_action.sa_mask, SIGQUIT);
	new_action.sa_flags = 0;

	(void) sigaction(SIGHUP, &new_action, &orig_sig[0]);
	(void) sigaction(SIGINT, &new_action, &orig_sig[1]);
	(void) sigaction(SIGTERM, &new_action, &orig_sig[2]);
	(void) sigaction(SIGQUIT, &new_action, &orig_sig[3]);
}

pop_signals()
{
	(void) sigaction(SIGHUP, &orig_sig[0], NULL);
	(void) sigaction(SIGINT, &orig_sig[1], NULL);
	(void) sigaction(SIGTERM, &orig_sig[2], NULL);
	(void) sigaction(SIGQUIT, &orig_sig[3], NULL);
}
