/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"config.h"
#include	"read.h"
#include	"version.h"


#define	MALLOC_CHUNK	16


#ifndef DES_MAX_PASSWD

# define realloc fake_realloc

/*
 * fake_realloc
 *
 *	`fake_realloc' is similar to the `realloc' function but does only
 *	work on null terminated character strings.
 *
 *	`fake_realloc' replaces `realloc' to ensure that the contentse in
 *	`ptr' is left undisturbed if `malloc' fails.
 *
 */

static
#ifdef __STDC__
       void
#else
       char
#endif
		*fake_realloc(
#ifdef __STDC__
	void	*ptr,
	size_t	size)
#else
	ptr, size)
char	*ptr;
size_t	size;
#endif
{
	register
#ifdef __STDC__
		void
#else
		char
#endif
			*new;


	if ((new = malloc(size)) && ptr) {
		(void) strcpy((char *) new, (char *) ptr);
		free(ptr);
	}

	return new;
}


static char	*read_malloc_line(
#ifdef __STDC__
	FILE	*fd)
#else
	fd)
FILE	*fd;
#endif
{
	register int	c;
	register size_t	size, len;
	register char	*str, *tmp;


	size = len = 0;
	str = NULL;

	do {
		size += MALLOC_CHUNK;
		tmp = realloc(str, size);
		if (!tmp)
			goto error;
		str = tmp;

		do {
			c = fgetc(fd);
			if (ferror(fd))
				goto error;
			if (c == EOF || c == '\n')
				break;
			str[len++] = (char) c;
		} while (len < size - 2);
	} while (c != EOF && c != '\n');

	str[len] = '\0';
	return str;

error:
	if (str)
		free(str);
	return NULL;
}
#endif /* !DES_MAX_PASSWD */



/*
 * read_line
 *
 *	`read_line' read from `fd' up to a newline or end of file.
 *	and returns a null terminated string with the result.
 *	If the `buf' parameter is null then dynamic storage space is
 *	allocated. If `buf' is non-null, the `buf_len' paramter must contain
 *	the buffer length.
 *
 *	If any read error was detected or no storage space could be
 *	allocated, null is retuned.
 */


char	*read_line(
#ifdef __STDC__
	FILE	*fd,
	char	*buf,
	int	buf_len)
#else
	fd, buf, buf_len)
FILE	*fd;
char	*buf;
int	buf_len;
#endif
{
	register int	len;
	register char	*str;


	str = NULL;
#ifndef DES_MAX_PASSWD
	if (buf != NULL) {
#endif  /* DES_MAX_PASSWD */
		if (buf_len <= 0)
			goto error;

		if (fgets(buf, buf_len, fd) == NULL)
			goto error;
		if (ferror(fd))
			goto error;

		len = strlen(buf);
		if (len > 0)
			if (buf[len - 1] == '\n')
				buf[--len] = '\0';

		str = buf;
#ifndef DES_MAX_PASSWD
	} else {
		str = read_malloc_line(fd);
		if (str == NULL)
			goto error;
	}
#endif  /* DES_MAX_PASSWD */

	return str;

error:
	return NULL;
}
