/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	<setjmp.h>
#include	"des.h"
#include	"tty.h"
#include	"sig.h"
#include	"getpass2.h"
#include	"read.h"
#include	"config.h"

/*
 * getpass2
 *
 *	This routine shows the string `prompt' on the current tty and reads
 *	a line from the current tty. If the `verify' argument is non-zero,
 *	then a second prompt requesting verification is shown. If the first
 *	and second lines do not match, then the process is tried again until
 *	both match.
 *
 *	The input echo is switched off during the operation.
 *
 *	If the key can not be read from the tty, NULL is returned and the
 *	global variable `getpass2_error' set to -2. `getpass2_error'
 *	is set -1 is there was any problems with terminal echo manipulation.
 *
 */


/*
 * Signal catch routine;
 */

static int	has_set_jmp = 0;
static jmp_buf	signal_jmp;

static SIGRETURN	catch_signal(
#ifdef __STDC__
	void
#endif
)
{
	if (has_set_jmp)
		longjmp(signal_jmp, 1);
	RETURN_SIGFUNC(0);
}

/*
 * Global error information.
 */

int	getpass2_error;


static char	*getpass_simple(
#ifdef __STDC__
	FILE	*ttyw,
	FILE	*ttyr,
	char	*prompt,
	char	*buf,
	int	buf_len)
#else
	ttyw, ttyr, prompt, buf, buf_len)
FILE	*ttyw;
FILE	*ttyr;
char	*prompt;
char	*buf;
int	buf_len;
#endif
{
	register char	*line;


	line = NULL;

	(void) fputs(prompt, ttyw);
	(void) fflush(ttyw);
	if (ferror(ttyw))
		goto error;

	line = read_line(ttyr, buf, buf_len);
#if (! ECHONL)
	(void) fputc('\n', ttyw);
#endif /* ! ECHONL */

	return line;

error:
#ifndef DES_MAX_PASSWD
	if (!buf && line)
		free(line);
#endif  /* !DES_MAX_PASSWD */
	return NULL;
}


static char	*getpass_verify(
#ifdef __STDC__
	FILE	*ttyw,
	FILE	*ttyr,
	char	*prompt,
	char	*buf,
	int	buf_len)
#else
	ttyw, ttyr, prompt, buf, buf_len)
FILE	*ttyw;
FILE	*ttyr;
char	*prompt;
char	*buf;
int	buf_len;
#endif
{
	register int	vbuf_len;
	register char	*line;
#ifdef DES_MAX_PASSWD
	char		vbuf[DES_MAX_PASSWD + 1];
#else  /* DES_MAX_PASSWD */
	register int	len;
	register char	*vbuf;
#endif /* DES_MAX_PASSWD */


	line = vbuf = NULL;
#ifdef DES_MAX_PASSWD
	vbuf_len = sizeof(vbuf);
#else  /* DES_MAX_PASSWD */
	vbuf_len = 0;
#endif  /* !DES_MAX_PASSWD */

	for (;;) {
		line = getpass_simple(ttyw, ttyr, prompt, buf, buf_len);
		if (line == NULL)
			goto error;

#ifndef DES_MAX_PASSWD
		len = (buf) ? buf_len : strlen(line) + 2;
		if (vbuf_len < len + 1) {
			if (vbuf)
				free(vbuf);
			vbuf_len = len + 1;
			vbuf = malloc(vbuf_len);
			if (!vbuf)
				goto error;
		}
#endif /* !DES_MAX_PASSWD */

		(void) fputs("Verify ", ttyw);
		if (getpass_simple(ttyw, ttyr, prompt, vbuf, vbuf_len) == NULL)
			goto error;

		if (strcmp(line, vbuf) == 0)
			break;
#ifndef DES_MAX_PASSWD
		if (!buf)
			free(line);
#endif  /* !DES_MAX_PASSWD */

		(void) fputs("The keys do not match, try again\n", ttyw);

	}

#ifndef DES_MAX_PASSWD
	free(vbuf);
#endif /* !DES_MAX_PASSWD */

	return line;

error:
#ifndef DES_MAX_PASSWD
	if (!buf && line)
		free (line);
	if (vbuf)
		free(vbuf);
#endif /* !DES_MAX_PASSWD */
	return NULL;
}


char	*getpass2(
#ifdef __STDC__
	char	*prompt,
	char	*buf,
	int	buf_len,
	int	verify)
#else
	prompt, buf, buf_len, verify)
char	*prompt;
char	*buf;
int	buf_len;
int	verify;
#endif
{
	register int		tty_modified;
	register char		*line;
	FILE			*ttywfd, *ttyrfd;
	struct termios		old_tty_state;


	line = NULL;
	tty_modified = 0;
	ttywfd = ttyrfd = NULL;
	if (setjmp(signal_jmp))
		goto error;
	has_set_jmp = 1;
#ifdef TTY
	ttywfd = fopen(TTY, "w");
	if (ttywfd == NULL)
		goto error;
	ttyrfd = fopen(TTY, "r");
	if (ttyrfd == NULL)
		goto error;
#else  /* TTY */
	ttywfd = stdout;
	ttyrfd = stdin;
#endif /* TTY */

	push_signals(catch_signal);
	if (tty_disable_echo(ttyrfd, & old_tty_state) < 0)
		getpass2_error = -1;
	else
		tty_modified = 1;

	line = (verify) ?
		getpass_verify(ttywfd, ttyrfd, prompt, buf, buf_len) :
		getpass_simple(ttywfd, ttyrfd, prompt, buf, buf_len);
	if (line == NULL)
		goto error;

	if (tty_modified) {
		if (tty_reset(ttyrfd, & old_tty_state) < 0)
			getpass2_error = -1;
		tty_modified = 0;
	}
	pop_signals();

#ifdef TTY
	(void) fclose(ttywfd);
	(void) fclose(ttyrfd);
#endif /* TTY */

	return line;

error:
	if (tty_modified) {
		if (tty_reset(ttyrfd, & old_tty_state) < 0)
			getpass2_error = -1;
		tty_modified = 0;
	}
	pop_signals();
#ifdef TTY
	if (ttywfd != NULL) {
		(void) fclose(ttywfd);
		ttywfd = NULL;
	}
	if (ttyrfd != NULL) {
		(void) fclose(ttyrfd);
		ttyrfd = NULL;
	}
#endif /* TTY */
#ifndef DES_MAX_PASSWD
	if (!buf && line) {
		free(line);
		line = NULL;
	}
#endif  /* !DES_MAX_PASSWD */
	getpass2_error = -2;
	return NULL;
}
