/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	"des.h"
#include	"local_def.h"
#include	"version.h"


/*
 * List of weak keys.
 */

#define NO_WEAK_KEYS	4

static
#ifdef __SDTC__
	const
#endif
		des_cblock	weak_key[NO_WEAK_KEYS] = {
#ifdef DES_LSB_FIRST
			{ 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
			{ 0xf8, 0xf8, 0xf8, 0xf8, 0x70, 0x70, 0x70, 0x70 },
			{ 0x07, 0x07, 0x07, 0x07, 0x8f, 0x8f, 0x8f, 0x8f },
			{ 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f }
#else
			{ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
			{ 0x1f, 0x1f, 0x1f, 0x1f, 0x70, 0x70, 0x70, 0x70 },
			{ 0xe0, 0xe0, 0xe0, 0xe0, 0x8f, 0x8f, 0x8f, 0x8f },
			{ 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe }
#endif
		};

/*
 * des_is_weak_key
 *
 *	Checks for keys that produces an internal key scheudle that has
 *	the property K1 = K2 = ... = K16. There is a total of four weak keys.
 *
 *	The key must have correct parity.
 *
 *	0 => The key is not weak.
 *	1 => The key is weak.
 */

int	des_is_weak_key(
#ifdef __STDC__
	des_cblock *key)
#else
	key)
des_cblock	*key;
#endif
{
	register int		i;


	for (i = 0; i < NO_WEAK_KEYS; i++)
		if (CMP_8(weak_key[i],(*key)))
			return 1;
	return 0;
}
