/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	"des.h"
#include	"local_def.h"
#include	"version.h"

/*
 * des_cbc_encrypt
 *
 *	Cipher Block Chaining.
 *
 */

int	des_cbc_encrypt(
#ifdef __STDC__
	des_cblock		*input,
	des_cblock		*output,
	int			length,
	des_key_schedule	schedule,
	des_cblock		*ivec,
	int			encrypt)
#else
	input, output, length, schedule, ivec, encrypt)
des_cblock		*input;
des_cblock		*output;
int			length;
des_key_schedule	schedule;
des_cblock		*ivec;
int			encrypt;
#endif
{
	register int		i;
	des_cblock		c, tmp_ivec;
	register des_cblock	*ivecp;


	if (des_return_ivec) {
		ivecp = ivec;
	} else {
		COPY_8(tmp_ivec, (*ivec));
		ivecp = (des_cblock *) tmp_ivec;
	}
	if (encrypt) {
		for (; length >= DES_BLOCK_BYTES;
		       length -= DES_BLOCK_BYTES, output++, input++) {
			XOR_8((*ivecp), (*input));
			(void) (*des_core)(ivecp, ivecp, schedule, DES_ENCRYPT);
			COPY_8((*output), (*ivecp));
		}
		/* Padd with zeros. */
		if (length > 0) {
			for (i = 0; i < length; i++)
				(*ivecp)[i] ^= (*input)[i];
			(void) (*des_core)(ivecp, ivecp, schedule, DES_ENCRYPT);
			COPY_8((*output), (*ivecp));
		}
	} else
		for (; length > 0;
		       length -= DES_BLOCK_BYTES, output++, input++) {
			COPY_8(c, (*input));
			(void) (*des_core)(input, output, schedule, DES_DECRYPT);
			XOR_8((*output), (*ivecp));
			COPY_8((*ivecp), c);
		}
		/* There is no idea to use padding in decryption */

	return 0;
}
