/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<string.h>
#include	"des.h"
#include	"config.h"
#include	"fips_def.h"
#include	"fips_PC1.h"
#ifndef SCH_TEST
# include       "sch_conf.h"
#endif  /* SCH_TEST */


/*
 * This program generates a macro for us as permutated choise 1.
 *
 *		PC1(C0, D0, KEY)
 *
 * The input is an array of unsigned characters with the least significant
 * bit of `KEY[0]' as the first bit.
 * The 28 bit output is stored into the 28 least significant bits of
 * `C0' and `D0' with the least significant bit as the first.
 */

static char	*prog;
static char	*base;
static int	c_file = 0;


main(argc, argv)
int	argc;
char	*argv[];
{
#ifdef USE_SHIFT
	register int		n, r, c, block_bit, byte, n_bit, bit, s;
#else  /* USE_SHIFT */
# ifdef USE_IF
	register int		n, r, c, block_bit, byte, bit;
	unsigned char		c0[DES_BLOCK_BYTES][UNSIGNED_CHAR_BITS];
	unsigned char		d0[DES_BLOCK_BYTES][UNSIGNED_CHAR_BITS];
# else  /* USE_IF */
	register unsigned long	c, d;
	register int		i, j, byte, bit, n, sb, row, col;
	unsigned long		cv[UNSIGNED_CHAR_MAX + 1];
	unsigned long		dv[UNSIGNED_CHAR_MAX + 1];
# endif /* USE_IF */
#endif /* USE_SHIFT */


        prog = (prog = strrchr(*argv, '/')) ? (prog + 1) : *argv;
	if (argc != 3 || (strcmp(argv[1], "-c") && strcmp(argv[1], "-h")))
		goto usage;
	c_file = strcmp(argv[1], "-h");
	base = argv[2];

        (void) printf("/*\n");
	(void) printf(" * This file is automaticly generated, do not change.\n");
	(void) printf(" */\n\n");

	if (c_file)  {
		(void) printf("#include\t\"local_def.h\"\n#include\t\"version.h\"\n");
		(void) printf("#include\t\"%s.h\"\n\n", base);
	}

#ifdef USE_SHIFT
	if (c_file) {
		(void) printf("/* No global definitions. */\n");
	} else {
		(void) printf("#define PC1(C0, D0, KEY) \\\n");
		for (n = block_bit = n_bit = r = 0; r < PC1_ROWS; r++)
			for (c = 0; c < PC1_COLUMNS; c++) {
				if (++n_bit == 1)
					(void) printf("\t%c0 = ( \\\n", n++ ? 'D' : 'C');
				byte = ((int) pc1[r][c] - 1) / DES_BLOCK_BYTES;
				bit = pc1[r][c] - (byte * DES_BLOCK_BYTES);
				(void) printf("\t\t((unsigned long) (KEY[%d] & 0x%02x)", byte,
# ifdef DES_LSB_FIRST
					     0x01 << (bit - 1));
				s = n_bit - bit;
# else
					     0x80 >> (bit - 1));
				s = n_bit - (UNSIGNED_CHAR_BITS + 1 - bit);
# endif
				if (s > 0) 
					(void) printf(" << %2d", s);
				else if (s < 0)
					(void) printf(" >> %2d", -s);
				else
					(void) printf("      ");
				if (n_bit == DES_C_BITS) {
					(void) printf(")   /* bit %2d */ \\\n",
						      ++block_bit);
					(void) printf((block_bit == DES_C_BITS) ?
						      "\t); \\\n\\\n" : "\t)\n");
					n_bit = 0;
				} else
					(void) printf(") | /* bit %2d */ \\\n",
					 	      ++block_bit);
			}
	}
#else  /* USE_SHIFT */
# ifdef USE_IF
	if (c_file) {
		(void) printf("/* No global definitions. */\n");
	} else {
		for (r = 0; r < DES_BLOCK_BYTES; r++)
			for (c = 0; c < UNSIGNED_CHAR_BITS; c++)
				c0[r][c] = d0[r][c] = 0;
		for (block_bit = r = 0; r < PC1_ROWS; r++)
			for (c = 0; c < PC1_COLUMNS; block_bit++, c++) {
				byte = ((int) pc1[r][c] - 1) / DES_BLOCK_BYTES;
				bit = pc1[r][c] - (byte * DES_BLOCK_BYTES);
#  ifdef DES_LSB_FIRST
				bit--;
#  else
				bit = UNSIGNED_CHAR_BITS - bit;
#  endif
				if (block_bit < DES_C_BITS)
					c0[byte][bit] = (unsigned char) block_bit + 1;
				else
					d0[byte][bit] = (unsigned char) block_bit -
							(DES_C_BITS - 1);
		}
		(void) printf("#define PC1(C0, D0, KEY) \\\n");
		(void) printf("\tC0 = 0x0l; \\\n");
		for (byte = 0; byte < DES_BLOCK_BYTES; byte++) {
			for (bit = 0; bit < UNSIGNED_CHAR_BITS; bit++) {
				if (!c0[byte][bit])
					continue;
				(void) printf("\tif (KEY[%d] & 0x%02x) C0 |= 0x%08lxl",
					      byte, 0x1 << bit, 0x1l << c0[byte][bit] - 1);
				(void) printf("; /* %2d */ \\\n", c0[byte][bit]);
			}
		}
		(void) printf("\tD0 = 0x0l; \\\n");
		for (n = 0, byte = DES_BLOCK_BYTES - 1; byte >= 0; byte--) {
			for (bit = 0; bit < UNSIGNED_CHAR_BITS; bit++) {
				if (!d0[byte][bit])
					continue;
				(void) printf("\tif (KEY[%d] & 0x%02x) D0 |= 0x%08lxl",
					      byte, 0x1 << bit, 0x1l << d0[byte][bit] - 1);
				if (++n == DES_C_BITS)
					(void) printf("  /* %2d */\n", d0[byte][bit]);
				else
					(void) printf("; /* %2d */ \\\n", d0[byte][bit]);
			}
		}
	}
# else  /* USE_IF */
	if (c_file) {
		(void) printf("#ifdef __SDTC__\nconst\n#endif\n");
		(void) printf("\t%s_t\tpc1 = {\n\t\t{\n", base);
		*cv = 0x0l;
		*dv = 0x0l;
#  ifdef DES_LSB_FIRST
		cv[(UNSIGNED_CHAR_MAX + 1) / 2] = 0x0l;
		dv[(UNSIGNED_CHAR_MAX + 1) / 2] = 0x0l;
#  else DES_LSB_FIRST
		cv[1] = 0x0l;
		dv[1] = 0x0l;
#  endif
		for (byte = 0; byte < DES_BLOCK_BYTES; byte++) {
#  ifdef DES_LSB_FIRST
			for (bit = 0; bit < UNSIGNED_CHAR_MAX + 1; bit++) {
				sb = (byte * UNSIGNED_CHAR_BITS + bit) + 1;
#  else
			for (bit = 1; bit < UNSIGNED_CHAR_BITS; bit++) {
				sb = (byte * UNSIGNED_CHAR_BITS +
					((UNSIGNED_CHAR_BITS - 1) - bit)) + 1;
#  endif
				/*
				 * row and col can't be used directly as index
				 * variables due to the C-compiler on PS/2.
				 */
				row = col = 0;
				for (i = 0; i < PC1_ROWS; i++)
					for (j = 0; j < PC1_COLUMNS; j++)
						if (sb == pc1[i][j]) {
							row = i;
							col = j;
							goto next;
						}
next:
				sb = (row * PC1_COLUMNS) + col;
				if (sb >= DES_C_BITS) {
					c = 0x0l;
					d = 0x1l << (sb - DES_C_BITS);
				} else {
					c = 0x1l << sb;
					d = 0x0l;
				}
				n = 0x1 << bit;
				cv[n] = c;
				dv[n] = d;
#  ifdef DES_LSB_FIRST
				cv[n + ((UNSIGNED_CHAR_MAX + 1) / 2)] = c;
				dv[n + ((UNSIGNED_CHAR_MAX + 1) / 2)] = d;
				if (n > 1)
					for (i = 1, j = n + 1; i < n; i++, j++) {
						cv[j + ((UNSIGNED_CHAR_MAX + 1) / 2)] =
							cv[j] = c | cv[i];
						cv[j + ((UNSIGNED_CHAR_MAX + 1) / 2)] =
							dv[j] = d | dv[i];
					}
#  else
				cv[n + 1] = c;
				dv[n + 1] = d;
				if (n > 2)
					for (i = 2, j = n + 2; i < n; i++, j++) {
						cv[j] = c | cv[i];
						dv[j] = d | dv[i];
					}
#  endif
			}
			for (i = 0; i < UNSIGNED_CHAR_MAX; i++)
				(void) printf("\t\t\t{ 0x%08lxl, 0x%08lxl },\n",
					      cv[i], dv[i]);
			(void) printf("\t\t\t{ 0x%08lxl, 0x%08lxl }\n\t\t}", cv[i], dv[i]);
			if (byte < DES_BLOCK_BYTES - 1)
				(void) printf(", {\n");
		}
		(void) printf("\n\t};\n");
	} else {
		(void) printf("#define PC1(C, D, KEY) \\\n");
		(void) printf("\tC  = pc1[0][KEY[0]].c; D  = pc1[0][KEY[0]].d; \\\n");
		for (i = 1; i < DES_BLOCK_BYTES - 1; i++)
			(void) printf("\tC |= pc1[%d][KEY[%d]].c; D |= pc1[%d][KEY[%d]].d; \\\n",
				      i, i, i, i);
		(void) printf("\tC |= pc1[%d][KEY[%d]].c; D |= pc1[%d][KEY[%d]].d\n\n",
			      i, i, i, i);
		(void) printf("typedef\tstruct {\n\t\tunsigned long\tc, d;\n\t} %s_t[%d][%d];\n\n",
			      base, DES_BLOCK_BYTES, UNSIGNED_CHAR_MAX + 1);
		(void) printf("extern\n#ifdef __SDTC__\n\tconst\n#endif\n");
		(void) printf("\t\t%s_t\tpc1;\n", base);
	}
# endif /* USE_IF */
#endif /* USE_SHIFT */

	exit(0);

usage:
	(void) fprintf(stderr, "Usage: %s -c|-h base\n", prog);
	exit(1);
}
