/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<string.h>
#include	"config.h"
#include	"fips_def.h"
#include	"fips_P.h"
#ifndef DEA_TEST
# include       "dea_conf.h"
#endif  /* DEA_TEST */


/*
 * This program generates a macro for us as the permutation.
 *
 *		P(R)
 *
 * The input is an unsigned long `R' with the least significant bit
 * as the first.
 * The output is an unsigned long with the least significant bit as the
 * first.
 */

static char	*prog;
static char	*base;
static int	c_file = 0;


main(argc, argv)
int	argc;
char	*argv[];
{
	register int	r, c, block_bit, shift, max_s, min_s;
	unsigned long	st[DES_BITS];


	prog = (prog = strrchr(*argv, '/')) ? (prog + 1) : *argv;
	if (argc != 3 || (strcmp(argv[1], "-c") && strcmp(argv[1], "-h")))
		goto usage;
	c_file = strcmp(argv[1], "-h");
	base = argv[2];

	(void) printf("/*\n");
	(void) printf(" * This file is automaticly generated, do not change.\n");
	(void) printf(" */\n\n");

	if (c_file) {
		(void) printf("#include\t\"local_def.h\"\n#include\t\"version.h\"\n");
		(void) printf("#include\t\"%s.h\"\n\n", base);
		(void) printf("/* No global definitions. */\n");
	} else {
		for (shift = 0; shift < DES_BITS; shift++)
			st[shift] = 0x0l;

		min_s = DES_L_BITS;
		max_s = -DES_L_BITS;
		for (block_bit = r = 0; r < P_ROWS; r++)
			for (c = 0; c < P_COLUMNS; c++) {
				shift = ++block_bit - p[r][c];
				st[DES_L_BITS + shift] |= 0x1l << (p[r][c] - 1);
				if (max_s < shift)
					max_s = shift;
				if (min_s > shift)
					min_s = shift;
			}

		(void) printf("#define P(R) \\\n( \\\n");
		for (shift = min_s; shift <= max_s; shift++)
			if (st[DES_L_BITS + shift]) {
				(void) printf("\t((R & 0x%08lxl) ",
					      st[DES_L_BITS + shift]);
				if (shift > 0)
					(void) printf("<< %2d)", shift);
				else if (shift < 0)
					(void) printf(">> %2d)", -shift);
				else
					(void) printf("     )");
				if (shift == max_s)
					(void) printf(" \\\n");
				else
					(void) printf(" | \\\n");
			}
		(void) printf(")\n");
	}

	exit(0);

usage:
	(void) fprintf(stderr, "Usage: %s -c|-h base\n", prog);
	exit(1);
}
