/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	"des.h"
#ifndef DEA3_TEST
# include	"dea3_conf.h"
#endif  /* DEA3_TEST */
#ifndef USE_DES_DEA
# include	"dea.h"
#endif  /* USE_DES_DEA */
#include	"version.h"

/*
 * des_dea3
 *
 *	Trippel DES encryption alogrithm as described in
 *	ANSI X9.17-1985.
 *
 *	E = Encrypt DES.
 *	D = Decrypt DES.
 *	E3 = Encrypt Trippel DES.
 *	D3 = Decrypt Trippel DES.
 *
 *	E3({K1, K2}, x) = E(K1, D(K2, E(K1, x)))
 *	D3({K1, K2}, x) = D(K1, E(K2, D(K1, x)))
 *
 *	Note: K1 = K2 -> E3 = E, D3 = D.
 *
 *	`input' and `output' may be overlapping.
 */


int	des_dea3(
#ifdef __STDC__
	des_cblock		*input,
	des_cblock		*output,
	des_key_schedule	schedule,
	int			encrypt)
#else
	input, output, schedule, encrypt)
des_cblock		*input;
des_cblock		*output;
des_key_schedule	schedule;
int			encrypt;
#endif
{
	register des_key_schedule	*schedule1, *schedule2;
#ifndef USE_DES_DEA
	register unsigned long		l, r;
#ifdef IP_DATA
	IP_DATA;
#endif /* IP_DATA */
#ifdef CRYPT_DATA
	CRYPT_DATA;
#endif /* CRYPT_DATA */
#ifdef IPinv_DATA
	IPinv_DATA;
#endif /* IPinv_DATA */
#endif  /* USE_DES_DEA */


	schedule1 = (des_key_schedule *) schedule;
	schedule2 = schedule1 + 1;
#ifdef USE_DES_DEA
	(void) des_dea(input, output, *schedule1, encrypt);
	(void) des_dea(output, output, *schedule2, !encrypt);
	(void) des_dea(output, output, *schedule1, encrypt);
#else  /* USE_DES_DEA */
	/* IP - Initial Permutaion */
	IP(l, r, (*input));

	/* I 3 x (1 .. DES_ITERATIONS) - Iterations */
	/* The `IP' permutaions between each DEA step eliminates eachother */
	if (encrypt) {
		ENCRYPT(l, r, *schedule1)
		/* `IP' and `IPinv' eliminates eachother */
		DECRYPT(r, l, *schedule2)
		/* `IP' and `IPinv' eliminates eachother */
		ENCRYPT(l, r, *schedule1)
	} else {
		DECRYPT(l, r, *schedule1)
		/* `IP' and `IPinv' eliminates eachother */
		ENCRYPT(r, l, *schedule2)
		/* `IP' and `IPinv' eliminates eachother */
		DECRYPT(l, r, *schedule1)
	}

	/* IPinv - Inverse of Initial Permutaion IP */
	IPinv((*output), r, l);
#endif /* USE_DES_DEA */

	return 0;
}
