#ifndef __NWCALLS_H__
#define __NWCALLS_H__

/* Stub for nwdir.c ... Maybe more? */

#include "ncplib.h"

typedef u_int32_t	nuint;
typedef u_int8_t	nuint8;
typedef u_int16_t	nuint16;
typedef u_int32_t	nuint32;

typedef nuint		NWCCODE;

typedef struct ncp_conn* NWCONN_HANDLE;
typedef struct nw_info_struct NW_ENTRY_INFO;
#define nameLength nameLen

typedef struct {
	void*	fragAddress;
	size_t	fragSize;
		} NW_FRAGMENT;

typedef struct {
	const void* fragAddress;
	size_t	fragSize;
		} NW_CFRAGMENT;
		
typedef struct {
	u_int32_t	objectID;
	u_int16_t	objectRights;
		} TRUSTEE_INFO;

#define TR_READ		NCP_PERM_READ
#define TR_WRITE	NCP_PERM_WRITE
#define TR_CREATE	NCP_PERM_CREATE
#define TR_ERASE	NCP_PERM_DELETE
#define TR_ACCESS_CTRL	NCP_PERM_OWNER
#define TR_SEARCH	NCP_PERM_SEARCH
#define TR_MODIFY	NCP_PERM_MODIFY
#define TR_SUPERVISOR	NCP_PERM_SUPER

#define OT_USER		NCP_BINDERY_USER
#define OT_USER_GROUP	NCP_BINDERY_UGROUP
#define OT_FILE_SERVER	NCP_BINDERY_FSERVER

#define IM_NAME		RIM_NAME
#define IM_DIRECTORY	RIM_DIRECTORY
#define IM_ALL		RIM_ALL

#define A_READ_ONLY	0x00000001	/* aRDONLY... but it is htonl-ed... fixme... */
#define A_HIDDEN	0x00000002
#define A_SYSTEM	0x00000004
#define A_EXECUTE_ONLY	0x00000008
#define A_DIRECTORY	0x00000010
#define A_NEEDS_ARCHIVED 0x00000020
#define A_SHAREABLE	0x00000080
#define A_DONT_SUBALLOCATE 0x00000800
#define A_TRANSACTIONAL	0x00001000
#define A_INDEXED	0x00002000
#define A_READ_AUDIT	0x00004000
#define A_WRITE_AUDIT	0x00008000
#define A_IMMEDIATE_PURGE 0x00010000
#define A_RENAME_INHIBIT 0x00020000
#define A_DELETE_INHIBIT 0x00040000
#define A_COPY_INHIBIT	0x00080000
#define A_FILE_MIGRATED	0x00400000
#define A_DONT_MIGRATE	0x00800000
#define A_IMMEDIATE_COMPRESS 0x02000000
#define A_FILE_COMPRESSED 0x04000000
#define A_DONT_COMPRESS	0x08000000
#define A_CANT_COMPRESS	0x20000000

NWCCODE NWCallsInit(void*,void*);
NWCCODE NWRequest(NWCONN_HANDLE, nuint, nuint, const NW_CFRAGMENT*, nuint, NW_FRAGMENT*);
NWCCODE NWRequestSimple(NWCONN_HANDLE, nuint, const void*, size_t, NW_FRAGMENT*);
NWCCODE NWGetObjectName(NWCONN_HANDLE, nuint32, char*, nuint16*);
NWCCODE NWGetNSEntryInfo(NWCONN_HANDLE, nuint, const char*, nuint, nuint, nuint16, nuint32, NW_ENTRY_INFO*);
NWCCODE NWParsePath(const char*, char*, NWCONN_HANDLE*, char*, char*);
NWCCODE NWOpenBindery(NWCONN_HANDLE);
NWCCODE NWCloseBindery(NWCONN_HANDLE);
NWCCODE NWDownFileServer(NWCONN_HANDLE, nuint);
NWCCODE NWEnableFileServerLogin(NWCONN_HANDLE);
NWCCODE NWDisableFileServerLogin(NWCONN_HANDLE);

NWCCODE NWDisableTTS(NWCONN_HANDLE);
NWCCODE NWEnableTTS(NWCONN_HANDLE);

NWCCODE NWSMLoadNLM(NWCONN_HANDLE, const char*);
NWCCODE NWSMUnloadNLM(NWCONN_HANDLE, const char*);
NWCCODE NWSMMountVolume(NWCONN_HANDLE, const char*, nuint32*);
NWCCODE NWSMDismountVolumeByName(NWCONN_HANDLE, const char*);
NWCCODE NWSMDismountVolumeByNumber(NWCONN_HANDLE, nuint32);
NWCCODE NWSMExecuteNCFFile(NWCONN_HANDLE, const char*);
NWCCODE NWSMSetDynamicCmdStrValue(NWCONN_HANDLE, const char*, const char*);
NWCCODE NWSMSetDynamicCmdIntValue(NWCONN_HANDLE, const char*, nuint32);

#define NWE_REQUESTER_ERROR	0x8800

#define NWE_PARAM_INVALID	(NWE_REQUESTER_ERROR | 0x36)

#define NWE_REQUESTER_FAILURE	(NWE_REQUESTER_ERROR | 0xFF)

#define NWE_SERVER_ERROR	0x8900

#define NWE_SERVER_FAILURE	(NWE_SERVER_ERROR | 0xFF)

#endif	/* __NWCALLS_H__ */

