/* This program generates and tests the standard S-boxes used by Snefru,
	the one way hash function.  It uses the RAND table of random numbers.


This is version 2.0, July 31, 1989.



Copyright (c) Xerox Corporation 1989
All rights reserved.

License to copy and use this software is granted.

License is also granted to make and use derivative works.

Xerox Corporation makes no representations concerning either the
merchantability of this software or the suitability of this software for any
particular purpose.  It is provided "as is" without express or implied
warranty of any kind.

These notices must be retained in any copies of any part of this software.




#define inputFile 0		/* normally standard in */
#define outputFile 1		/* normally standard out */
#define errorFile 2		/* normally standard error */


#define SBoxCount 8		/* number of S boxes in the set of standard S
				   boxes */




/* The random table is the first part of the random digits from the book:
   'A Million Random Digits with 100,000 Normal Deviates", by the RAND
   Corporation, published by the Free Press, 1955.  The formatting is similar
   to the book to allow easy inspection and verification. The random digits
   are also available on magnetic tape or diskettes from the RAND
   corporation.

Send inquiries to: The RAND Corporation, Computer Information Systems, 1700
   Main St., Santa Monica California 90406;  ATTN:  Jackie McGee

*/


/* The following two global variables are used only by 'randomDigit' */

/* group location in the table of random digits */
int     locationInRANDtable = 0;
	/* location within a 5-digit group  */
int     locationIn5DigitGroup = 0;


#define sizeOfRANDtableIn5DigitGroups 4810
char    RANDtable[sizeOfRANDtableIn5DigitGroups][5] = {
/* 0 */	"10097", "32533", "76520", "13586", "34673",
			"54876", "80959", "09117", "39292", "74945",
/* 1 */	"37542", "04805", "64894", "74296", "24805",
			"24037", "20636", "10402", "00822", "91665",
/* 2 */	"08422", "68953", "19645", "09303", "23209",
			"02560", "15953", "34764", "35080", "33606",
/* 3 */	"99019", "02529", "09376", "70715", "38311",
			"31165", "88676", "74397", "04436", "27659",
/* 4 */	"12807", "99970", "80157", "36147", "64032",
			"36653", "98951", "16877", "12171", "76833",
/* 5 */	"66065", "74717", "34072", "76850", "36697",
			"36170", "65813", "39885", "11199", "29170",
/* 6 */	"31060", "10805", "45571", "82406", "35303",
			"42614", "86799", "07439", "23403", "09732",
/* 7 */	"85269", "77602", "02051", "65692", "68665",
			"74818", "73053", "85247", "18623", "88579",
/* 8 */	"63573", "32135", "05325", "47048", "90553",
			"57548", "28468", "28709", "83491", "25624",
/* 9 */	"73796", "45753", "03529", "64778", "35808",
			"34282", "60935", "20344", "35273", "88435",
/* 10 */	"98520", "17767", "14905", "68607", "22109",
			"40558", "60970", "93433", "50500", "73998",
/* 11 */	"11805", "05431", "39808", "27732", "50725",
			"68248", "29405", "24201", "52775", "67851",
/* 12 */	"83452", "99634", "06288", "98083", "13746",
			"70078", "18475", "40610", "68711", "77817",
/* 13 */	"88685", "40200", "86507", "58401", "36766",
			"67951", "90364", "76493", "29609", "11062",
/* 14 */	"99594", "67348", "87517", "64969", "91826",
			"08928", "93785", "61368", "23478", "34113",
/* 15 */	"65481", "17674", "17468", "50950", "58047",
			"76974", "73039", "57186", "40218", "16544",
/* 16 */	"80124", "35635", "17727", "08015", "45318",
			"22374", "21115", "78253", "14385", "53763",
/* 17 */	"74350", "99817", "77402", "77214", "43236",
			"00210", "45521", "64237", "96286", "02655",
/* 18 */	"69916", "26803", "66252", "29148", "36936",
			"87203", "76621", "13990", "94400", "56418",
/* 19 */	"09893", "20505", "14225", "68514", "46427",
			"56788", "96297", "78822", "54382", "14598",
/* 20 */	"91499", "14523", "68479", "27686", "46162",
			"83554", "94750", "89923", "37089", "20048",
/* 21 */	"80336", "94598", "26940", "36858", "70297",
			"34135", "53140", "33340", "42050", "82341",
/* 22 */	"44104", "81949", "85157", "47954", "32979",
			"26575", "57600", "40881", "22222", "06413",
/* 23 */	"12550", "73742", "11100", "02040", "12860",
			"74697", "96644", "89439", "28707", "25815",
/* 24 */	"63606", "49329", "16505", "34484", "40219",
			"52563", "43651", "77082", "07207", "31790",
/* 25 */	"61196", "90446", "26457", "47774", "51924",
			"33729", "65394", "59593", "42582", "60527",
/* 26 */	"15474", "45266", "95270", "79953", "59367",
			"83848", "82396", "10118", "33211", "59466",
/* 27 */	"94557", "28573", "67897", "54387", "54622",
			"44431", "91190", "42592", "92927", "45973",
/* 28 */	"42481", "16213", "97344", "08721", "16868",
			"48767", "03071", "12059", "25701", "46670",
/* 29 */	"23523", "78317", "73208", "89837", "68935",
			"91416", "26252", "29663", "05522", "82562",
/* 30 */	"04493", "52494", "75246", "33824", "45862",
			"51025", "61962", "79335", "65337", "12472",
/* 31 */	"00549", "97654", "64051", "88159", "96119",
			"63896", "54692", "82391", "23287", "29529",
/* 32 */	"35963", "15307", "26898", "09354", "33351",
			"35462", "77974", "50024", "90103", "39333",
/* 33 */	"59808", "08391", "45427", "26842", "83609",
			"49700", "13021", "24892", "78565", "20106",
/* 34 */	"46058", "85236", "01390", "92286", "77281",
			"44077", "93910", "83647", "70617", "42941",
/* 35 */	"32179", "00597", "87379", "25241", "05567",
			"07007", "86743", "17157", "85394", "11838",
/* 36 */	"69234", "61406", "20117", "45204", "15956",
			"60000", "18743", "92423", "97118", "96338",
/* 37 */	"19565", "41430", "01758", "75379", "40419",
			"21585", "66674", "36806", "84962", "85207",
/* 38 */	"45155", "14938", "19476", "07246", "43667",
			"94543", "59047", "90033", "20826", "69541",
/* 39 */	"94864", "31994", "36168", "10851", "34888",
			"81553", "01540", "35456", "05014", "51176",
/* 40 */	"98086", "24826", "45240", "28404", "44999",
			"08896", "39094", "73407", "35441", "31880",
/* 41 */	"33185", "16232", "41941", "50949", "89435",
			"48581", "88695", "41994", "37548", "73043",
/* 42 */	"80951", "00406", "96382", "70774", "20151",
			"23387", "25016", "25298", "94624", "61171",
/* 43 */	"79752", "49140", "71961", "28296", "69861",
			"02591", "74852", "20539", "00387", "59579",
/* 44 */	"18633", "32537", "98145", "06571", "31010",
			"24674", "05455", "61427", "77938", "91936",
/* 45 */	"74029", "43902", "77557", "32270", "97790",
			"17119", "52527", "58021", "80814", "51748",
/* 46 */	"54178", "45611", "80993", "37143", "05335",
			"12969", "56127", "19255", "36040", "90324",
/* 47 */	"11664", "49883", "52079", "84827", "59381",
			"71539", "09973", "33440", "88461", "23356",
/* 48 */	"48324", "77928", "31249", "64710", "02295",
			"36870", "32307", "57546", "15020", "09994",
/* 49 */	"69074", "94138", "87637", "91976", "35584",
			"04401", "10518", "21615", "01848", "76938",
/* 50 */	"09188", "20097", "32825", "39527", "04220",
			"86304", "83389", "87374", "64278", "58044",
/* 51 */	"90045", "85497", "51981", "50654", "94938",
			"81997", "91870", "76150", "68476", "64659",
/* 52 */	"73189", "50207", "47677", "26269", "62290",
			"64464", "27124", "67018", "41361", "82760",
/* 53 */	"75768", "76490", "20971", "87749", "90429",
			"12272", "95375", "05871", "93823", "43178",
/* 54 */	"54016", "44056", "66281", "31003", "00682",
			"27398", "20714", "53295", "07706", "17813",
/* 55 */	"08358", "69910", "78542", "42785", "13661",
			"58873", "04618", "97553", "31223", "08420",
/* 56 */	"28306", "03264", "81333", "10591", "40510",
			"07893", "32604", "60475", "94119", "01840",
/* 57 */	"53840", "86233", "81594", "13628", "51215",
			"90290", "28466", "68795", "77762", "20791",
/* 58 */	"91757", "53741", "61613", "62269", "50263",
			"90212", "55781", "76514", "83483", "47055",
/* 59 */	"89415", "92694", "00397", "58391", "12607",
			"17646", "48949", "72306", "94541", "37408",
/* 60 */	"77513", "03820", "86864", "29901", "68414",
			"82774", "51908", "13980", "72893", "55507",
/* 61 */	"19502", "37174", "69979", "20288", "55210",
			"29773", "74287", "75251", "65344", "67415",
/* 62 */	"21818", "59313", "93278", "81757", "05686",
			"73156", "07082", "85046", "31853", "38452",
/* 63 */	"51474", "66499", "68107", "23621", "94049",
			"91345", "42836", "09191", "08007", "45449",
/* 64 */	"99559", "68331", "62535", "24170", "69777",
			"12830", "74819", "78142", "43860", "72834",
/* 65 */	"33713", "48007", "93584", "72869", "51926",
			"64721", "58303", "29822", "93174", "93972",
/* 66 */	"85274", "86893", "11303", "22970", "28834",
			"34137", "73515", "90400", "71148", "43643",
/* 67 */	"84133", "89640", "44035", "52166", "73852",
			"70091", "61222", "60561", "62327", "18423",
/* 68 */	"56732", "16234", "17395", "96131", "10123",
			"91622", "85496", "57560", "81604", "18880",
/* 69 */	"65138", "56806", "87648", "85261", "34313",
			"65861", "45875", "21069", "85644", "47277",
/* 70 */	"38001", "02176", "81719", "11711", "71602",
			"92937", "74219", "64049", "65584", "49698",
/* 71 */	"37402", "96397", "01304", "77586", "56271",
			"10086", "47324", "62605", "40030", "37438",
/* 72 */	"97125", "40348", "87083", "31417", "21815",
			"39250", "75237", "62047", "15501", "29578",
/* 73 */	"21826", "41134", "47143", "34072", "64638",
			"85902", "49139", "06441", "03856", "54552",
/* 74 */	"73135", "42742", "95719", "09035", "85794",
			"74296", "08789", "88156", "64691", "19202",
/* 75 */	"07638", "77929", "03061", "18072", "96207",
			"44156", "23821", "99538", "04713", "66994",
/* 76 */	"60528", "83441", "07954", "19814", "59175",
			"20695", "05533", "52139", "61212", "06455",
/* 77 */	"83596", "35655", "06958", "92983", "05128",
			"09719", "77433", "53783", "92301", "50498",
/* 78 */	"10850", "62746", "99599", "10507", "13499",
			"06319", "53075", "71839", "06410", "19362",
/* 79 */	"39820", "98952", "43622", "63147", "64421",
			"80814", "43800", "09351", "31024", "73167",
/* 80 */	"59580", "06478", "75569", "78800", "88835",
			"54486", "23768", "06156", "04111", "08408",
/* 81 */	"38508", "07341", "23793", "48763", "90822",
			"97022", "17719", "04207", "95954", "49953",
/* 82 */	"30692", "70668", "94688", "16127", "56196",
			"80091", "82067", "63400", "05462", "69200",
/* 83 */	"65443", "95659", "18288", "27437", "49632",
			"24041", "08337", "65676", "96299", "90836",
/* 84 */	"27267", "50264", "13192", "72294", "07477",
			"44606", "17985", "48911", "97341", "30358",
/* 85 */	"91307", "06991", "19072", "24210", "36699",
			"53728", "28825", "35793", "28976", "66252",
/* 86 */	"68434", "94688", "84473", "13622", "62126",
			"98408", "12843", "82590", "09815", "93146",
/* 87 */	"48908", "15877", "54745", "24591", "35700",
			"04754", "83824", "52692", "54130", "55160",
/* 88 */	"06913", "45197", "42672", "78601", "11883",
			"09528", "63011", "98901", "14974", "40344",
/* 89 */	"10455", "16019", "14210", "33712", "91342",
			"37821", "88325", "80851", "43667", "70883",
/* 90 */	"12883", "97343", "65027", "61184", "04285",
			"01392", "17974", "15077", "90712", "26769",
/* 91 */	"21778", "30976", "38807", "36961", "31649",
			"42096", "63281", "02023", "08816", "47449",
/* 92 */	"19523", "59515", "65122", "59659", "86283",
			"68258", "69572", "13798", "16435", "91529",
/* 93 */	"67245", "52670", "35583", "16563", "79246",
			"86686", "76463", "34222", "26655", "90802",
/* 94 */	"60584", "47377", "07500", "37992", "45134",
			"26529", "26760", "83637", "41326", "44344",
/* 95 */	"53853", "41377", "36066", "94850", "58838",
			"73859", "49364", "73331", "96240", "43642",
/* 96 */	"24637", "38736", "74384", "89342", "52623",
			"07992", "12369", "18601", "03742", "83873",
/* 97 */	"83080", "12451", "38992", "22815", "07759",
			"51777", "97377", "27585", "51972", "37867",
/* 98 */	"16444", "24334", "36151", "99073", "27493",
			"70939", "85130", "32552", "54846", "54759",
/* 99 */	"60790", "18157", "57178", "65762", "11161",
			"78576", "45819", "52979", "65130", "04860", 
/* 100 */	"03991", "10461", "93716", "16894", "66083",
			"24653", "84609", "58232", "88618", "19161", 
/* 101 */	"38555", "95554", "32886", "59780", "08355",
			"60860", "29735", "47762", "71299", "23853", 
/* 102 */	"17546", "73704", "92052", "46215", "55121",
			"29281", "59076", "07936", "27954", "58909", 
/* 103 */	"32643", "52861", "95819", "06831", "00911",
			"98936", "76355", "93779", "80863", "00514", 
/* 104 */	"69572", "68777", "39510", "35905", "14060",
			"40619", "29549", "69616", "33564", "60780", 
/* 105 */	"24122", "66591", "27699", "06494", "14845",
			"46672", "61958", "77100", "90899", "75754", 
/* 106 */	"61196", "30231", "92962", "61773", "41839",
			"55382", "17267", "70943", "78038", "70267", 
/* 107 */	"30532", "21704", "10274", "12202", "39685",
			"23309", "10061", "68829", "55986", "66485", 
/* 108 */	"03788", "97599", "75867", "20717", "74416",
			"53166", "35208", "33374", "87539", "08823", 
/* 109 */	"48228", "63379", "85783", "47619", "53152",
			"67433", "35663", "52972", "16818", "60311", 
/* 110 */	"60365", "94653", "35075", "33949", "42614",
			"29297", "01918", "28316", "98953", "73231", 
/* 111 */	"83799", "42402", "56623", "34442", "34994",
			"41374", "70071", "14736", "09958", "18065", 
/* 112 */	"32960", "07405", "36409", "83232", "99385",
			"41600", "11133", "07586", "15917", "06253", 
/* 113 */	"19322", "53845", "57620", "52606", "66497",
			"68646", "78138", "66559", "19640", "99413", 
/* 114 */	"11220", "94747", "07399", "37408", "48509",
			"23929", "27482", "45476", "85244", "35159", 
/* 115 */	"31751", "57260", "68980", "05339", "15470",
			"48355", "88651", "22596", "03152", "19121", 
/* 116 */	"88492", "99382", "14454", "04504", "20094",
			"98977", "74843", "93413", "22109", "78508", 
/* 117 */	"30934", "47744", "07481", "83828", "73788",
			"06533", "28597", "20405", "94205", "20380", 
/* 118 */	"22888", "48893", "27499", "98748", "60530",
			"45128", "74022", "84617", "82037", "10268", 
/* 119 */	"78212", "16993", "35902", "91386", "44372",
			"15486", "65741", "14014", "87481", "37220", 
/* 120 */	"41849", "84547", "46850", "52326", "34677",
			"58300", "74910", "64345", "19325", "81549", 
/* 121 */	"46352", "33049", "69248", "93460", "45305",
			"07521", "61318", "31855", "14413", "70951", 
/* 122 */	"11087", "96294", "14013", "31792", "59747",
			"67277", "76503", "34513", "39663", "77544", 
/* 123 */	"52701", "08337", "56303", "87315", "16520",
			"69676", "11654", "99893", "02181", "68161", 
/* 124 */	"57275", "36898", "81304", "48585", "68652",
			"27376", "92852", "55866", "88448", "03584", 
/* 125 */	"20857", "73156", "70284", "24326", "79375",
			"95220", "01159", "63267", "10622", "48391", 
/* 126 */	"15633", "84924", "90415", "93614", "33521",
			"26665", "55823", "47641", "86225", "31704", 
/* 127 */	"92694", "48297", "39904", "02115", "59589",
			"49067", "66821", "41575", "49767", "04037", 
/* 128 */	"77613", "19019", "88152", "00080", "20554",
			"91409", "96277", "48257", "50816", "97616", 
/* 129 */	"38688", "32486", "45134", "63545", "59404",
			"72059", "43947", "51680", "43852", "59693", 
/* 130 */	"25163", "01889", "70014", "15021", "41290",
			"67312", "71857", "15957", "68971", "11403", 
/* 131 */	"65251", "07629", "37239", "33295", "05870",
			"01119", "92784", "26340", "18477", "65622", 
/* 132 */	"36815", "43625", "18637", "37509", "82444",
			"99005", "04921", "73701", "14707", "93997", 
/* 133 */	"64397", "11692", "05327", "82162", "20247",
			"81759", "45197", "25332", "83745", "22567", 
/* 134 */	"04515", "25624", "95096", "67946", "48460",
			"85558", "15191", "18782", "16930", "33361", 
/* 135 */	"83761", "60873", "43253", "84145", "60833",
			"25983", "01291", "41349", "20368", "07126", 
/* 136 */	"14387", "06345", "80854", "09279", "43529",
			"06318", "38384", "74761", "41196", "37480", 
/* 137 */	"51321", "92246", "80088", "77074", "88722",
			"56736", "66164", "49431", "66919", "31678", 
/* 138 */	"72472", "00008", "80890", "18002", "94813",
			"31900", "54155", "83436", "35352", "54131", 
/* 139 */	"05466", "55306", "93128", "18464", "74457",
			"90561", "72848", "11834", "79982", "68416", 
/* 140 */	"39528", "72484", "82474", "25593", "48545",
			"35247", "18619", "13674", "18611", "19241", 
/* 141 */	"81616", "18711", "53342", "44276", "75122",
			"11724", "74627", "73707", "58319", "15997", 
/* 142 */	"07586", "16120", "82641", "22820", "92904",
			"13141", "32392", "19763", "61199", "67940", 
/* 143 */	"90767", "04235", "13574", "17200", "69902",
			"63742", "78464", "22501", "18627", "90872", 
/* 144 */	"40188", "28193", "29593", "88627", "94972",
			"11598", "62095", "36787", "00441", "58997", 
/* 145 */	"34414", "82157", "86887", "55087", "19152",
			"00023", "12302", "80783", "32624", "68691", 
/* 146 */	"63439", "75363", "44989", "16822", "36024",
			"00867", "76378", "41605", "65961", "73488", 
/* 147 */	"67049", "09070", "93399", "45547", "94458",
			"74284", "05041", "49807", "20288", "34060", 
/* 148 */	"79495", "04146", "52162", "90286", "54158",
			"34243", "46978", "35482", "59362", "95938", 
/* 149 */	"91704", "30552", "04737", "21031", "75051",
			"93029", "47665", "64382", "99782", "93478", 
/* 150 */	"94015", "46874", "32444", "48277", "59820",
			"96163", "64654", "25843", "41145", "42820", 
/* 151 */	"74108", "88222", "88570", "74015", "25704",
			"91035", "01755", "14750", "48968", "38603", 
/* 152 */	"62880", "87873", "95160", "59221", "22304",
			"90314", "72877", "17334", "39283", "04149", 
/* 153 */	"11748", "12102", "80580", "41867", "17710",
			"59621", "06554", "07850", "73950", "79552", 
/* 154 */	"17944", "05600", "60478", "03343", "25852",
			"58905", "57216", "39618", "49856", "99326", 
/* 155 */	"66067", "42792", "95043", "52680", "46780",
			"56487", "09971", "59481", "37006", "22186", 
/* 156 */	"54244", "91030", "45547", "70818", "59849",
			"96169", "61459", "21647", "87417", "17198", 
/* 157 */	"30945", "57589", "31732", "57260", "47670",
			"07654", "46376", "25366", "94746", "49580", 
/* 158 */	"69170", "37403", "86995", "90307", "94304",
			"71803", "26825", "05511", "12459", "91314", 
/* 159 */	"08345", "88975", "35841", "85771", "08105",
			"59987", "87112", "21476", "14713", "71181", 
/* 160 */	"27767", "43584", "85301", "88977", "29490",
			"69714", "73035", "41207", "74699", "09310", 
/* 161 */	"13025", "14338", "54066", "15243", "47724",
			"66733", "47431", "43905", "31048", "56699", 
/* 162 */	"80217", "36292", "98525", "24335", "24432",
			"24896", "43277", "58874", "11466", "16082", 
/* 163 */	"10875", "62004", "90391", "61105", "57411",
			"06368", "53856", "30743", "08670", "84741", 
/* 164 */	"54127", "57326", "26629", "19087", "24472",
			"88779", "30540", "27886", "61732", "75454", 
/* 165 */	"60311", "42824", "37301", "42678", "45990",
			"43242", "17374", "52003", "70707", "70214", 
/* 166 */	"49739", "71484", "92003", "98086", "76668",
			"73209", "59202", "11973", "02902", "33250", 
/* 167 */	"78626", "51594", "16453", "94614", "39014",
			"97066", "83012", "09832", "25571", "77628", 
/* 168 */	"66692", "13986", "99837", "00582", "81232",
			"44987", "09504", "96412", "90193", "79568", 
/* 169 */	"44071", "28091", "07362", "97703", "76447",
			"42537", "98524", "97831", "65704", "09514", 
/* 170 */	"41468", "85149", "49554", "17994", "14924",
			"39650", "95294", "00556", "70481", "06905", 
/* 171 */	"94559", "37559", "49678", "53119", "70312",
			"05682", "66986", "34099", "74474", "20740", 
/* 172 */	"41615", "70360", "64114", "58660", "90850",
			"64618", "80620", "51790", "11436", "38072", 
/* 173 */	"50273", "93113", "41794", "86861", "24781",
			"89683", "55411", "85667", "77535", "99892", 
/* 174 */	"41396", "80504", "90670", "08289", "40902",
			"05069", "95083", "06783", "28102", "57816", 
/* 175 */	"25807", "24260", "71529", "78920", "72682",
			"07385", "90726", "57166", "98884", "08583", 
/* 176 */	"06170", "97965", "88302", "98041", "21443",
			"41808", "68984", "83620", "89747", "98882", 
/* 177 */	"60808", "54444", "74412", "81105", "01176",
			"28838", "36421", "16489", "18059", "51061", 
/* 178 */	"80940", "44893", "10408", "36222", "80582",
			"71944", "92638", "40333", "67054", "16067", 
/* 179 */	"19516", "90120", "46759", "71643", "13177",
			"55292", "21036", "82808", "77501", "97427", 
/* 180 */	"49386", "54480", "23604", "23554", "21785",
			"41101", "91178", "10174", "29420", "90438", 
/* 181 */	"06312", "88940", "15995", "69321", "47458",
			"64809", "98189", "81851", "29651", "84215", 
/* 182 */	"60942", "00307", "11897", "92674", "40405",
			"68032", "96717", "54244", "10701", "41393", 
/* 183 */	"92329", "98932", "78284", "46347", "71209",
			"92061", "39448", "93136", "25722", "08564", 
/* 184 */	"77936", "63574", "31384", "51924", "85561",
			"29671", "58137", "17820", "22751", "36518", 
/* 185 */	"38101", "77756", "11657", "13897", "95889",
			"57067", "47648", "13885", "70669", "93406", 
/* 186 */	"39641", "69457", "91339", "22502", "92613",
			"89719", "11947", "56203", "19324", "20504", 
/* 187 */	"84054", "40455", "99396", "63680", "67667",
			"60631", "69181", "96845", "38525", "11600", 
/* 188 */	"47468", "03577", "57649", "63266", "24700",
			"71594", "14004", "23153", "69249", "05747", 
/* 189 */	"43321", "31370", "28977", "23896", "76479",
			"68562", "62342", "07589", "08899", "05985", 
/* 190 */	"64281", "61826", "18555", "64937", "13173",
			"33365", "78851", "16499", "87064", "13075", 
/* 191 */	"66847", "70495", "32350", "02985", "86716",
			"38746", "26313", "77463", "55387", "72681", 
/* 192 */	"72461", "33230", "21529", "53424", "92581",
			"02262", "78438", "66276", "18396", "73538", 
/* 193 */	"21032", "91050", "13058", "16218", "12470",
			"56500", "15292", "76139", "59526", "52113", 
/* 194 */	"95362", "67011", "06651", "16136", "01016",
			"00857", "55018", "56374", "35824", "71708", 
/* 195 */	"49712", "97380", "10404", "55452", "34030",
			"60726", "75211", "10271", "36633", "68424", 
/* 196 */	"58275", "61764", "97586", "54716", "50259",
			"46345", "87195", "46092", "26787", "60939", 
/* 197 */	"89514", "11788", "68224", "23417", "73959",
			"76145", "30342", "40277", "11049", "72049", 
/* 198 */	"15472", "50669", "48139", "36732", "46874",
			"37088", "73465", "09819", "58869", "35220", 
/* 199 */	"12120", "86124", "51247", "44302", "60883",
			"52109", "21437", "36786", "49226", "77837", 
/* 200 */	"19612", "78430", "11661", "94770", "77603",
			"65669", "86868", "12665", "30012", "75989", 
/* 201 */	"39141", "77400", "28000", "64238", "73258",
			"71794", "31340", "26256", "66453", "37016", 
/* 202 */	"64756", "80457", "08747", "12836", "03469",
			"50678", "03274", "43423", "66677", "82556", 
/* 203 */	"92901", "51878", "56441", "22998", "29718",
			"38447", "06453", "25311", "07565", "53771", 
/* 204 */	"03551", "90070", "09483", "94050", "45938",
			"18135", "36908", "43321", "11073", "51803", 
/* 205 */	"98884", "66209", "06830", "53656", "14663",
			"56346", "71430", "04909", "19818", "05707", 
/* 206 */	"27369", "86882", "53473", "07541", "53633",
			"70863", "03748", "12822", "19360", "49088", 
/* 207 */	"59066", "75974", "63335", "20483", "43514",
			"37481", "58278", "26967", "49325", "43951", 
/* 208 */	"91647", "93783", "64169", "49022", "98588",
			"09495", "49829", "59068", "38831", "04838", 
/* 209 */	"83605", "92419", "39542", "07772", "71568",
			"75673", "35185", "89759", "44901", "74291", 
/* 210 */	"24895", "88530", "70774", "35439", "46758",
			"70472", "70207", "92675", "91623", "61275", 
/* 211 */	"35720", "26556", "95596", "20094", "73750",
			"85788", "34264", "01703", "46833", "65248", 
/* 212 */	"14141", "53410", "38649", "06343", "57256",
			"61342", "72709", "75318", "90379", "37562", 
/* 213 */	"27416", "75670", "92176", "72535", "93119",
			"56077", "06886", "18244", "92344", "31374", 
/* 214 */	"82071", "07429", "81007", "47749", "40744",
			"56974", "23336", "88821", "53841", "10536", 
/* 215 */	"21445", "82793", "24831", "93241", "14199",
			"76268", "70883", "68002", "03829", "17443", 
/* 216 */	"72513", "76400", "52225", "92348", "62308",
			"98481", "29744", "33165", "33141", "61020", 
/* 217 */	"71479", "45027", "76160", "57411", "13780",
			"13632", "52308", "77762", "88874", "33697", 
/* 218 */	"83210", "51466", "09088", "50395", "26743",
			"05306", "21706", "70001", "99439", "80767", 
/* 219 */	"68749", "95148", "94897", "78636", "96750",
			"09024", "94538", "91143", "96693", "61886", 
/* 220 */	"05184", "75763", "47075", "88158", "05313",
			"53439", "14908", "08830", "60096", "21551", 
/* 221 */	"13651", "62546", "96892", "25240", "47511",
			"58483", "87342", "78818", "07855", "39269", 
/* 222 */	"00566", "21220", "00292", "24069", "25072",
			"29519", "52548", "54091", "21282", "21296", 
/* 223 */	"50958", "17695", "58072", "68990", "60329",
			"95955", "71586", "63417", "35947", "67807", 
/* 224 */	"57621", "64547", "46850", "37981", "38527",
			"09037", "64756", "03324", "04986", "83666", 
/* 225 */	"09282", "25844", "79139", "78435", "35428",
			"43561", "69799", "63314", "12991", "93516", 
/* 226 */	"23394", "94206", "93432", "37836", "94919",
			"26846", "02555", "74410", "94915", "48199", 
/* 227 */	"05280", "37470", "93622", "04345", "15092",
			"19510", "18094", "16613", "78234", "50001", 
/* 228 */	"95491", "97976", "38306", "32192", "82639",
			"54624", "72434", "92606", "23191", "74693", 
/* 229 */	"78521", "00104", "18248", "75583", "90326",
			"50785", "54034", "66251", "35774", "14692", 
/* 230 */	"96345", "44579", "85932", "44053", "75704",
			"20840", "86583", "83944", "52456", "73766", 
/* 231 */	"77963", "31151", "32364", "91691", "47357",
			"40338", "23435", "24065", "08458", "95366", 
/* 232 */	"07520", "11294", "23238", "01748", "41690",
			"67328", "54814", "37777", "10057", "42332", 
/* 233 */	"38423", "02309", "70703", "85736", "46148",
			"14258", "29236", "12152", "05088", "65825", 
/* 234 */	"02463", "65533", "21199", "60555", "33928",
			"01817", "07396", "89215", "30722", "22102", 
/* 235 */	"15880", "92261", "17292", "88190", "61781",
			"48898", "92525", "21283", "88581", "60098", 
/* 236 */	"71926", "00819", "59144", "00224", "30570",
			"90194", "18329", "06999", "26857", "19238", 
/* 237 */	"64425", "28108", "16554", "16016", "00042",
			"83229", "10333", "36168", "65617", "94834", 
/* 238 */	"79782", "23924", "49440", "30432", "81077",
			"31543", "95216", "64865", "13658", "51081", 
/* 239 */	"35337", "74538", "44553", "64672", "90960",
			"41849", "93865", "44608", "93176", "34851", 
/* 240 */	"05249", "29329", "19715", "94082", "14738",
			"86667", "43708", "66354", "93692", "25527", 
/* 241 */	"56463", "99380", "38793", "85774", "19056",
			"13939", "46062", "27647", "66146", "63210", 
/* 242 */	"96296", "33121", "54196", "34108", "75814",
			"85986", "71171", "15102", "28992", "63165", 
/* 243 */	"98380", "36269", "60014", "07201", "62448",
			"46385", "42175", "88350", "46182", "49126", 
/* 244 */	"52567", "64350", "16315", "53969", "80395",
			"81114", "54358", "64578", "47269", "15747", 
/* 245 */	"78498", "90830", "25955", "99236", "43286",
			"91064", "99969", "95144", "64424", "77377", 
/* 246 */	"49553", "24241", "08150", "89535", "08703",
			"91041", "77323", "81079", "45127", "93686", 
/* 247 */	"32151", "07075", "83155", "10252", "73100",
			"88618", "23891", "87418", "45417", "20268", 
/* 248 */	"11314", "50363", "26860", "27799", "49416",
			"83534", "19187", "08059", "76677", "02110", 
/* 249 */	"12364", "71210", "87052", "50241", "90785",
			"97889", "81399", "58130", "64439", "05614", 
/* 250 */	"59467", "58309", "87834", "57213", "37510",
			"33689", "01259", "62486", "56320", "46265", 
/* 251 */	"73452", "17619", "56421", "40725", "23439",
			"41701", "93223", "41682", "45026", "47505", 
/* 252 */	"27635", "56293", "91700", "04391", "67317",
			"89604", "73020", "69853", "61517", "51207", 
/* 253 */	"86040", "02596", "01655", "09918", "45161",
			"00222", "54577", "74821", "47335", "08582", 
/* 254 */	"52403", "94255", "26351", "46527", "68224",
			"90183", "85057", "72310", "34963", "83462", 
/* 255 */	"49465", "46581", "61499", "04844", "94626",
			"02963", "41482", "83879", "44942", "63915", 
/* 256 */	"94365", "92560", "12363", "30246", "02086",
			"75036", "88620", "91088", "67691", "67762", 
/* 257 */	"34261", "08769", "91830", "23313", "18256",
			"28850", "37639", "92748", "57791", "71328", 
/* 258 */	"37110", "66538", "39318", "15626", "44324",
			"82827", "08782", "65960", "58167", "01305", 
/* 259 */	"83950", "45424", "72453", "19444", "68219",
			"64733", "94088", "62006", "89985", "36936", 
/* 260 */	"61630", "97966", "76537", "46467", "30942",
			"07479", "67971", "14558", "22458", "35148", 
/* 261 */	"01929", "17165", "12037", "74558", "16250",
			"71750", "55546", "29693", "94984", "37782", 
/* 262 */	"41659", "39098", "23982", "29899", "71594",
			"77979", "54477", "13764", "17315", "72893", 
/* 263 */	"32031", "39608", "75992", "73445", "01317",
			"50525", "87313", "45191", "30214", "19769", 
/* 264 */	"90043", "93478", "58044", "06949", "31176",
			"88370", "50274", "83987", "45316", "38551", 
/* 265 */	"79418", "14322", "91065", "07841", "36130",
			"86602", "10659", "40859", "00964", "71577", 
/* 266 */	"85447", "61079", "96910", "72906", "07361",
			"84338", "34114", "52096", "66715", "51091", 
/* 267 */	"86219", "81115", "49625", "48799", "89485",
			"24855", "13684", "68433", "70595", "70102", 
/* 268 */	"71712", "88559", "92476", "32903", "68009",
			"58417", "87962", "11787", "16644", "72964", 
/* 269 */	"29776", "63075", "13270", "84758", "49560",
			"10317", "28778", "23006", "31036", "84906", 
/* 270 */	"81488", "17340", "74154", "42801", "27917",
			"89792", "62604", "62234", "13124", "76471", 
/* 271 */	"51667", "37589", "87147", "24743", "48023",
			"06325", "79794", "35889", "13255", "04925", 
/* 272 */	"99004", "70322", "60832", "76636", "56907",
			"56534", "72615", "46288", "36788", "93196", 
/* 273 */	"68656", "66492", "35933", "52293", "47953",
			"95495", "95304", "50009", "83464", "28608", 
/* 274 */	"38074", "74083", "09337", "07965", "65047",
			"36871", "59015", "21769", "30398", "44855", 
/* 275 */	"01020", "80680", "59328", "08712", "48190",
			"45332", "27284", "31287", "66011", "09376", 
/* 276 */	"86379", "74508", "33579", "77114", "92955",
			"23085", "92824", "03054", "25242", "16322", 
/* 277 */	"48498", "09938", "44420", "13484", "52319",
			"58875", "02012", "88591", "52500", "95795", 
/* 278 */	"41800", "95363", "54142", "17482", "32705",
			"60564", "12505", "40954", "46174", "64130", 
/* 279 */	"63026", "96712", "79883", "39225", "52653",
			"69549", "36693", "59822", "22684", "31661", 
/* 280 */	"88298", "15489", "16030", "42480", "15372",
			"38781", "71995", "77438", "91161", "10192", 
/* 281 */	"07839", "62735", "99218", "25624", "02547",
			"27445", "69187", "55749", "32322", "15504", 
/* 282 */	"73298", "51108", "48717", "92926", "75705",
			"89787", "96114", "99902", "37749", "96305", 
/* 283 */	"12829", "70474", "00838", "50385", "91711",
			"80370", "56504", "56857", "80906", "09018", 
/* 284 */	"76569", "61072", "48568", "36491", "22587",
			"44363", "39592", "61546", "90181", "37348", 
/* 285 */	"41665", "41339", "62106", "44203", "06732",
			"76111", "79840", "67999", "32231", "76869", 
/* 286 */	"58652", "49983", "01669", "27464", "79553",
			"52855", "25988", "18087", "38052", "17529", 
/* 287 */	"13607", "00657", "76173", "43357", "77334",
			"24140", "53860", "02906", "89863", "44651", 
/* 288 */	"55715", "26203", "65933", "51087", "98234",
			"40625", "45545", "63563", "89148", "82581", 
/* 289 */	"04110", "66683", "99001", "09796", "47349",
			"65003", "66524", "81970", "71262", "14479", 
/* 290 */	"31300", "08681", "58068", "44115", "40064",
			"77879", "23965", "69019", "73985", "19453", 
/* 291 */	"26225", "97543", "37044", "07494", "85778",
			"35345", "61115", "92498", "49737", "64599", 
/* 292 */	"07158", "82763", "25072", "38478", "57782",
			"75291", "62155", "52056", "04786", "11585", 
/* 293 */	"71251", "25572", "79771", "93328", "66927",
			"54069", "58752", "26624", "50463", "77361", 
/* 294 */	"29991", "96526", "02820", "91659", "12818",
			"96356", "49499", "01507", "40223", "09171", 
/* 295 */	"83642", "21057", "02677", "09367", "38097",
			"16100", "19355", "06120", "15378", "56559", 
/* 296 */	"69167", "30235", "06767", "66323", "78294",
			"14916", "19124", "88044", "16673", "66102", 
/* 297 */	"86018", "29406", "75415", "22038", "27056",
			"26906", "25867", "14751", "92380", "30434", 
/* 298 */	"44114", "06026", "79553", "55091", "95385",
			"41212", "37882", "46864", "54717", "97038", 
/* 299 */	"53805", "64150", "70915", "63127", "63695",
			"41288", "38192", "72437", "75075", "18570", 
/* 300 */	"52065", "08853", "30104", "79937", "66913",
			"53200", "84570", "78079", "28970", "53859", 
/* 301 */	"37632", "80274", "35240", "32960", "74859",
			"07359", "55176", "03930", "38984", "35151", 
/* 302 */	"82576", "82805", "94031", "12779", "90879",
			"24109", "25367", "77861", "09541", "85739", 
/* 303 */	"69023", "64971", "99321", "07521", "95909",
			"43897", "71724", "92581", "05471", "64337", 
/* 304 */	"98949", "03606", "78236", "78985", "29212",
			"57369", "34857", "67757", "58019", "58872", 
/* 305 */	"96526", "28749", "56592", "37871", "72905",
			"70198", "57319", "54116", "47014", "18285", 
/* 306 */	"33692", "72111", "60958", "96848", "17893",
			"40993", "50445", "14186", "76877", "87867", 
/* 307 */	"50335", "09513", "44346", "26439", "55293",
			"06449", "44301", "63740", "40158", "72703", 
/* 308 */	"88321", "85062", "57345", "66231", "15409",
			"03451", "95261", "43561", "15673", "28956", 
/* 309 */	"90303", "62469", "82517", "43035", "36850",
			"15592", "64098", "59022", "31752", "04370", 
/* 310 */	"50486", "11885", "23085", "41712", "80692",
			"48492", "16495", "99721", "36912", "28267", 
/* 311 */	"27882", "16269", "64483", "11273", "02680",
			"01616", "46138", "54606", "14761", "05134", 
/* 312 */	"45144", "63213", "49666", "27441", "86989",
			"29884", "54334", "06740", "08368", "80051", 
/* 313 */	"81020", "17882", "74973", "74531", "94994",
			"24927", "64894", "22667", "20466", "82948", 
/* 314 */	"66831", "47427", "76033", "31197", "59817",
			"20064", "61135", "28556", "29695", "80179", 
/* 315 */	"74058", "18293", "09963", "35278", "13062",
			"83094", "23373", "90287", "33477", "48865", 
/* 316 */	"30348", "70174", "11468", "25994", "25343",
			"22317", "01587", "30682", "00001", "67814", 
/* 317 */	"59557", "23362", "13746", "82244", "42093",
			"24671", "79458", "93730", "45488", "60234", 
/* 318 */	"67098", "09899", "25775", "00332", "36636",
			"57594", "19958", "85564", "58977", "12247", 
/* 319 */	"60774", "66371", "69442", "20385", "14486",
			"91330", "50332", "46023", "75768", "59877", 
/* 320 */	"60081", "92936", "72302", "75064", "85727",
			"52987", "05750", "19384", "33684", "78859", 
/* 321 */	"80458", "69902", "34870", "88684", "49762",
			"40801", "86291", "18194", "90366", "82639", 
/* 322 */	"53844", "96326", "65728", "48563", "26027",
			"52692", "62406", "76294", "41848", "63010", 
/* 323 */	"69841", "29451", "36170", "21529", "16525",
			"64326", "22086", "24469", "57407", "96033", 
/* 324 */	"37771", "31002", "18311", "93285", "31948",
			"14331", "58335", "15977", "80336", "81667", 
/* 325 */	"27286", "24361", "61638", "57580", "95270",
			"46180", "76990", "53031", "94366", "02727", 
/* 326 */	"49944", "19278", "05756", "51875", "53445",
			"33342", "01965", "07937", "10054", "97712", 
/* 327 */	"87693", "58124", "46064", "39133", "77385",
			"09605", "65359", "70113", "90563", "86637", 
/* 328 */	"94282", "12025", "31926", "24541", "23854",
			"58407", "32131", "92845", "20714", "27898", 
/* 329 */	"26917", "50326", "35145", "50859", "72119",
			"95094", "29441", "42301", "62460", "75252", 
/* 330 */	"94267", "38422", "73047", "24200", "85349",
			"72049", "91723", "97802", "98496", "12734", 
/* 331 */	"73432", "10371", "57213", "53300", "80847",
			"46229", "07099", "72961", "13767", "65654", 
/* 332 */	"31102", "82119", "96946", "65919", "81083",
			"03819", "57888", "57908", "16849", "77111", 
/* 333 */	"41429", "92261", "45263", "01172", "55926",
			"78835", "27697", "48420", "58865", "41207", 
/* 334 */	"21406", "08582", "10785", "36233", "12237",
			"07866", "13706", "92551", "11021", "63813", 
/* 335 */	"71512", "65206", "37768", "94325", "14721",
			"20990", "54235", "71986", "05345", "56239", 
/* 336 */	"52028", "01419", "07215", "55067", "11669",
			"21738", "66605", "69621", "69827", "08537", 
/* 337 */	"18638", "60982", "28151", "98885", "76431",
			"25566", "03085", "23639", "30849", "63986", 
/* 338 */	"73287", "26201", "36174", "14106", "54102",
			"57041", "16141", "64174", "03591", "90024", 
/* 339 */	"73332", "31254", "17288", "59809", "25061",
			"51612", "47951", "16570", "43330", "79213", 
/* 340 */	"11354", "55585", "19646", "99246", "37564",
			"32660", "20632", "21124", "60597", "69315", 
/* 341 */	"31312", "57741", "85108", "21615", "24365",
			"27684", "16124", "33888", "14966", "35303", 
/* 342 */	"69921", "15795", "04020", "67672", "86816",
			"63027", "84470", "45605", "44887", "26222", 
/* 343 */	"79888", "58982", "22466", "98844", "48353",
			"60666", "58256", "31140", "93507", "69561", 
/* 344 */	"06256", "88526", "18655", "00865", "75247",
			"00264", "65957", "98261", "72706", "36396", 
/* 345 */	"46065", "85700", "32121", "99975", "73627",
			"78812", "89638", "86602", "96758", "65099", 
/* 346 */	"52777", "46792", "13790", "55240", "52002",
			"10313", "91933", "71231", "10053", "78416", 
/* 347 */	"54563", "96004", "42215", "30094", "45958",
			"48437", "49591", "50483", "13422", "69108", 
/* 348 */	"59952", "27896", "40450", "79327", "31962",
			"46456", "39260", "51479", "61882", "48181", 
/* 349 */	"50691", "64709", "32902", "10676", "12083",
			"35771", "79656", "56667", "76783", "03937", 
/* 350 */	"99859", "10362", "57411", "40986", "35045",
			"02838", "29255", "64230", "84418", "34988", 
/* 351 */	"77644", "39892", "77327", "74129", "53444",
			"35487", "95803", "38640", "20383", "55402", 
/* 352 */	"25793", "14213", "87082", "42837", "95030",
			"97198", "61608", "97723", "79390", "35290", 
/* 353 */	"34683", "81419", "87133", "70447", "53127",
			"97146", "28299", "56763", "12868", "01145", 
/* 354 */	"12147", "58158", "92124", "60934", "18414",
			"97510", "07056", "54488", "20719", "53743", 
/* 355 */	"91037", "44797", "52110", "08512", "18991",
			"20129", "31441", "51449", "14661", "71126", 
/* 356 */	"23180", "68124", "18807", "70997", "21913",
			"19594", "70355", "73637", "68266", "60775", 
/* 357 */	"43164", "52643", "96363", "77989", "79332",
			"39890", "65379", "20405", "52935", "43816", 
/* 358 */	"92740", "95319", "04538", "60660", "28982",
			"15328", "80475", "34690", "02293", "19646", 
/* 359 */	"46524", "96627", "33159", "42081", "08816",
			"74931", "20674", "08697", "66169", "46460", 
/* 360 */	"46326", "39923", "60625", "28386", "22919",
			"19415", "75766", "43668", "31626", "70301", 
/* 361 */	"67053", "03949", "70082", "02303", "48642",
			"38429", "94053", "38770", "68137", "68441", 
/* 362 */	"52928", "70244", "91954", "17401", "92693",
			"98342", "21451", "84988", "80487", "33807", 
/* 363 */	"73797", "49494", "41878", "76635", "83227",
			"76618", "11946", "13451", "87591", "78381", 
/* 364 */	"21407", "90038", "72638", "69692", "51599",
			"86413", "32019", "64856", "74730", "41531", 
/* 365 */	"11064", "01790", "58817", "86400", "66213",
			"92599", "70905", "78324", "54326", "43659", 
/* 366 */	"34206", "63132", "38837", "40210", "96346",
			"16967", "81619", "96503", "14881", "89405", 
/* 367 */	"32205", "49508", "98425", "02451", "35423",
			"56072", "36810", "30332", "85998", "49358", 
/* 368 */	"92748", "84147", "79835", "94867", "41224",
			"61794", "35066", "82220", "66684", "20096", 
/* 369 */	"02754", "41731", "37068", "32753", "91059",
			"13407", "05607", "69384", "53329", "95909", 
/* 370 */	"44968", "11397", "92973", "50014", "92997",
			"80968", "93761", "57598", "74703", "07768", 
/* 371 */	"37978", "73873", "33475", "09720", "97852",
			"98449", "48722", "84977", "11271", "11728", 
/* 372 */	"68318", "22312", "78792", "87508", "88466",
			"72976", "47099", "84126", "38595", "85124", 
/* 373 */	"64405", "90020", "07492", "52413", "95111",
			"34455", "86311", "68892", "01074", "60274", 
/* 374 */	"28136", "19328", "38161", "57475", "13771",
			"63562", "84207", "94121", "18901", "52768", 
/* 375 */	"33801", "82087", "86091", "59969", "90398",
			"56870", "55756", "78841", "98450", "54165", 
/* 376 */	"55106", "50343", "70519", "14567", "36780",
			"55450", "19606", "83749", "67562", "64765", 
/* 377 */	"38543", "16585", "86841", "73742", "08766",
			"39252", "75678", "75379", "78760", "37279", 
/* 378 */	"15280", "13558", "95916", "89759", "76686",
			"76467", "67147", "63110", "94008", "08037", 
/* 379 */	"35263", "53710", "16667", "79008", "11231",
			"29397", "67136", "18601", "64502", "90228", 
/* 380 */	"89109", "72849", "22711", "65547", "34542",
			"26686", "81678", "87765", "77654", "23664", 
/* 381 */	"96352", "14106", "32938", "28083", "18633",
			"80286", "65507", "46197", "52722", "75476", 
/* 382 */	"77816", "47204", "34876", "45963", "79262",
			"90181", "84041", "03745", "90041", "30780", 
/* 383 */	"27226", "92847", "85572", "15308", "80688",
			"05761", "82638", "13464", "23683", "81015", 
/* 384 */	"54214", "64175", "43701", "86845", "15569",
			"50687", "52679", "87696", "08285", "97444", 
/* 385 */	"47599", "94472", "64150", "87753", "68652",
			"60726", "26213", "17320", "64553", "81285", 
/* 386 */	"98126", "12158", "52095", "64833", "00492",
			"35817", "55571", "91300", "97812", "37507", 
/* 387 */	"04209", "53515", "64342", "21223", "16662",
			"43265", "68219", "03529", "43636", "68417", 
/* 388 */	"53640", "95326", "93381", "37113", "80751",
			"76469", "96677", "43054", "22937", "31954", 
/* 389 */	"13266", "34140", "27253", "02734", "99070",
			"60077", "57988", "93211", "92795", "83795", 
/* 390 */	"57477", "03941", "39007", "14619", "38320",
			"93449", "31336", "25279", "97030", "26245", 
/* 391 */	"47394", "39475", "90621", "23820", "29344",
			"94859", "91604", "14033", "41868", "14816", 
/* 392 */	"04075", "66644", "87803", "97815", "99552",
			"78666", "03942", "08175", "22345", "19983", 
/* 393 */	"76783", "99044", "20851", "84981", "59052",
			"77178", "72109", "76475", "21619", "73017", 
/* 394 */	"06812", "56633", "50612", "55289", "04671",
			"84419", "94072", "94446", "80603", "32188", 
/* 395 */	"93415", "23464", "43947", "43728", "74284",
			"67177", "57105", "31059", "10642", "13803", 
/* 396 */	"69602", "46961", "66567", "19359", "84676",
			"63918", "40650", "12923", "15974", "79732", 
/* 397 */	"20225", "92525", "71179", "04859", "91208",
			"60430", "05239", "61458", "24089", "68852", 
/* 398 */	"60171", "29603", "42535", "86365", "93905",
			"28237", "45317", "60718", "82001", "41679", 
/* 399 */	"20679", "56304", "70043", "87568", "21386",
			"59049", "78353", "48696", "77379", "55309", 
/* 400 */	"23780", "28391", "05940", "55583", "81256",
			"59418", "97521", "32846", "70761", "90115", 
/* 401 */	"45325", "05490", "65974", "11186", "15357",
			"03568", "00450", "96644", "58976", "36211", 
/* 402 */	"88240", "92457", "89200", "94696", "11370",
			"91157", "48487", "59501", "56983", "89795", 
/* 403 */	"42789", "69758", "79701", "29511", "55968",
			"41472", "89474", "84344", "80517", "07485", 
/* 404 */	"97523", "17264", "82840", "59556", "37119",
			"30985", "48866", "60605", "95719", "70417", 
/* 405 */	"59083", "95137", "76538", "44155", "67286",
			"57897", "28262", "04052", "00919", "86207", 
/* 406 */	"79932", "44236", "10089", "44373", "65670",
			"44285", "06903", "20834", "49701", "95735", 
/* 407 */	"21149", "03425", "17594", "31427", "14262",
			"32252", "68540", "39427", "44026", "47257", 
/* 408 */	"45055", "95091", "08367", "28381", "57375",
			"41562", "83883", "27715", "10122", "67745", 
/* 409 */	"46497", "28626", "87297", "36568", "39483",
			"11385", "63292", "92305", "78683", "06146", 
/* 410 */	"81905", "15038", "38338", "51206", "65749",
			"34119", "71516", "74068", "51094", "06665", 
/* 411 */	"91884", "66762", "11428", "70908", "21506",
			"00480", "94183", "78484", "66507", "75901", 
/* 412 */	"25728", "52539", "86806", "69944", "65036",
			"27882", "02530", "04918", "74351", "65737", 
/* 413 */	"89178", "08791", "39342", "94963", "22581",
			"56917", "17541", "83578", "75376", "65202", 
/* 414 */	"30935", "79270", "91986", "99286", "45236",
			"44720", "81915", "70881", "45886", "43213", 
/* 415 */	"49789", "97081", "16075", "20517", "69980",
			"25310", "91953", "01759", "67635", "88933", 
/* 416 */	"54558", "18395", "73375", "62251", "58871",
			"09870", "70538", "48936", "07757", "90374", 
/* 417 */	"56631", "88862", "30487", "38794", "36079",
			"32712", "11130", "55451", "25137", "38785", 
/* 418 */	"83558", "31960", "69473", "45950", "18225",
			"09871", "88502", "75179", "11551", "75664", 
/* 419 */	"74321", "67351", "27703", "83717", "18913",
			"42470", "08816", "37627", "14288", "62831", 
/* 420 */	"44047", "67612", "72738", "26995", "50933",
			"63758", "50003", "43693", "52661", "55852", 
/* 421 */	"52372", "59042", "37595", "04931", "73622",
			"68387", "86478", "40997", "05245", "75300", 
/* 422 */	"24902", "59609", "35653", "15970", "37681",
			"69365", "22236", "86374", "65550", "00343", 
/* 423 */	"98377", "35354", "65770", "15365", "41422",
			"71356", "16630", "40044", "19290", "66449", 
/* 424 */	"53629", "79452", "71674", "30260", "97303",
			"06487", "62789", "13005", "70152", "22501", 
/* 425 */	"49867", "89294", "59232", "31776", "54919",
			"99851", "05438", "01096", "72269", "50486", 
/* 426 */	"16719", "06144", "82041", "38332", "64452",
			"31840", "99287", "59928", "25503", "08407", 
/* 427 */	"46970", "45907", "99238", "74547", "19704",
			"72035", "26542", "54600", "79172", "58779", 
/* 428 */	"35747", "78956", "11478", "41195", "58135",
			"63856", "33037", "45753", "60159", "25193", 
/* 429 */	"71838", "07526", "07985", "60714", "88627",
			"75790", "38454", "96110", "39237", "19792", 
/* 430 */	"34534", "70169", "24805", "63215", "38175",
			"38784", "38855", "24826", "50917", "25147", 
/* 431 */	"17082", "26997", "32295", "10894", "21805",
			"65245", "85407", "37926", "69214", "38579", 
/* 432 */	"84721", "23544", "88548", "65626", "75517",
			"69737", "55626", "52175", "21697", "19453", 
/* 433 */	"16908", "82841", "24060", "40285", "19195",
			"80281", "89322", "15232", "70043", "60691", 
/* 434 */	"86370", "91949", "19017", "83846", "77869",
			"14321", "95102", "87073", "71467", "31305", 
/* 435 */	"64677", "80358", "52629", "79419", "22359",
			"87867", "48296", "50141", "46807", "82184", 
/* 436 */	"95812", "84665", "74511", "59914", "04146",
			"90417", "58508", "62875", "17630", "21868", 
/* 437 */	"09199", "30322", "33352", "43374", "25473",
			"04119", "63086", "14147", "14863", "38020", 
/* 438 */	"44757", "98628", "57916", "22199", "11865",
			"42911", "62651", "78290", "09392", "77294", 
/* 439 */	"63168", "21043", "17409", "13786", "27475",
			"75979", "89668", "43596", "74316", "84489", 
/* 440 */	"54941", "95992", "45445", "41059", "55142",
			"15214", "42903", "16799", "88254", "95984", 
/* 441 */	"48575", "77822", "21067", "57238", "35352",
			"96779", "89564", "23797", "99937", "46379", 
/* 442 */	"27119", "16060", "30302", "95327", "12849",
			"38111", "97090", "07598", "78473", "63079", 
/* 443 */	"18570", "72803", "70040", "91385", "96436",
			"96263", "17368", "56188", "85999", "50026", 
/* 444 */	"36050", "73736", "13351", "48321", "28357",
			"51718", "65636", "72903", "21584", "21060", 
/* 445 */	"39829", "15564", "04716", "14594", "22363",
			"97639", "65937", "17802", "31535", "42767", 
/* 446 */	"98761", "30987", "57657", "33398", "63053",
			"25926", "20944", "19306", "81727", "02695", 
/* 447 */	"97479", "79172", "72764", "66446", "78864",
			"12698", "15812", "97209", "38827", "91016", 
/* 448 */	"91281", "57875", "45228", "49211", "69755",
			"99224", "43999", "62879", "08879", "80015", 
/* 449 */	"74396", "57146", "64665", "31159", "06980",
			"79069", "37409", "75037", "69977", "85919", 
/* 450 */	"42826", "06974", "61063", "97640", "13433",
			"92528", "91311", "08440", "38840", "22362", 
/* 451 */	"93929", "01836", "36590", "75052", "89475",
			"15437", "65648", "99012", "70236", "12307", 
/* 452 */	"83585", "00414", "62851", "48787", "28447",
			"21702", "57033", "29633", "44760", "34165", 
/* 453 */	"27548", "37516", "24343", "63046", "02081",
			"20378", "19510", "42226", "97134", "68739", 
/* 454 */	"32982", "56455", "53129", "77693", "25022",
			"55534", "99375", "30086", "98001", "07432", 
/* 455 */	"67126", "76656", "29347", "28492", "43108",
			"64736", "32278", "84816", "80440", "30461", 
/* 456 */	"00818", "09136", "01952", "48442", "91058",
			"92590", "10443", "05195", "34009", "32141", 
/* 457 */	"62209", "43740", "54102", "76895", "98172",
			"31583", "04155", "66492", "58981", "16591", 
/* 458 */	"11331", "06838", "03818", "77063", "12523",
			"45570", "68970", "70055", "77751", "73743", 
/* 459 */	"71732", "04704", "61384", "57343", "66682",
			"44500", "89745", "10436", "67202", "36455", 
/* 460 */	"42467", "88801", "91280", "01056", "27534",
			"81619", "79004", "25824", "66362", "33280", 
/* 461 */	"20706", "31929", "57422", "18730", "96197",
			"22101", "47592", "02180", "18287", "82310", 
/* 462 */	"60430", "59627", "26471", "07794", "60475",
			"76713", "45427", "89654", "14370", "81674", 
/* 463 */	"41246", "98416", "08669", "48883", "77154",
			"09806", "94015", "60347", "20027", "08405", 
/* 464 */	"33150", "27368", "53375", "70171", "59431",
			"14534", "34018", "85665", "77797", "17944", 
/* 465 */	"49602", "74391", "48830", "55029", "10371",
			"94261", "16658", "68400", "44148", "28150", 
/* 466 */	"40364", "90913", "73151", "64463", "50058",
			"78191", "84439", "82478", "62398", "03113", 
/* 467 */	"17578", "12830", "06571", "95934", "09132",
			"25287", "78731", "80683", "67207", "76597", 
/* 468 */	"42096", "34934", "76609", "52553", "47508",
			"71561", "08038", "83011", "72577", "95790", 
/* 469 */	"40076", "20292", "32138", "61197", "95476",
			"23123", "26648", "13611", "48452", "39963", 
/* 470 */	"85857", "04855", "27029", "01542", "72443",
			"53688", "82635", "56264", "07977", "23090", 
/* 471 */	"93553", "65434", "12124", "91087", "87800",
			"95675", "99419", "44659", "30382", "55263", 
/* 472 */	"82514", "86800", "16781", "65977", "65946",
			"13033", "93895", "04056", "75895", "47878", 
/* 473 */	"91309", "51233", "81409", "46773", "69135",
			"56906", "84493", "34530", "84534", "38312", 
/* 474 */	"54574", "92933", "77341", "20839", "36126",
			"01143", "35356", "35459", "07959", "98335", 
/* 475 */	"53266", "36146", "78047", "50607", "22486",
			"63308", "08996", "96056", "39085", "26567", 
/* 476 */	"06779", "62663", "30523", "47881", "41279",
			"49864", "82248", "78333", "29466", "48151", 
/* 477 */	"41957", "93235", "53308", "22682", "90722",
			"54478", "07235", "34306", "15827", "20121", 
/* 478 */	"96837", "06283", "80172", "66109", "92592",
			"48238", "76428", "94546", "45430", "16288", 
/* 479 */	"74839", "00740", "25553", "83767", "35900",
			"05998", "07493", "46755", "11449", "88824", 
/* 480 */	"44906", "33143", "07454", "56652", "34755",
			"63992", "59674", "65131", "46358", "12799"
			  };



typedef unsigned long int sBox[256];


/* The standard S boxes are defined in another file */
extern sBox standardSBoxes[SBoxCount];



/* The following routine is a simple error exit routine  -- it prints a
   message and aborts */
void    errAbort (s)
	char   *s;
{
	int     length;

	for (length = 0; s[length] != 0; length++);
	if (write (errorFile, s, length) != length) exit(2);
	if (write (errorFile, "\n", 1) != 1) exit(2);
	exit (1);
};



void    swapBytesInSBox (anSBox, row1, row2, column)
	sBox    anSBox;
	unsigned int row1, row2, column;

/* Exchanges two bytes in a column in 'anSBox'.  row1 and row2 are integers
   between 0 and 255 inclusive.  'column' is either 0, 1, 2 or 3 and refers
   to the byte position in a 32-bit word.  0 is the left-most byte.   */
{
	/* mask designates the bytes to be exchanged */
	unsigned long int mask;
	unsigned long int temp;

	mask = 0xFF000000;

	/* 'column' must be between 0 and 3 */
	if (column > 3)
		errAbort ("bad column passed to swapBytesInSBox");

	/* position the mask in the appropriate column */
	mask >>= (column * 8);


	/* Swap the bytes indicated by 'mask' */
	temp = anSBox[row1];
	anSBox[row1] = (anSBox[row1] & (~mask)) | (anSBox[row2] & mask);
	anSBox[row2] = (anSBox[row2] & (~mask)) | (temp & mask);
}


unsigned int randomDigit ()
/* generate a random digit in the range from 0 to 9, inclusive.  Generate the
   digit simply by getting the next random digit from the RAND table of
   random digits */
{
	if (locationIn5DigitGroup == 5) {
		locationIn5DigitGroup = 0;
		locationInRANDtable++;
	};
	if (locationInRANDtable >= sizeOfRANDtableIn5DigitGroups)
		errAbort ("Error in randomDigit -- attempt to ask for too many random digits");
	return (RANDtable[locationInRANDtable][locationIn5DigitGroup++] - '0');
};


unsigned int randomInRange (low, high)
	unsigned int low, high;

/* Returns a random integer in the range from low to high, inclusive */
/* gets random digits from RANDtable */
{
	unsigned int range;	/* contains the actual range needed */

	/* the max possible random numbers given a certain number of digits */
	unsigned int maximum;
	unsigned int random;	/* the random number composed by appending
				   digits */

	range = (high - low) + 1;
	do {
		random = 0;	/* initialize */
		maximum = 1;	/* initialize */
		/* loop until random has as many digits as range */
		while (maximum < range) {
			maximum *= 10;	/* 0-n = n+1 possible random numbers */
			/* add another digit to the low end */
			random = (random * 10) + randomDigit ();
		}
	}
	/* if random is not evenly mappable to range, try again */
	/* the operation (maximum/range)  TRUNCATES the result to an unsigned
	   int */
	while (random >= ((unsigned int) (maximum / range)) * range);
	/* map random to the range and add  low  to stay within (low,high) */
	return (low + (random % range));
}

void    checkSBoxes ()
/* computes the standard S boxes from the RAND table of random digits,
   then compares it with standardSBoxes -- they should be equal.
   Uses RANDtable as the source for the random digits.  */
{
	sBox    SBoxFromRand[SBoxCount];
	int SBoxIndex;

	/* column is from the set {0, 1, 2, 3}.  0 is the leftmost byte */
	unsigned int column, row;
	unsigned long int longRow;

	for (SBoxIndex = 0; SBoxIndex < SBoxCount; SBoxIndex++) {

		/* Fill initial S box with a trivial permutation (0-255) */
		for (longRow = 0; longRow < 256; longRow++)
			SBoxFromRand[SBoxIndex][longRow] =
				longRow | (longRow << 8) | (longRow << 16) | (longRow << 24);

		for (column = 0; column < 4; column++) {
			for (row = 0; row < 255 /* 255 is correct */ ; row++)
				/* exchange random rows in the column.
					This ensures the column remains a permutation
					of (0-255) */
				swapBytesInSBox (SBoxFromRand[SBoxIndex],
					row, randomInRange (row, 255), column);
		}
		for (row = 0; row < 256; row++)
			if (SBoxFromRand[SBoxIndex][row] != standardSBoxes[SBoxIndex][row])
				errAbort ("Error -- can't verify S boxes");

		printf("  Verified SBox[%d]\n",SBoxIndex);
    };  /*  End of for (SBoxIndex....   */
};



void    main ()
	
{	int i;

	
	/* Test the standard S boxes to make sure they haven't been
	   damaged. */
	/* Test to make sure each column is a permutation.  */
	for (i = 0; i < SBoxCount; i++) {
		char    testArray[256];
		int     testShift = 0;
		int     j;

		for (testShift = 0; testShift < 32; testShift += 8) {
			for (j = 0; j < 256; j++)
				testArray[j] = 0;
			for (j = 0; j < 256; j++)
				testArray[(standardSBoxes[i][j] >> testShift) & 0xff]++;
			for (j = 0; j < 256; j++)
				if (testArray[j] != 1)
					errAbort ("Table error -- the standard S box is corrupted");
		};
	};

	/* It looks okay.  Now check things out some more  */
	
	printf("  The standard S Boxes are permutations.\n");

	checkSBoxes ();


	exit (0);
};
