/*
 * dstore.c - Pyramid DC/OSx and Reliant UNIX global storage for lsof
 */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1996 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.4 97/11/06 09:26:10 abe Exp $";
#endif


#include "lsof.h"


struct clone *Clone = (struct clone *)NULL;
					/* clone device list */
int CloneMaj;				/* clone major device number (see
					 * HaveCloneMaj) */


/*
 * Drive_Nl -- table to drive the building of Nl[] via build_Nl()
 *             (See lsof.h and misc.c.)
 */

struct drive_Nl Drive_Nl[] = {

#if	defined(RELIANTV)
	{ "cdev",	"cdevsw"		},
	{ "ncdev",	"cdevcnt"		},
#else	/* !defined(RELIANTV) */
	{ "clmaj",	"clone_no"		},
#endif	/* defined(RELIANTV) */

	{ X_NCACHE,	"ncache"		},
	{ X_NCSIZE,	"ncsize"		},
	{ "sgvnops",	"segvn_ops"		},
	{ "ttyfs",	"ttyfs_vnodeops"	},
	{ "",		""			},
	{ NULL,		NULL			}
};

char **Fsinfo = NULL;			/* file system information */
int Fsinfomax = 0;			/* maximum file system type */
int HaveCloneMaj = 0;			/* CloneMaj status */

#if	defined(RELIANTV)
int HaveMipcMaj = 0;			/* MipcMaj status */
int MipcMaj;				/* cdevsw["mibc"] major device number */
#endif	/* defined(RELIANTV) */

int Kd = -1;				/* /dev/kmem file descriptor */
struct l_vfs *Lvfs = NULL;		/* local vfs structure table */
