/* tnputc.c */

/* Copyright 1997 by Eberhard Mattes <mattes@azu.informatik.uni-stuttgart.de>
   Donated to the public domain.  No warranty.

   1997-01-04 Initial version
   1997-01-18 Fix various bugs
   1997-04-05 Reorganize library */

#include <stdlib.h>
#include <arpa/telnet.h>
#include "firewall.h"
#include "libemtn.h"
#include "tnint.h"

void tn_putc (tnconn *t, char c)
{
  static char iaciac[2] = {IAC, IAC};

  if ((t->init_flags & TN_INIT_TELNET) && (unsigned char)c == IAC)
    tn_write (t, iaciac, 2);
  else
    tn_write (t, &c, 1);
}
