/*
 * monMmap.h --
 *
 *      This header file describes the internal facilities of
 *      the mmap()'d area of Monitor.
 *
 *      Note: The shared memory segment is mmap()'d by different processes.
 *      Hence it may be present at different absolute addresses in different
 *      address spaces. Therefore, no absolute pointers are allowed.
 *      All pointer arithmetic is is done via (32-bit) offsets from the
 *      mmap()'d address.
 *
 * Copyright(C) 1995, 1996 NEC Corporation. All rights reserved.
 * This is a genuine component of Socks5Toolkit(TM).
 *
 * $Header: /insg/project/socks/s5watch/include/monMmap.h,v 1.4 1997/08/14 04:43:58 miked Exp $
 * $Log: monMmap.h,v $
 * Revision 1.4  1997/08/14 04:43:58  miked
 * Declare array clientTH[] for both WIN32 and UNIX (convenient for Alive()).
 *
 * Revision 1.3  1997/02/06  19:51:45  miked
 * Added comments.
 *
 * Revision 1.2  1997/02/06  19:04:55  miked
 * Merged OSTC/NT and NWSL/UNIX versions.
 *
 * Revision 1.2  1996/09/05 21:22:23  naomi
 * Changes to where Jonathan left off...
 * Revision 1.1  1996/09/04 21:43:08  naomi
 * Initial revision
 * Revision 1.1.1.1  1996/08/30 02:43:49  miked
 * Initial version.
 *
 * Revision 1.5  1996/07/30  21:00:59  miked
 * Yet another copyright notice.
 *
 * Revision 1.4  1996/07/15  22:57:15  miked
 * Redefined MON_STATE_NBITS to be 4 instead of 3 to allow for S5_LINK_END.
 *
 * Revision 1.3  1996/07/09  23:57:46  miked
 * Added new copyright notice.
 *
 * Revision 1.2  1996/07/08  23:17:07  miked
 * Added totConns to MonMmap_t.
 *
 * Revision 1.1.1.1  1996/07/08  15:09:43  miked
 * Initial version for Socks5 API.
 */

#ifndef _H_MONMMAP
#define _H_MONMMAP

#include "monPort.h"

#ifdef WIN32
#include "monService.h"
#endif /* WIN32 */

/*
 *----------------------------------------------------------------------
 *    C O N S T A N T S
 *----------------------------------------------------------------------
 */
 
#define MON_MAX_CLIENTS    10        /* Max number of Monitor clients */
#define MON_MAX_GUIS       4         /* Max number of Monitor GUI clients */

#define MON_STATE_NBITS    4         /* Four (4) state bits per client */

#define MON_STATE_LSHIFT(bit,client) \
        ((bit) << (((client) - S5_MON_ALARM) * MON_STATE_NBITS))

#define MON_STATE_RSHIFT(bit,client) \
        ((bit) >> (((client) - S5_MON_ALARM) * MON_STATE_NBITS))

/*
 * How much to allocate for shared memory map in NT.
 *  Intel and MIPS page size is 4k.  2k for Alpha.
 */

#ifdef WIN32
#define MMAP_FILE_SIZE     4096 * 128
#define MON_MMAP_EVENT     "mmap_event" /* Event signals that mmap opened */
#endif /* WIN32 */

 /*
 *----------------------------------------------------------------------
 *    S T R U C T U R E S
 *----------------------------------------------------------------------
 */

/*
 * mmap()'d shared memory segment.
 */

typedef Uint32   MonMmapOff_t;       /* Use 32-bit offset instead of pointer */

typedef struct {                     /* Header of alloc()'d block in mmap() */
    MonMmapOff_t       off;          /* Offset of next block if on free list */
    Uint16             nUnits;       /* Size of this block in header units */
} MonMmapHeader_t;

typedef long           MonMmapAlign_t; /* Force alignment of alloc()'d block */

typedef struct {
    caddr_t            addr;         /* Address mmap()'d segment in creator */
    size_t             size;         /* Size in bytes of mmap()'d segment */
    pid_t              clients[MON_MAX_CLIENTS];   /* Array of client PIDs */
    HANDLE             clientsTH[MON_MAX_CLIENTS]; /* client thread handles */ 

#ifdef WIN32
    S5IOHandle         socket[MON_MAX_CLIENTS];    /* active sockets */
#endif /* WIN32 */

    int                nMax;         /* Max Socks5 data records */
    int                nCurrent;     /* Current Socks5 data records */
    int                nDeleted;     /* Deleted Socks5 data records */
    unsigned int       totConns;
    MonMmapOff_t       arrayOff;     /* Offset array of Socks5 data records */
    MonMmapOff_t       freeOff;      /* Offset to start of free list */
    MonMmapAlign_t     align;        /* Force alignment of free space blocks */
    MonMmapHeader_t    base;         /* Start of free list */
    Byte_t             free[1];      /* Free space = MON_MMAP_MAX_FREE bytes */
                                     /* !!! DO NOT PUT ANYTHING HERE !!! */
                                     /* This is the free space arena. */
} MonMmap_t;

/*
 *----------------------------------------------------------------------
 *    P R O C E D U R E S
 *----------------------------------------------------------------------
 */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Iterate through Socks5 data records in table.
 * Returns dataPtr on success; NULL on no more data.
 */

EXTERN S5MonData FAR*
MonMmapIterate _ANSI_ARGS_((
    S5MonHandle         handle            /* IN -- Opaque handle */
));

EXTERN int FAR
MonMmapCleanup _ANSI_ARGS_((
    S5MonHandle         handle,           /* IN -- Opaque handle */
    Boolean_t           all               /* IN -- Cleanup all inactive data */
));

EXTERN S5MonData FAR*
MonMmapDataPtr _ANSI_ARGS_((
    S5MonHandle         handle,           /* IN -- Opaque handle */
    S5MonKey FAR*       keyPtr            /* IN -- Pointer to key */
));

EXTERN int FAR
MonMmapDeleteData _ANSI_ARGS_((
    S5MonHandle         handle,           /* IN -- Opaque handle */
    S5MonKey FAR*       keyPtr            /* IN -- Pointer to key */
));

#ifdef __cplusplus
}
#endif

extern MonMmap_t FAR* monMmapPtr;    /* Global pointer to mmap()'d segment */

#endif /* _H_MONMMAP */
