/* resources.c
   process application resources(options) using the X resource manager. */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.2     20 November 1991               */
     /*                version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/


#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>

#include "conf.h"
#include "globals.h"
#include "resources.h"
#include "listP.h"
#include "misc.h"
#include "prefixP.h"
#include "panel.h"

/* Note on boolean data types.
   Xlib.h	defines Bool, True, False (as int, 1, 0)
   Intrinsic.h	defines Boolean, TRUE, FALSE (as typedef char, 1, 0)

   To keep some modules of this program independent of X, the new
   type BOOLEAN is introduced (typedef int), and constants TRUE and
   FALSE are conditionally defined in conf.h to be 1 and 0.
   An implicit conversion from Boolean (resources) to BOOLEAN
   is assumed. */


/* makePrefix
   edit application resources of directory listing prefixes to conform
   to be blank padded and exactly PREFIX_LEN characters.
   NOTE: These strings are *NOT* NULL-terminated. */

static void
makePrefix(target, source)
char	*target, *source;
{
	int	i;

	for (i=0; i<PREFIX_LEN; i++) {
		if (*source == NULL) {
			*(target++) = ' ';
		} else {
			*(target++) = *(source++);
		}
	}
}


static	char	*initPrintCmd, *initImageCmd, *initTelnetCmd,
		*initTn3270Cmd, *initBkFile;
static	Boolean	initShowAll, initAppendBk, initLoadBk, initResetOptions;

/* saveChangableResources
   save initial value of resources that may be changed during execution */

void
saveChangableResources(arP)
gopherAppResourcesP	arP;
{
	char	*temp;

	initBkFile =
		(char *) malloc(sizeof(char) * (strlen(arP->bookmarkFile)+1));
	strcpy(initBkFile, arP->bookmarkFile);

	initPrintCmd =
		(char *) malloc(sizeof(char) * (strlen(arP->printCommand)+1));
	strcpy(initPrintCmd, arP->printCommand);

	initImageCmd =
		(char *) malloc(sizeof(char) * (strlen(arP->imageCommand)+1));
	strcpy(initImageCmd, arP->imageCommand);

	initTelnetCmd =
		(char *) malloc(sizeof(char) * (strlen(arP->telnetCommand)+1));
	strcpy(initTelnetCmd, arP->telnetCommand);

	initTn3270Cmd =
		(char *) malloc(sizeof(char) * (strlen(arP->tn3270Command)+1));
	strcpy(initTn3270Cmd, arP->tn3270Command);

	initAppendBk	= arP->appendBookmarks;
	initShowAll	= arP->allItems;
	initLoadBk	= arP->loadBookmarks;
	initResetOptions= arP->resetOptions;
}


/* restoreChangableResources
   restore initial value of resources that may have been changed
   during execution */

void
restoreChangableResources(arP)
gopherAppResourcesP	arP;
{
	arP->bookmarkFile	= initBkFile;
	arP->printCommand	= initPrintCmd;
	arP->imageCommand	= initImageCmd;
	arP->telnetCommand	= initTelnetCmd;
	arP->tn3270Command	= initTn3270Cmd;

	arP->appendBookmarks	= initAppendBk;
	arP->allItems		= initShowAll;
	arP->loadBookmarks	= initLoadBk;
	arP->resetOptions	= initResetOptions;
}


/* getApplicationResources
   get application resources */

gopherAppResources *
getApplicationResources(topLevel, argc, argv)
Widget	topLevel;
int	argc;
char	**argv;
{
	static gopherAppResources	appResources;

	/* get application resources */

	XtGetApplicationResources(topLevel, (XtPointer) &appResources,
			resources, XtNumber(resources), NULL, 0);

	if (! appResources.defaultsInstalled) return NULL;

	itemStart     = appResources.itemStart;
	itemIncrement = appResources.itemIncrement;
	dirStart      = appResources.dirStart;
	dirIncrement  = appResources.dirIncrement;

	setHelpFile (appResources.helpFile);
	setBkmkFile (appResources.bookmarkFile);
	setBkmkAppend (appResources.appendBookmarks);

	infoDirLabel = XtMalloc(
		sizeof (char) * strlen(appResources.infoDirLabel) + 1);
	markDirLabel = XtMalloc(
		sizeof (char) * strlen(appResources.markDirLabel) + 1);
	strcpy(infoDirLabel, appResources.infoDirLabel);
	strcpy(markDirLabel, appResources.markDirLabel);

	if (appResources.logFile != NULL  &&  *appResources.logFile != NULL) {
		logFP = fopen (tildePath(appResources.logFile), "w");
		if (logFP == NULL) {
			fprintf (stderr, "cannot open log file \'%s\'\n",
					tildePath(appResources.logFile));
		} else {
			setbuf(logFP, NULL);
		}
	} else {
		logFP = NULL;
	}

	saveChangableResources(&appResources);

	makePrefix(prefixFile,   appResources.prefixFile);
	makePrefix(prefixDir,    appResources.prefixDir);
	makePrefix(prefixCSO,    appResources.prefixCSO);
	makePrefix(prefixIndex,  appResources.prefixIndex);
	makePrefix(prefixTelnet, appResources.prefixTelnet);
	makePrefix(prefixTn3270, appResources.prefixTn3270);
	makePrefix(prefixBinary, appResources.prefixBinary);
	makePrefix(prefixImage,  appResources.prefixImage);
	makePrefix(prefixSound,  appResources.prefixSound);
	makePrefix(prefixUnknown,appResources.prefixUnknown);

#ifdef DEBUG
	LOG (logFP, "Application Resources\n");
	LOG (logFP, "\tdefaultsInstalled:\t%s\n",
			appResources.defaultsInstalled ? "True" : "False");
	LOG (logFP, "\trootServer:\t%s\n",
			appResources.rootServer);
	LOG (logFP, "\trootPort:\t%d\n",
			appResources.rootPort);
	LOG (logFP, "\trootPath:\t%s\n",
			appResources.rootPath);
	LOG (logFP, "\tmainTitle:\t%s\n",
			appResources.mainTitle);
	LOG (logFP, "\tallowSave:\t%s\n",
			appResources.allowSave ? "True" : "False");
	LOG (logFP, "\tallowPrint:\t%s\n",
			appResources.allowPrint ? "True" : "False");
	LOG (logFP, "\tprintCommand:\t%s\n",
			appResources.printCommand);
	LOG (logFP, "\thelpFile:\t%s\n",
			appResources.helpFile);
	LOG (logFP, "\tdirectoryTime:\t%d\n",
			 appResources.directoryTime);
	LOG (logFP, "\tallowImage:\t%s\n",
			appResources.allowImage ? "True" : "False");
	LOG (logFP, "\timageCommand:\t%s\n",
			appResources.imageCommand);
	LOG (logFP, "\thasSound:\t%s\n",
			appResources.hasSound ? "True" : "False");
	LOG (logFP, "\tsoundCommand:\t%s\n",
			appResources.soundCommand);
	LOG (logFP, "\tbookmarkFile:\t%s\n",
			appResources.bookmarkFile);
	LOG (logFP, "\tallowBookmarkSave:\t%s\n",
			appResources.allowBookmarkSave ? "True" : "False");
	LOG (logFP, "\tappendBookmarks:\t%s\n",
			appResources.appendBookmarks ? "True" : "False");
	LOG (logFP, "\tallowTelnet:\t%s\n",
			appResources.allowTelnet ? "True" : "False");
	LOG (logFP, "\ttelnetCommand:\t%s\n",
			appResources.telnetCommand);
	LOG (logFP, "\tallowTn3270:\t%s\n",
			appResources.allowTn3270 ? "True" : "False");
	LOG (logFP, "\ttn3270Command:\t%s\n",
			appResources.tn3270Command);
	LOG (logFP, "\tloadBookmarks:\t%s\n",
			appResources.loadBookmarks ? "True" : "False");
	LOG (logFP, "\trestartButton:\t%s\n",
			appResources.restartButton ? "True" : "False");
	LOG (logFP, "\tswapRestartAndQuit:\t%s\n",
			appResources.swapRestartAndQuit ? "True" : "False");
	LOG (logFP, "\toptionsButton:\t%s\n",
			appResources.optionsButton ? "True" : "False");
	LOG (logFP, "\tallItems:\t%s\n",
			appResources.allItems ? "True" : "False");
	LOG (logFP, "\tdirHistory:\t%s\n",
			appResources.dirHistory ? "True" : "False");
	LOG (logFP, "\tresetOptions:\t%s\n",
			appResources.resetOptions ? "True" : "False");
	LOG (logFP, "\titemStart:\t%d\n",
			 appResources.itemStart);
	LOG (logFP, "\titemIncrement:\t%d\n",
			 appResources.itemIncrement);
	LOG (logFP, "\tdirStart:\t%d\n",
			 appResources.dirStart);
	LOG (logFP, "\tdirIncrement:\t%d\n",
			 appResources.dirIncrement);
	LOG (logFP, "\tdoubleClick:\t%s\n",
			appResources.doubleClick ? "True" : "False");
	LOG (logFP, "\tmarkRoot:\t%s\n",
			appResources.markRoot ? "True" : "False");
	LOG (logFP, "\ttempDirectory:\t%s\n",
			 appResources.tempDirectory);
	LOG (logFP, "\tlogFile:\t%s\n",
			 appResources.logFile==NULL ? 
					"<none>" : appResources.logFile);
	LOG (logFP, "\tprefixFile:\t%.*s\n",
			 PREFIX_LEN, appResources.prefixFile);
	LOG (logFP, "\tprefixDir:\t%.*s\n",
			 PREFIX_LEN, appResources.prefixDir);
	LOG (logFP, "\tprefixTelnet:\t%.*s\n",
			 PREFIX_LEN, appResources.prefixTelnet);
	LOG (logFP, "\tprefixTn3270:\t%.*s\n",
			 PREFIX_LEN, appResources.prefixTn3270);
	LOG (logFP, "\tprefixCSO:\t%.*s\n",
			 PREFIX_LEN, appResources.prefixCSO);
	LOG (logFP, "\tprefixIndex:\t%.*s\n",
			 PREFIX_LEN, appResources.prefixIndex);
	LOG (logFP, "\tprefixBinary:\t%.*s\n",
			 PREFIX_LEN, appResources.prefixBinary);
	LOG (logFP, "\tprefixImage:\t%.*s\n",
			 PREFIX_LEN, appResources.prefixImage);
	LOG (logFP, "\tprefixSound:\t%.*s\n",
			 PREFIX_LEN, appResources.prefixSound);
	LOG (logFP, "\tprefixUnknown:\t%.*s\n",
			 PREFIX_LEN, appResources.prefixUnknown);
#endif /* DEBUG */

	return &appResources;
}
