/* xgopher.c
   Xgopher main program */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#include <stdio.h>

#include "conf.h"
#include "gui.h"
#include "appres.h"
#include "util.h"
#include "osdep.h"
#include "version.h"

#define GLOBALS
#include "globals.h"
#undef GLOBALS

BOOLEAN	getOptions(
#ifdef PROTO
	int,
	char **
#endif
);



/* noOptions
   Cannot find the resources file... help the user a bit */

void
noOptions()
{
    static char	*optErrText[] = {
	"\n  The Xgopher Application Resources file is not available.",
	"  The system administrator should install the resources file in a",
	"  site-dependent location.",
	"\n  This file can also be located in your own app-defaults directory,",
	"  or the contents can be copied to one of your other X resource",
	"  files.",
	"\n  Xgopher cannot continue without this file.",
        (char *) NULL };

	int	i = 0;

	while (optErrText[i] != (char *) NULL) {
		fprintf (stderr, "%s\n", optErrText[i]);
		i++;
	}
}


/* usage
   print usage message */

usage(name)
char	*name;
{
	fprintf (stderr, "usage:\n");
	fprintf (stderr,
		"\t%s [gopher server [port number]] [X Toolkit options].\n",
		name);
}


/* resourcesMismatch
   inform user that the resource file is for the wrong version of Xgopher */

resourcesMismatch(theseResources, thisVersion)
char	*theseResources, *thisVersion;
{
	fprintf (stderr, "  This is Xgopher version %s.\n", thisVersion);
	fprintf (stderr,
		"  The X resources file available is for version %s.\n",
		theseResources);
	fprintf (stderr,
		"  Please provide the correct resources for this version.\n");
}


/* cmdLineOptions
   Look for left over command line options after Xt has a chance. */

static BOOLEAN
cmdLineOptions(argc, argv)
int	argc;
char	*argv[];
{
	/* see if Xt left us any options.  If there is exactly one,
	   and it has no leading '-', use it as the rootServer.
	   If there are exactly two, neither with a leading '-',
	   and the second is a number greater than zero, then use
	   them as the rootServer and rootPort.

	   We may leak a few bytes in the following code, but there
	   is no guarantee that the previous values of the resources
	   were dynamically allocated. */

	if ((argc == 2  && argv[1][0] != '-')  ||
	    (argc == 3  && argv[1][0] != '-'  && argv[2][0] != '-')) {
		int	hostLen = sizeof(char) * strlen(argv[1]) + 1;
		char	*tmp;

		if (argc == 3) {
			int	port=atoi(argv[2]);
			if (port > 0) {
				appResources->rootPort = port;
			} else {
				return FALSE;
			}

		}

		tmp = malloc(hostLen);
		strcpy(tmp, argv[1]);
		appResources->rootServer = tmp;

		tmp = malloc(hostLen);
		strcpy(tmp, argv[1]);
		appResources->mainTitle = tmp;


	} else if (argc > 1) {
		return FALSE;
	}

	return TRUE;
}


/* doMainItem
   create and process the main, top level gopher item for this session. */

void
doMainItem()
{
	gopherItemP		mainItem;
	char			errorString[MESSAGE_STRING_LEN];

	mainItem = makeItem(A_DIRECTORY,
			    appResources->mainTitle, appResources->rootPath,
			    appResources->rootServer, appResources->rootPort,
			    FALSE);
			

	if (! processItem(mainItem)) {
		sprintf(errorString,
"Unrecoverable error: cannot access the main %s directory at\nhost: %s port %d", 
			GOPHER, appResources->rootServer,
			appResources->rootPort);
		showFatalError(errorString);

	}

	if (appResources->markRoot) {
		markCurrentDirectory();
	}

	if (appResources->loadBookmarks) {
		loadMarks();
	}
}


/* xgopher
   main program */

main(argc, argv)
int	argc;
char	**argv;
{
	char			*p;

#if defined(SOCKS) || defined(connect)
	SOCKSinit(argv[0]);
#endif
	/* save last component of path name */

	if ((p = rindex(argv[0], '/')) == 0) p = argv[0];
	strcpy(gopherName, p);

	/* initialize the Graphical User Interface, the X window system */

	if (! initGUI(&argc, argv)) {
		noOptions();
		exit(1);
	}

	/* ensure resources version is correct */

	if (strcmp(appResources->resourcesVersion, XGOPHER_VERSION) != 0) {
		resourcesMismatch(appResources->resourcesVersion,
				XGOPHER_VERSION);
		closeGUIandQuit(1);
	}

	/* command line options may override server host and port */

	if (! cmdLineOptions(argc, argv) ) {
		usage(argv[0]);
		closeGUIandQuit(1);
	}

	/* options are Ok, create the main Xgopher panel */

	initMainPanel();

	/* initialize each item class */

	initItemClasses();

	doMainItem();

	doUserRequests();
}
