/*
 * This module contains code by Ron Edmark of Integrated Systems that
 * was pulled off the net and modified as a workaround to display titles
 * on Motif dialog windows running on OLWM.
 */


#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <X11/Xatom.h>

static Atom AtomWinAttr;
static Atom AtomWTOther;
static Atom AtomDecor;
static Atom AtomResize;
static Atom AtomHeader;
static Atom AtomClose;


/*
 * InstallOLWMAtoms - Get all the atoms needed to change OLWM properties.
 */
InstallOLWMAtoms(widget)
Widget widget;
{
	Display *dpy = XtDisplay(widget);

	AtomWinAttr = XInternAtom(dpy, "_OL_WIN_ATTR",     False); 
	AtomWTOther = XInternAtom(dpy, "_OL_WT_OTHER",     False);
	AtomDecor   = XInternAtom(dpy, "_OL_DECOR_ADD",    False);
	AtomResize  = XInternAtom(dpy, "_OL_DECOR_RESIZE", False);
	AtomHeader  = XInternAtom(dpy, "_OL_DECOR_HEADER", False);
	AtomClose   = XInternAtom(dpy, "_OL_DECOR_CLOSE",  False);
}


/*
 * AddOLWMDialogFrame - Add add title bars and a close button to popup
 *                      dialog.
 */
AddOLWMDialogFrame(widget)
Widget widget;
{
	Atom winAttrs[2];
	Atom winDecor[3];
	Window win;
	Widget shell;
	Display *dpy = XtDisplay(widget);
      
	if (widget) {

      /* First find the dialog's shell window */
      for (shell = widget; !XtIsShell(shell); shell = XtParent(shell));
      win = XtWindow(shell);

      /* Tell OLWM that window is not one of the standard OLWM window types */
      winAttrs[0] = AtomWTOther;
      XChangeProperty(dpy,
	                  win, AtomWinAttr,
					  XA_ATOM, 
                      32,
					  PropModeReplace,
					  (unsigned char*)winAttrs,
					  1
	  );
      
      /* Tell OLWM to add some decorations to our window */
      winDecor[0] = AtomHeader;
      winDecor[1] = AtomClose;
	  winDecor[2] = AtomResize;
      XChangeProperty(dpy,
	                  win,
					  AtomDecor,
					  XA_ATOM, 
                      32,
					  PropModeReplace,
					  (unsigned char*)winDecor,
                      3
	  );

   }
}

