/*
 * Written by Douglas Young
 * Posted in comp.windows.x.motif by Carl Schmidtmann on May 1, 1991.
 * Fixes problems with XmListDeselectAllItems() that caused XFTP to
 * blow up in call to XmListAddItem().
 */
#include        <Xm/Xm.h>
#include        <Xm/List.h>

void free_stringTable();

void
clear_list( list )
    Widget      list;
{
    Arg                 wargs[2];
    int                 n, i, itemCount;
    XmStringTable       items;

    XmListDeselectAllItems( list );

    n = 0;
    XtSetArg( wargs[n], XmNitemCount, &itemCount ); n++;
    XtSetArg( wargs[n], XmNitems, &items ); n++;
    XtGetValues( list, wargs, n );

    free_stringTable( items, itemCount );

    n = 0;
    XtSetArg( wargs[n], XmNitemCount, 0 ); n++;
    XtSetArg( wargs[n], XmNitems, NULL ); n++;
    XtSetValues( list, wargs, n );

}

void
free_stringTable( itemList, itemCount )
    XmStringTable       itemList;
    int                 itemCount;
{
    int         i;

    if( itemList != NULL )
    {
        for( i = 0; i < itemCount;  i++ )
            XmStringFree( itemList[i] );
        XtFree((char *)itemList);
    }
}

