/*
     fc - Filter compiler software for the Drawbridge package
     Copyright (C) 1993 David K. Hess, Douglas Lee Schales, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.
*/
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <malloc.h>
#include <memory.h>
#include "ports.h"
#include "protocols.h"
#include "services.h"
#include "chario.h"
#include "classes.h"
#include "hosts.h"
#include "y.tab.h"

#define TRUE 1
#define FALSE 0
	

struct keywds {
     char *name;
     int token;
};

struct keywds keywords[] = {
     { "in", IN },
     { "out", OUT },
     { "inout", INOUT },
     { "in-out", INOUT },
     { "define", DEFINE },
     { "host", HOST },
     { "include", INCLUDE },
     { "network", NETWORK },
     { "reject", REJECT },
     { "allow", ALLOW },
     { "src", SRC },
     { "dst", DST },
     { (char *)0, 0 }
     };

static int buflen = 0;
static int bufptr = 0;
static char *buffer = (char *)0;
     
int
yylex(void)
{
     int c;
     int comment = FALSE;
     int number;
     int i;
     int quote;
     
     while((c = fetchar())){
	  if(c == '#')
	       comment = TRUE;
	  else if(comment){
	       if(c == '\n')
		    comment = FALSE;
	  }
	  else if(!isspace(c))
	       break;
     }
     buflen = 16;
     buffer = (char *)malloc(buflen);
     if(!buffer){
	  fprintf(stderr, "%s, line %d: malloc failed\n",
		  __FILE__, __LINE__);
	  exit(1);
     }

     quote = FALSE;
     if(isalnum(c) || c == '"'){
	  bufptr = 0;
	  if(c == '"'){
	       quote = TRUE;
	       number = FALSE;
	  }
	  else {
	       buffer[bufptr++] = c;
	       number = isdigit(c);
	  }
	  while((c=fetchar())){
	       if(c == '"'){
		    if(quote)
			 c = fetchar();
		    break;
	       }
	       else if(!quote){
		    if(isspace(c))
			 break;
		    if(c == '<' || c == '>' || c == ',' ||
		       c == ';' || c == '=' || c == '/')
			 break;
		    if(bufptr && number && !isdigit(c) && !isalpha(c))
			 break;
		    if(!isdigit(c))
			 number = FALSE;
	       }
	       if(bufptr == buflen){
		    buflen *= 2;
		    buffer = (char *)realloc(buffer, buflen);
		    if(!buffer){
			 fprintf(stderr, "%s, line %d: realloc failed\n",
				 __FILE__, __LINE__);
			 exit(1);
		    }
	       }
	       buffer[bufptr++] = c;
	  }
	  pushchar(c);
	  if(bufptr == buflen){
	       buflen *= 2;
	       buffer = (char *)realloc(buffer, buflen);
	       if(!buffer){
		    fprintf(stderr, "%s, line %d: realloc failed\n",
			    __FILE__, __LINE__);
		    exit(1);
	       }
	  }
	  buffer[bufptr] = 0;
	  if(number){
	       int value = atoi(buffer);
	       free(buffer);
	       yylval.int32 = value;
	       if(value < 256)
		    return BYTEVAL;
	       return
		    INTEGER;
	  }

	  for(i=0;keywords[i].name;i++)
	       if(!strcmp(buffer, keywords[i].name)){
		    yylval.str = buffer;
		    return keywords[i].token;
	       }
	  yylval.str = buffer;
	  return STRING;
     }
     return c;
}
