/*
    Filter Manager - Management software for the Drawbridge package
    Copyright (C) 1993 David K. Hess, Douglas Lee Schales, David R. Safford

    Please see the file `COPYING' for the complete copyright notice.

    fm.h - Version 1.0 - 4/21/93
*/

#include <stdio.h>
#include <string.h>
#include <pwd.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/stropts.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <net/nit_if.h>
#include <net/nit_pf.h>
#include <net/packetfilt.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <malloc.h>
#include "lex.h"

/*
 * Miscellaneous constants.
 */
#define VERSION       "1.0"

#define YES     1
#define NO      0

#define ETHERPROTO     0xA001U
#define TIMEOUT        3
#define RETRIES        3

/*
 * Filter protocol message constants.
 */
#define FM_M_SYNC        0
#define FM_M_SYNCACK     1
#define FM_M_WRITE       2
#define FM_M_WRITEACK    3
#define FM_M_REBOOT      4
#define FM_M_REBOOTACK   5
#define FM_M_NEWKEY      6
#define FM_M_NEWKEYACK   7
#define FM_M_QUERY       8
#define FM_M_QUERYACK    9
#define FM_M_LOAD        10
#define FM_M_LOADACK     11
#define FM_M_ERROR       12
#define FM_M_RELEASE     13
#define FM_M_RELEASE_ACK 14

#define FM_F_CRYPTED   0x01

#define FM_QUERY_NETWORK   0
#define FM_QUERY_HOST      1
#define FM_QUERY_REJECT    2
#define FM_QUERY_ALLOW     3
#define FM_QUERY_CLASS     4

#define FM_LOAD_NETWORK   0
#define FM_LOAD_REJECT    1
#define FM_LOAD_ALLOW     2
#define FM_LOAD_CLASS     3

#define FM_LOAD_FLAGS_BEGIN  0x01
#define FM_LOAD_FLAGS_END    0x02

#define FM_RELEASE_CLASSES  0
#define FM_RELEASE_REJECT   1
#define FM_RELEASE_ALLOW    2
#define FM_RELEASE_NETWORK  3

#define FM_ERROR_INSECURE        0
#define FM_ERROR_SECURE          1
#define FM_ERROR_DESFILE         2
#define FM_ERROR_DESWRITE        3
#define FM_ERROR_NONETWORK       4
#define FM_ERROR_NOMEMORY        5
#define FM_ERROR_COMMAND         6
#define FM_ERROR_DATAFILE        7
#define FM_ERROR_DATAWRITE       8
#define FM_ERROR_INVALIDNETWORK  9
#define FM_ERROR_LOADBUFFER      10
#define FM_ERROR_NODES           11

#define MAX_NUM_NETWORKS       32
#define MAX_NUM_ACCESS_LISTS   256
#define MAX_NUM_ACCESS_RANGES  32
#define MAX_NUM_REJECT_ENTRIES 32
#define MAX_NUM_ALLOW_ENTRIES  8

/*
 * Structure for an address table entry.
 */
typedef struct _AddrTableEntry {
    struct in_addr network;
    char networkFilename[256];
    unsigned char *hostTable;
} AddrTableEntry;

typedef struct _AccessListTableEntry {
    unsigned short begin;
    unsigned short end;
} AccessListTableEntry;

typedef struct _RejectTableEntry {
    struct in_addr network;
    unsigned long mask;
} RejectTableEntry;

typedef struct _AllowTableEntry {
    struct in_addr network;
    unsigned long mask;
    AccessListTableEntry access[MAX_NUM_ACCESS_RANGES];
} AllowTableEntry;

/*
 * Structure representing a filt protocol header.
 */
typedef struct _DESauth {
    unsigned long fmSeq;
    unsigned long filterSeq;
} DESauth;

typedef struct _FiltHeader {
    unsigned char   edst[6];
    unsigned char   esrc[6];
    unsigned short  etype;
    unsigned char   type;
    unsigned char   flags;
    DESauth auth;
} FiltHeader;

typedef struct _SimplePacket {
    FiltHeader header;
} SyncPacket, WritePacket, RebootPacket;

typedef struct _QueryPacket {
    unsigned char type;
    unsigned char dummy[3];
    union {
	unsigned char index;
	unsigned long addr;
    } queryValue;
    union {
	struct in_addr networks[MAX_NUM_NETWORKS];
	unsigned char index;
	RejectTableEntry reject[MAX_NUM_REJECT_ENTRIES];
	AllowTableEntry allow[MAX_NUM_ALLOW_ENTRIES];
	struct {
	    AccessListTableEntry in[MAX_NUM_ACCESS_RANGES];
	    AccessListTableEntry out[MAX_NUM_ACCESS_RANGES];
	    AccessListTableEntry src[MAX_NUM_ACCESS_RANGES];
	    AccessListTableEntry udp[MAX_NUM_ACCESS_RANGES];
	} accessList;
    } queryResult;
} QueryPacket;

typedef struct _LoadPacket {
    unsigned char type;
    unsigned char flags;
    union {
	unsigned char index;
	struct {
	    struct in_addr network;
	    unsigned long offset;
	} networkBlock;
    } loadValue;
    union {
	RejectTableEntry reject[MAX_NUM_REJECT_ENTRIES];
	AllowTableEntry allow[MAX_NUM_ALLOW_ENTRIES];
	struct {
	    AccessListTableEntry in[MAX_NUM_ACCESS_RANGES];
	    AccessListTableEntry out[MAX_NUM_ACCESS_RANGES];
	    AccessListTableEntry src[MAX_NUM_ACCESS_RANGES];
	    AccessListTableEntry udp[MAX_NUM_ACCESS_RANGES];
	} accessList;
	unsigned char networkBlock[1024];
    } loadData;
} LoadPacket;

typedef struct _ReleasePacket {
    unsigned char type;
    struct in_addr network;
} ReleasePacket;

typedef struct _ErrorPacket {
    FiltHeader header;
    unsigned char errorCode;
} ErrorPacket;

/*
 * External functions.
 */
struct ether_addr *ether_aton(char *);
char *ether_ntoa(struct ether_addr *);

/*
 * External variables.
 */
extern char *sys_errlist[];

/*
 * Prototypes.
 */

/*
 * nit.c
 */
int nit_open(char *device,u_short type);
int nit_write(int fd,char *b,int len);

/*
 * util.c
 */
void longSwap(unsigned long *buf,unsigned long length);
void shortSwap(unsigned short *buf,unsigned long length);
void printError(unsigned char code,FILE *theOutput);

/*
 * comm.c
 */
void initCommunications(char *interface);
int startTransaction(void);
unsigned char *sendMessage(unsigned char type,void *data,unsigned long size);

/*
 * fm.c
 */
void handleSet(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleShow(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleNewKey(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleGenKey(FILE *theInput,FILE *theOutput,FILE *theMessages);
char *tildeExpand(char *filename,FILE *theMessages);
void handleLoad(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleQuery(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleUpload(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleWrite(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleClear(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleReset(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleRelease(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleReboot(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleHelp(FILE *theInput,FILE *theOutput,FILE *theMessages);
void handleInput(FILE *theInput,FILE *theOutput,FILE *theMessages);
void usage(void);
void readRc(void);
int main(int argc,char *argv[]);

/*
 * crypt.c
 */
int genMethod(unsigned long *method,unsigned char *key);
void encrypt(unsigned char *cipher,unsigned long *method,unsigned char *plain);
void decrypt(unsigned char *plain,unsigned long *method,unsigned char *cipher);

/*
 * lex.l
 */
int tokenize(char *string);

/*
 * Externs for global variables.
 */
extern FILE *debug;
extern FILE *output;
extern FILE *input;
extern FILE *messages;

extern int keySet;
extern struct ether_addr currTarget;
extern unsigned char currKey[128];
