/* FastlaneZ3 with FAS216 SCSI interface hardware description. */

typedef struct flz3sc_regmap {
	fas_regmap_t	FAS216;
	unsigned char	pad0[1];
	vu_char		hardbits;
	unsigned char	pad1[63];
	vu_char		clear;
} flz3sc_regmap_t;
typedef flz3sc_regmap_t *flz3sc_regmap_p;

#define FLZ3SC_HB_DISABLED	0x01
#define FLZ3SC_HB_BUSID6	0x02
#define FLZ3SC_HB_SEAGATE	0x04
#define FLZ3SC_HB_SLOW		0x08
#define FLZ3SC_HB_SYNCHRON	0x10
#define FLZ3SC_HB_CREQ		0x20
#define FLZ3SC_HB_IACT		0x40
#define FLZ3SC_HB_MINT		0x80

#define FLZ3SC_PB_ESI		0x01
#define FLZ3SC_PB_EDI		0x02
#define FLZ3SC_PB_ENABLE_DMA	0x04
#define FLZ3SC_PB_DISABLE_DMA	0x00	/* Symmetri reasons */
#define FLZ3SC_PB_DMA_WRITE	0x08
#define FLZ3SC_PB_DMA_READ	0x00	/* Symmetri reasons */
#define FLZ3SC_PB_LED		0x10

#define FLZ3SC_PB_INT_BITS (FLZ3SC_PB_ESI | FLZ3SC_PB_EDI)
#define FLZ3SC_PB_DMA_BITS (FLZ3SC_PB_ENABLE_DMA | FLZ3SC_PB_DMA_WRITE)
