#ifndef _FASVAR_H_
#define _FASVAR_H_

#define MAXCHAIN	(MAXPHYS/NBPG+1)
#define MAXPENDING	9	/* 7 IDs + 2 extra */
/* #define MAXPENDING	(7*8) */	/* 7 IDs * 8 LUNs */

struct	fas_dma_chain {
	u_char			*ptr;
	u_short			 len;
	short			 flg;
};
#define FAS_CHAIN_DMA	0x00
#define FAS_CHAIN_PRG	0x01
#define FAS_CHAIN_BUMP	0x02

struct	vm_link_data {
	vm_offset_t	pa[MAXCHAIN];
	short		offset;
	short		pages;
};

struct	fas_pending {
	TAILQ_ENTRY(fas_pending) link;
	struct scsi_xfer	*xs;
	struct vm_link_data	 vm_link_data;
};

struct nexus {
	struct	scsi_xfer 	*xs;

	u_char			 cbuf[14];
	short			 clen;

	struct vm_link_data	 vm_link_data;
	struct fas_dma_chain	 dma[MAXCHAIN];
	int			 max_link;
	int			 cur_link;

	u_char			*buf;		/* va */
	int			 len;

	u_char			*dma_buf;	/* pa */
	int			 dma_len;

	u_char			*dma_blk_ptr;
	int			 dma_blk_len;

	u_char			 flags;
	u_char			 state;

	u_char			 syncper;
	u_char			 syncoff;
	u_char			 config3;
};
/* SCSI nexus_state */
#define FAS_NS_IDLE		0
/* ---------------- */
#define FAS_NS_SELECTED		1
#define FAS_NS_SELECTED_SDTR	2
#define FAS_NS_DATA_IN		3
#define FAS_NS_DATA_OUT		4
#define FAS_NS_STATUS		5
#define FAS_NS_MSG_IN		6
#define FAS_NS_SVC		7
#define FAS_NS_DISCONNECTED	8
#define FAS_NS_DONE		9
#define FAS_NS_FINISHED		10

/* SCSI nexus flags */
#define FAS_REC_MSG		0x01
#define FAS_HAS_MSG		0x02
#define FAS_GOT_DISCONN		0x04
#define FAS_DISCONNECTED	0x08
#define FAS_SYNC_TESTED		0x10
#define FAS_UNIT_BUSY		0x20
#define FAS_DEBUG		0x40
#define FAS_PRINT_DATA		0x80

struct	fas_softc {
/* System struct */
	struct	device		 sc_dev;
	struct	scsi_link	 sc_link;	/* proto for sub devices */

	TAILQ_HEAD(,fas_pending) sc_xs_pending;
	TAILQ_HEAD(,fas_pending) sc_xs_free;
	struct	fas_pending 	 sc_xs_store[MAXPENDING];
	struct	scsi_xfer 	*sc_xs;

	u_char			 sc_units_busy;
	u_char			 sc_units_disconnected;

	fas_regmap_p		 sc_fas;	/* FAS216 Address */
	void			*sc_dma;	/* DMA register base */
	void			*sc_spec;	/* Board-specific data */

	u_char			*sc_vm_link;
	
	u_char			*sc_bump_va;	/* Bumpbuf virtual adr */
	void			*sc_bump_pa;	/* Bumpbuf physical adr */
	int			 sc_bump_sz;	/* Bumpbuf size */

/* Configuration registers, must be set BEFORE fasinitialize */
	u_char			 sc_clock_freq;
	u_short			 sc_timeout;
	u_char			 sc_host_id;
	u_char			 sc_config_flags;

/* Generic DMA functions */
	int		       (*sc_init_dma_in)();
	int		       (*sc_init_dma_out)();
	int		       (*sc_build_dma_chain)();
	int		       (*sc_clear_dma)();
	int		       (*sc_dma_ok)();
	int		       (*sc_need_bump)();

/* Generic Led data */
	int			 sc_led_status;
	void		       (*sc_led_on)();
	void		       (*sc_led_off)();

	void		       (*sc_ints_on)();
	void		       (*sc_ints_off)();

/* Nexus list */
	struct nexus		 sc_nexus[8];
	struct nexus		*sc_cur_nexus;

/* Current transfer data */
	struct vm_link_data	 sc_vm_link_data;

	u_char			*sc_buf;	/* va */
	int			 sc_len;

	u_char			*sc_dma_buf;	/* pa */
	int			 sc_dma_len;
	u_char			*sc_dma_blk_ptr;
	int			 sc_dma_blk_len;
	short			 sc_dma_blk_flg;

	struct fas_dma_chain	*sc_chain;	/* Current DMA chain */
	int			 sc_max_link;
	int			 sc_cur_link;

/* Interrupt registers */
	u_char			 sc_status;
	u_char			 sc_sequence;
	u_char			 sc_interrupt;
	u_char			 sc_resel[2];

/* Storage for FAS216 config registers (current values) */
	u_char			 sc_config1;
	u_char			 sc_config2;
	u_char			 sc_config3;
	u_char			 sc_clock_conv_fact;
	u_char			 sc_timeout_val;
	u_char			 sc_clock_period;

	u_char			 sc_stat[2];

	u_char			 sc_msg_in[15];
	u_char			 sc_msg_in_len;

	u_char			 sc_msg_out[15];
	u_char			 sc_msg_out_len;

	u_char			 sc_unit;
	u_char			 sc_lun;
	u_char			 sc_state;
	u_char			 sc_flags;
};

#define FAS_S_IDLE	0
#define FAS_S_IMMEDIATE	1
#define FAS_S_INTERRUPT	2

#define FAS_HAS_VM_LINK	1

/* SCSI Selection modes */
#define FAS_SELECT	0	/* Normal selection: No sync, no resel */
#define FAS_SELECT_R	1	/* Reselection allowed */
#define FAS_SELECT_S	2	/* Synchronous transfer allowed */
#define FAS_SELECT_RS	3	/* Sync. transfer and reselection allowed */
#define FAS_SELECT_I	4	/* Selection for fasicmd */
#define FAS_SELECT_RI	5
#define FAS_SELECT_SI	6
#define FAS_SELECT_RSI	7

/* sc_config_flags */
#define FAS_NO_SYNCH	0x01	/* Disable synchronous transfer */
#define FAS_SLOW_CABLE	0x02	/* Cable is "unsafe" for fast scsi-2 */
#define FAS_NO_DMA	0x04	/* Do not use DMA! EVER! */
#define FAS_NO_RESELECT	0x08	/* Do not allow relesection */

void	fasinitialize __P((struct fas_softc *sc));
void	fas_minphys __P((struct buf *bp));
#if !NEW_CODE
u_int	fas_adinfo __P((void));
#endif
int	fas_scsicmd __P((struct scsi_xfer *));

#endif /* _FASVAR_H_ */
