/*
 *	$Id: fasreg.h
 */

/*
 * Emulex FAS216 SCSI interface hardware description.
 */

#define pad(n,s) unsigned char pad ## n [s]
typedef volatile unsigned char vu_char;

typedef struct {
  pad(0,1);	vu_char	fas_tc_low;	/* rw: Transfer count low */
  pad(1,3);	vu_char	fas_tc_mid;	/* rw: Transfer count mid */
  pad(2,3);	vu_char	fas_fifo;	/* rw: Data FIFO */
  pad(3,3);	vu_char	fas_command;	/* rw: Chip command reg */
  pad(4,3);	vu_char	fas_dest_id;	/* w: (Re)select bus ID */
#define fas_status fas_dest_id		/* r: Status */
  pad(5,3);	vu_char	fas_timeout;	/* w: (Re)select timeout */
#define fas_interrupt fas_timeout	/* r: Interrupt */
  pad(6,3);	vu_char	fas_syncper;	/* w: Synch. transfer period */
#define fas_seqstep fas_syncper		/* r: Sequence step */
  pad(7,3);	vu_char	fas_syncoff;	/* w: Synch. transfer offset */
#define fas_fifo_flags fas_syncoff	/* r: FIFO flags */
  pad(8,3);	vu_char	fas_config1;	/* rw: Config register #1 */
  pad(9,3);	vu_char	fas_clkconv;	/* w: Clock conv. factor */
  pad(10,3);	vu_char	fas_test;	/* w: Test register */
  pad(11,3);	vu_char	fas_config2;	/* rw: Config register #2 */
  pad(12,3);	vu_char	fas_config3;	/* rw: Config register #3 */
  pad(13,7);	vu_char	fas_tc_high;	/* rw: Transfer count high */
  pad(14,3);	vu_char	fas_fifo_bot;	/* w: FIFO bottom register */
  pad(15,2);
} fas_regmap_t;
typedef fas_regmap_t *fas_regmap_p;

/* Commands for the FAS216 */
#define FAS_CMD_DMA			0x80

#define FAS_CMD_SEL_NO_ATN		0x41
#define FAS_CMD_SEL_ATN			0x42
#define FAS_CMD_SEL_ATN3		0x46
#define FAS_CMD_SEL_ATN_STOP		0x43

#define FAS_CMD_ENABLE_RESEL		0x44
#define FAS_CMD_DISABLE_RESEL		0x45

#define FAS_CMD_TRANSFER_INFO		0x10
#define FAS_CMD_TRANSFER_PAD		0x98

#define FAS_CMD_COMMAND_COMPLETE	0x11
#define FAS_CMD_MESSAGE_ACCEPTED	0x12

#define FAS_CMD_SET_ATN			0x1A
#define FAS_CMD_RESET_ATN		0x1B

#define FAS_CMD_NOP			0x00
#define FAS_CMD_FLUSH_FIFO		0x01
#define FAS_CMD_RESET_CHIP		0x02
#define FAS_CMD_RESET_SCSI_BUS		0x03

#define FAS_STAT_PHASE_MASK		0x07
#define FAS_STAT_PHASE_TRANS_CPLT	0x08
#define FAS_STAT_TRANSFER_COUNT_ZERO	0x10
#define FAS_STAT_PARITY_ERROR		0x20
#define FAS_STAT_GROSS_ERROR		0x40
#define FAS_STAT_INTERRUPT_PENDING	0x80

#define FAS_PHASE_DATA_OUT		0
#define FAS_PHASE_DATA_IN		1
#define FAS_PHASE_COMMAND		2
#define FAS_PHASE_STATUS		3
#define FAS_PHASE_MESSAGE_OUT		6
#define FAS_PHASE_MESSAGE_IN		7

#define FAS_DEST_ID_MASK		0x07

#define FAS_INT_SELECTED		0x01
#define FAS_INT_SELECTED_WITH_ATN	0x02
#define FAS_INT_RESELECTED		0x04
#define FAS_INT_FUNCTION_COMPLETE	0x08
#define FAS_INT_BUS_SERVICE		0x10
#define FAS_INT_DISCONNECT		0x20
#define FAS_INT_ILLEGAL_COMMAND		0x40
#define FAS_INT_SCSI_RESET_DETECTED	0x80

#define FAS_SYNCHRON_PERIOD_MASK	0x1F

#define FAS_FIFO_COUNT_MASK		0x1F
#define FAS_FIFO_SEQUENCE_STEP_MASK	0xE0
#define FAS_FIFO_SEQUENCE_SHIFT	5

#define FAS_SYNCHRON_OFFSET_MASK	0x0F
#define FAS_SYNC_ASSERT_MASK		0x30
#define FAS_SYNC_ASSERT_SHIFT		4
#define FAS_SYNC_DEASSERT_MASK		0x30
#define FAS_SYNC_DEASSERT_SHIFT		6

#define FAS_CFG1_BUS_ID_MASK		0x07
#define FAS_CFG1_CHIP_TEST_MODE		0x08
#define FAS_CFG1_SCSI_PARITY_ENABLE	0x10
#define FAS_CFG1_PARITY_TEST_MODE	0x20
#define FAS_CFG1_SCSI_RES_INT_DIS	0x40
#define FAS_CFG1_SLOW_CABLE_MODE	0x80

#define FAS_CLOCK_CONVERSION_MASK	0x07

#define FAS_TEST_TARGET_TEST_MODE	0x01
#define FAS_TEST_INITIATOR_TEST_MODE	0x02
#define FAS_TEST_TRISTATE_TEST_MODE	0x04

#define FAS_CFG2_DMA_PARITY_ENABLE	0x01
#define FAS_CFG2_REG_PARITY_ENABLE	0x02
#define FAS_CFG2_TARG_BAD_PARITY_ABORT	0x04
#define FAS_CFG2_SCSI_2_MODE		0x08
#define FAS_CFG2_TRISTATE_DMA_REQ	0x10
#define FAS_CFG2_BYTE_CONTROL_MODE	0x20
#define FAS_CFG2_FEATURES_ENABLE	0x40
#define FAS_CFG2_RESERVE_FIFO_BYTE	0x80

#define FAS_CFG3_THRESHOLD_8_MODE	0x01
#define FAS_CFG3_ALTERNATE_DMA_MODE	0x02
#define FAS_CFG3_SAVE_RESIDUAL_BYTE	0x04
#define FAS_CFG3_FASTCLK		0x08
#define FAS_CFG3_FASTSCSI		0x10
#define FAS_CFG3_CDB10			0x20
#define FAS_CFG3_QENB			0x40
#define FAS_CFG3_IDRESCHK		0x80
