/*	$NetBSD: if_lereg.h,v 1.5 1994/12/28 09:25:30 chopps Exp $	*/

/*
 * Copyright (c) 1982, 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	from: @(#)if_lereg.h	7.1 (Berkeley) 5/8/90
 *	from: if_lereg.h,v 1.3 1994/01/26 21:05:53 mw Exp $
 *	Id: if_aereg.h,v 1.3 1995/4/23 19:56:56 crest/ill
 *
 *	This is based on the original LANCE files as the PCnet-ISA used on
 *	the Ariadne is a LANCE-descendant optimized for the (guess it?)
 *	PC-ISA bus. This causes some modifications, all data that is to go
 *	into registers or to structures (buffer-descriptors, init-block)
 *	has to be byte-swapped. In addition ALL write accesses to the board
 *	have to be WORD or LONG, BYTE-access is prohibited!!
 */

#define	AEID		21

#define	AEMTU		1518
#define	AEMINSIZE	60	/* should be 64 if mode DTCR is set */

#define AERBUF		16	/* 16 receive buffers */
#define AERBUFLOG2	4
#define AETBUF		4	/* 4 transmit buffers */
#define AETBUFLOG2	2

#define	AE_RLEN		(AERBUFLOG2 << 13)
#define	AE_TLEN		(AETBUFLOG2 << 13)

#define vu_char		volatile u_char

/*
 * PCnet-ISA registers.
 */

struct aereg1 {
	u_short	aer1_rdp;	/* data port */
	u_short	aer1_rap;	/* register select port */
	u_short	aer1_reset;	/* reading this resets the PCnet-ISA */
	u_short	aer1_idp;	/* isa configuration port */
};

struct aereg2 {
	/* init block */
	u_short	aer2_mode;		/* +0x0000 */
	u_short	aer2_padr[3];		/* +0x0002 */
	u_long	aer2_ladrf0;		/* +0x0008 */
	u_long	aer2_ladrf1;		/* +0x000C */
	u_short	aer2_rdra;		/* +0x0010 */
	u_short	aer2_rlen;		/* +0x0012 */
	u_short	aer2_tdra;		/* +0x0014 */
	u_short	aer2_tlen;		/* +0x0016 */
	/* receive message descriptors */
	struct	aermd {			/* +0x0018 */
		u_short	rmd0;
		u_short	rmd1;
		short	rmd2;
		u_short	rmd3;
	} aer2_rmd[AERBUF];
	/* transmit message descriptors */
	struct	aetmd {			/* +0x0058 */
		u_short	tmd0;
		u_short	tmd1;
		short	tmd2;
		u_short	tmd3;
	} aer2_tmd[AETBUF];
	char	aer2_rbuf[AERBUF][AEMTU]; /* +0x0060 */
	char	aer2_tbuf[AETBUF][AEMTU]; /* +0x2FD0 */
};


/*
 * Control and status bits -- aereg1
 */
#define	AE_CSR0		0x0000
#define	AE_CSR1		0x0100
#define	AE_CSR2		0x0200
#define	AE_CSR3		0x0300

#define	AE_SERR		0x0080
#define	AE_BABL		0x0040
#define	AE_CERR		0x0020
#define	AE_MISS		0x0010
#define	AE_MERR		0x0008
#define	AE_RINT		0x0004
#define	AE_TINT		0x0002
#define	AE_IDON		0x0001
#define	AE_INTR		0x8000
#define	AE_INEA		0x4000
#define	AE_RXON		0x2000
#define	AE_TXON		0x1000
#define	AE_TDMD		0x0800
#define	AE_STOP		0x0400
#define	AE_STRT		0x0200
#define	AE_INIT		0x0100

#define AE_MODE		0x0000
#define AE_PROM		0x0080

/*
 * Control and status bits -- aereg2
 */
#define	AE_OWN		0x0080
#define	AE_ERR		0x0040
#define	AE_STP		0x0002
#define	AE_ENP		0x0001

#define	AE_FRAM		0x0020
#define	AE_OFLO		0x0010
#define	AE_CRC		0x0008
#define	AE_RBUFF	0x0004

#define	AE_MORE		0x0010
#define	AE_ONE		0x0008
#define	AE_DEF		0x0004

#define	AE_TBUFF	0x0080
#define	AE_UFLO		0x0040
#define	AE_LCOL		0x0010
#define	AE_LCAR		0x0008
#define	AE_RTRY		0x0004

#define SWAP(x) (((x&0xff)<<8)|((x>>8)&0xff))

