#!/bin/sh
###########################################################################
#
# Easy Install (C) Copyright 1994,1995,1996 Hubert Feyrer
#
#--------------------------------------------------------------------------
#
# This software may not be used in non-academic environment without the
# author's written permission.
#
#--------------------------------------------------------------------------
#
# $Log: install.sh,v $
# Revision 1.6  1997/03/04 17:00:27  feyrer
# Search $BASE/X11R6.3 and $BASE/X11R6.1 for application defaults.
#
# Revision 1.5  1996/12/28 05:54:45  feyrer
# Auto-detect echo-style (BSD/SysV) at runtime, same as in
# EasyBuild.Makefile.
#
# Revision 1.4  1996/12/27 23:46:56  feyrer
# Move definition of $BASE around a bit, tweak commends, reverse history,
# add Log-entry.
#
#      961226 Move definition of $BASE around a bit, tweak commends
#      960518 Implement {pre/post}install
#      960406 Incorporate changes for SysV/BSD-echo and -test
#      960108 Add support for man9/cat9
# V1.4 951126 Add support for directories man/manl and man/catl
# V1.3 950107 Add support for directories man/mann and man/catn
# V1.2 940925 Fix bug when linking directories
# V1.1 940921 Change /opt to /usr/local
# V1.0 940904 Initial hacking
#
#--------------------------------------------------------------------------
# ============== Hubert Feyrer =========================================== 
#      Weekdays: Rennerstr. 19, D-93053 Regensburg,  Tel. 0941/943-1333
#      Weekends: Bachstr. 40,   D-84066 Mallersdorf, Tel. 08772/6084
#      Internet: hubert.feyrer@rz.uni-regensburg.de == IRC: hubertf
# ======================================================================== 
###########################################################################

# Where do we actually link files to?
if [ "$BASE" = "" ]; then
	BASE=/usr/local
fi

# Verbosity control
exec=""		# set to "echo" to display commands 
v1=true		# Introduction blurb
v2=true		# what's going on
v3=false	# debugging stuff
v4=true		# do "$exec command" ? (more debugging)

# Does your ln command understand a -f switch?
ln_f="-f"
#ln_f=""

###########################################################################
# No changes should be made below this line !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# No changes should be made below this line !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# No changes should be made below this line !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# No changes should be made below this line !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# No changes should be made below this line !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# No changes should be made below this line !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# No changes should be made below this line !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# No changes should be made below this line !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# No changes should be made below this line !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
###########################################################################

# Defaults
BIN=""
ETC=""
LIB=""
MAN1=""
MAN2=""
MAN3=""
MAN4=""
MAN5=""
MAN6=""
MAN7=""
MAN8=""
MAN9=""
MANN=""
MANL=""
CAT1=""
CAT2=""
CAT3=""
CAT4=""
CAT5=""
CAT6=""
CAT7=""
CAT8=""
CAT9=""
CATN=""
CATL=""
INFO=""
APPDEF=""
INCLUDE=""
SUIDROOT=""
MISCDIRS=""


checkdir()
{
	if [ ! -d $1 ];
	then
		$v3&&echo creating directory $1
		$v4&&$exec mkdir -p $1
	else
		$v3&&echo directory $1 exists
	fi
}


#
# Get echo-style
#
nobr1=`if [ \` (echo -n a ; echo b) | wc -l\` = 1 ]; then printf "%sn" '-' ; else echo '' ; fi `
nobr2=`if [ \` (echo -n a ; echo b) | wc -l\` = 1 ]; then echo '' ; else echo '\\\\c' ; fi`


#
# Read package-information
#
$v3&&echo using configuration from `dirname $0`/package
. `dirname $0`/package


$v1&& echo Installing $PKG in $BASE
export BASE PKG

#
# run preinstall, if available
#
doit=`dirname $0`/preinstall
if [ -f "$doit" ]; then
	$v2&&echo Running preinstall script
	if [ -x "$doit" ]; then
		$v4&&$exec $doit
	else
		$v4&&$exec sh doit
	fi
fi

#
# Determine directory where application defaults for X go to
#
if [ "$APPDEF" != "" ];
then
	# search some directories
	for d in			\
		/usr			\
		/usr/local/X11R6	\
		/usr/X11R6		\
		/usr/local/X11R5	\
		/usr/X11R5		\
		$BASE/X11R6.3		\
		$BASE/X11R6.1		\
		$BASE/X11R6		\
		$BASE/X11R5;
	do
        	if [ -d  $d/lib/X11/app-defaults ];
        	then
			APPDEFDIR=$d/lib/X11/app-defaults
                	break
        	fi
	done
	# nothing found, ask user
	while [ "$APPDEFDIR" = "" -o ! -d "$APPDEFDIR" ];
	do
		echo Couldn\'t figure out directory for X application-defaults.
		echo $nobr1 "Please specify: " $nobr2
		read APPDEFDIR
	done
        $v3&&echo APPDEFDIR: $APPDEFDIR
fi

#
# Create misc directories, if necessary
#
checkdir $BASE
for i in $MISCDIRS ;
do
	checkdir $BASE/$i
done

#
# Link existing files from package to destination
#
doinstall()
{
	what=$1 ; shift
	dir=$1  ; shift

	if [ "$*" != "" ];
	then
		# mkdir if necessary
		checkdir $BASE/$dir

		$v2&&echo $nobr1 installing $what: $nobr2
		for i in $* ;
		do
			if [ -r "$PKG/$dir/$i" ];
			then
				$v2&&echo $nobr1 " $i" $nobr2
				$v4&&$exec ln -s $ln_f $PKG/$dir/$i $BASE/$dir/$i
			else
				echo ''
				echo '***' ERROR: $PKG/$dir/$i not found!
			fi
		done
		$v2&&echo .
	fi
}

doinstall "binaries"					bin		$BIN
doinstall "etc-files"					etc		$ETC
doinstall "libraries"					lib		$LIB
doinstall "unformatted man-pages for general commands"	man/man1	$MAN1
doinstall "unformatted man-pages for system calls"	man/man2	$MAN2
doinstall "unformatted man-pages for C libraries"	man/man3	$MAN3
doinstall "unformatted man-pages for device driver"	man/man4	$MAN4
doinstall "unformatted man-pages for file formats"	man/man5	$MAN5
doinstall "unformatted man-pages for games"		man/man6	$MAN6
doinstall "unformatted man-pages for miscellaneous"	man/man7	$MAN7
doinstall "unformatted man-pages for system operation"	man/man8	$MAN8
doinstall "unformatted man-pages for kernel internals"	man/man9	$MAN9
doinstall "unformatted man-pages for new software"	man/mann	$MANN
doinstall "unformatted man-pages for local programs"	man/manl	$MANL
doinstall "formatted man-pages for general commands"	man/cat1	$CAT1
doinstall "formatted man-pages for system calls"	man/cat2	$CAT2
doinstall "formatted man-pages for C libraries"		man/cat3	$CAT3
doinstall "formatted man-pages for device driver"	man/cat4	$CAT4
doinstall "formatted man-pages for file formats"	man/cat5	$CAT5
doinstall "formatted man-pages for games"		man/cat6	$CAT6
doinstall "formatted man-pages for miscellaneous"	man/cat7	$CAT7
doinstall "formatted man-pages for system operation"	man/cat8	$CAT8
doinstall "formatted man-pages for kernel internals"	man/cat9	$CAT9
doinstall "formatted man-pages for misc stuff"		man/catn	$CATN
doinstall "formatted man-pages for local programs"	man/catl	$CATL
doinstall "info-manual"					info		$INFO
doinstall "includes"					include		$INCLUDE

#
# application defaults for X
#
if [ "$APPDEF" != "" ];
then
        $v2&&echo $nobr1 installing X application defaults: $nobr2
        for i in $APPDEF ;
        do
                if [ -r "$PKG/$i" ];
                then
                        $v2&&echo $nobr1 " `basename $i .ad`" $nobr2
                        $v4&&$exec ln -s $ln_f $PKG/$i $APPDEFDIR/`basename $i .ad`
                else
			echo ''
                        echo '***' ERROR: $PKG/$i not found!
                fi
        done
        $v2&&echo .
fi

#
# files to setuid-root
#
if [ "$SUIDROOT" != "" ];
then
	$v2&&echo $nobr1 making files setuid root: $nobr2
	for i in $SUIDROOT ;
	do
		if [ -f "$PKG/$i" ];
		then
			$v2&&echo $nobr1 " $i" $nobr2
			$v4&&$exec chown root $PKG/$i
			$v4&&$exec chmod 4111 $PKG/$i
		else
			echo ''
                        echo '***' ERROR: $PKG/$i not found!
		fi
	done
	$v2&&echo .
fi

#
# run postinstall, if available
#
doit=`dirname $0`/postinstall
if [ -f "$doit" ]; then
	$v2&&echo Running postinstall script
	if [ -x "$doit" ]; then
		$v4&&$exec $doit
	else
		$v4&&$exec sh doit
	fi
fi


#
# Remember we're done
#
echo "`date +%s` (`date`) $USER" >`dirname $0`/installed

$v1&&echo Done.
