/* Module notify */

#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/mig_errors.h>

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

/* Due to pcc compiler bug, cannot use void */
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(hc)
#define novalue void
#else
#define novalue int
#endif

#define msgh_request_port	msgh_local_port
#define MACH_MSGH_BITS_REQUEST(bits)	MACH_MSGH_BITS_LOCAL(bits)
#define msgh_reply_port		msgh_remote_port
#define MACH_MSGH_BITS_REPLY(bits)	MACH_MSGH_BITS_REMOTE(bits)

#include <mach/std_types.h>

/* SimpleRoutine mach_notify_port_deleted */
mig_internal novalue _Xmach_notify_port_deleted
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		mach_port_t name;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t do_seqnos_mach_notify_port_deleted
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t notify, mach_port_seqno_t seqno, mach_port_t name);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t nameCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_NAME,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->nameType != * (int *) &nameCheck)
#else	UseStaticMsgType
	if ((In0P->nameType.msgt_inline != TRUE) ||
	    (In0P->nameType.msgt_longform != FALSE) ||
	    (In0P->nameType.msgt_name != MACH_MSG_TYPE_PORT_NAME) ||
	    (In0P->nameType.msgt_number != 1) ||
	    (In0P->nameType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = do_seqnos_mach_notify_port_deleted(In0P->Head.msgh_request_port, In0P->Head.msgh_seqno, In0P->name);
}

/* SimpleRoutine mach_notify_msg_accepted */
mig_internal novalue _Xmach_notify_msg_accepted
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		mach_port_t name;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t do_seqnos_mach_notify_msg_accepted
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t notify, mach_port_seqno_t seqno, mach_port_t name);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t nameCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_NAME,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->nameType != * (int *) &nameCheck)
#else	UseStaticMsgType
	if ((In0P->nameType.msgt_inline != TRUE) ||
	    (In0P->nameType.msgt_longform != FALSE) ||
	    (In0P->nameType.msgt_name != MACH_MSG_TYPE_PORT_NAME) ||
	    (In0P->nameType.msgt_number != 1) ||
	    (In0P->nameType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = do_seqnos_mach_notify_msg_accepted(In0P->Head.msgh_request_port, In0P->Head.msgh_seqno, In0P->name);
}

/* SimpleRoutine mach_notify_port_destroyed */
mig_internal novalue _Xmach_notify_port_destroyed
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t rightsType;
		mach_port_t rights;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t do_seqnos_mach_notify_port_destroyed
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t notify, mach_port_seqno_t seqno, mach_port_t rights);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t rightsCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_RECEIVE,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->rightsType != * (int *) &rightsCheck)
#else	UseStaticMsgType
	if ((In0P->rightsType.msgt_inline != TRUE) ||
	    (In0P->rightsType.msgt_longform != FALSE) ||
	    (In0P->rightsType.msgt_name != MACH_MSG_TYPE_PORT_RECEIVE) ||
	    (In0P->rightsType.msgt_number != 1) ||
	    (In0P->rightsType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = do_seqnos_mach_notify_port_destroyed(In0P->Head.msgh_request_port, In0P->Head.msgh_seqno, In0P->rights);
}

/* SimpleRoutine mach_notify_no_senders */
mig_internal novalue _Xmach_notify_no_senders
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t mscountType;
		mach_port_mscount_t mscount;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t do_seqnos_mach_notify_no_senders
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t notify, mach_port_seqno_t seqno, mach_port_mscount_t mscount);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t mscountCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->mscountType != * (int *) &mscountCheck)
#else	UseStaticMsgType
	if ((In0P->mscountType.msgt_inline != TRUE) ||
	    (In0P->mscountType.msgt_longform != FALSE) ||
	    (In0P->mscountType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->mscountType.msgt_number != 1) ||
	    (In0P->mscountType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = do_seqnos_mach_notify_no_senders(In0P->Head.msgh_request_port, In0P->Head.msgh_seqno, In0P->mscount);
}

/* SimpleRoutine mach_notify_send_once */
mig_internal novalue _Xmach_notify_send_once
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t do_seqnos_mach_notify_send_once
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t notify, mach_port_seqno_t seqno);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = do_seqnos_mach_notify_send_once(In0P->Head.msgh_request_port, In0P->Head.msgh_seqno);
}

/* SimpleRoutine mach_notify_dead_name */
mig_internal novalue _Xmach_notify_dead_name
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		mach_port_t name;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t do_seqnos_mach_notify_dead_name
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t notify, mach_port_seqno_t seqno, mach_port_t name);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t nameCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_NAME,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->nameType != * (int *) &nameCheck)
#else	UseStaticMsgType
	if ((In0P->nameType.msgt_inline != TRUE) ||
	    (In0P->nameType.msgt_longform != FALSE) ||
	    (In0P->nameType.msgt_name != MACH_MSG_TYPE_PORT_NAME) ||
	    (In0P->nameType.msgt_number != 1) ||
	    (In0P->nameType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = do_seqnos_mach_notify_dead_name(In0P->Head.msgh_request_port, In0P->Head.msgh_seqno, In0P->name);
}

static mig_routine_t seqnos_notify_server_routines[] = {
		0,
		_Xmach_notify_port_deleted,
		_Xmach_notify_msg_accepted,
		0,
		0,
		_Xmach_notify_port_destroyed,
		_Xmach_notify_no_senders,
		_Xmach_notify_send_once,
		_Xmach_notify_dead_name,
};

mig_external boolean_t seqnos_notify_server
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	register mach_msg_header_t *InP =  InHeadP;
	register mig_reply_header_t *OutP = (mig_reply_header_t *) OutHeadP;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	register mig_routine_t routine;

	OutP->Head.msgh_bits = MACH_MSGH_BITS(MACH_MSGH_BITS_REPLY(InP->msgh_bits), 0);
	OutP->Head.msgh_size = sizeof *OutP;
	OutP->Head.msgh_remote_port = InP->msgh_reply_port;
	OutP->Head.msgh_local_port = MACH_PORT_NULL;
	OutP->Head.msgh_seqno = 0;
	OutP->Head.msgh_id = InP->msgh_id + 100;

#if	UseStaticMsgType
	OutP->RetCodeType = RetCodeType;
#else	UseStaticMsgType
	OutP->RetCodeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->RetCodeType.msgt_size = 32;
	OutP->RetCodeType.msgt_number = 1;
	OutP->RetCodeType.msgt_inline = TRUE;
	OutP->RetCodeType.msgt_longform = FALSE;
	OutP->RetCodeType.msgt_deallocate = FALSE;
	OutP->RetCodeType.msgt_unused = 0;
#endif	UseStaticMsgType

	if ((InP->msgh_id > 72) || (InP->msgh_id < 64) ||
	    ((routine = seqnos_notify_server_routines[InP->msgh_id - 64]) == 0)) {
		OutP->RetCode = MIG_BAD_ID;
		return FALSE;
	}
	(*routine) (InP, &OutP->Head);
	return TRUE;
}

mig_external mig_routine_t seqnos_notify_server_routine
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP)
#else
	(InHeadP)
	mach_msg_header_t *InHeadP;
#endif
{
	register int msgh_id;

	msgh_id = InHeadP->msgh_id - 64;

	if ((msgh_id > 8) || (msgh_id < 0))
		return 0;

	return seqnos_notify_server_routines[msgh_id];
}

