/* Proc server host management calls
   Copyright (C) 1992 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

static long hostid;
static char *hostname;

error_t
proc_sethostid (struct proc *p,
		int newhostid)
{
  if (! check_uid (p, 0))
    return POSIX_EPERM;
  
  hostid = newhostid;
  return 0;
}

error_t 
proc_gethostid (struct proc *p,
		int *outhostid)
{
  *outhostid = hostid;
  return 0;
}

error_t
proc_sethostname (struct proc *p,
		  char *newhostname)
{
  if (! check_uid (p, 0))
    return POSIX_EPERM;
  
  if (hostname)
    free (hostname);
  hostname = malloc (strlen (newhostname) + 1);
  strcpy (hostname, newhostname);
  return 0;
}

error_t
proc_gethostname (struct proc *p,
		  char *outhostname)
{
  strcpy (outhostname, hostname);
  return 0;
}

error_t
proc_getprivports (struct proc *p,
		   mach_port_t *hostpriv,
		   mach_port_t *devpriv)
{
  if (! check_uid (p, 0))
    return POSIX_EPERM;
  
  *hostpriv = master_host_port;
  *devpriv = master_device_port;
  return 0;
}

error_t
proc_getallpids (struct proc *p,
		 pid_t **pids,
		 int *pidslen)
{
  int nprocs;
  pid_t *loc;
  
  addalltasks ();
  
  nprocs = 0;
  prociterate (count_up, (int) &nprocs);

  if (nprocs > *pidslen)
    vm_allocate (mach_task_self (), (vm_address_t *) &pids,
		 nprocs * sizeof (pid_t), 1);

  loc = pids;
  prociterate (store_pid, (int) &loc);
  *pidslen = nprocs;
  return 0;
}
