/* C declarations for Hurd server interfaces
   Copyright (C) 1991, 1992 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _HURD_TYPES_H
#define _HURD_TYPES_H

typedef mach_port_t file_t;
typedef mach_port_t fsys_t;
typedef mach_port_t io_t;
typedef mach_port_t process_t;
typedef mach_port_t auth_t;
typedef mach_port_t socket_t;
typedef mach_port_t addr_port_t;
typedef mach_port_t startup_t;

typedef char *data_t;
typedef char string_t [1024];
typedef int *intarray_t;
typedef int *fd_mask_t;
typedef mach_port_t *portarray_t;
typedef pid_t *pidarray_t;
typedef uid_t *idarray_t;
typedef struct __rusage rusage_t;
typedef struct sockaddr *sockaddr_t;
typedef kern_return_t error_t;

#define INBAND_MAX_DATA 1024

typedef struct stat io_statbuf_t;

/* stb_fstype is one of: */
#define FSTYPE_UFS     0x00000000 /* 4.x BSD Fast File System */
#define FSTYPE_NFS     0x00000001 /* Network File System ala Sun */
#define FSTYPE_GFS     0x00000002 /* GNU file system */
#define FSTYPE_LFS     0x00000003 /* Logging File System ala Sprite */
#define FSTYPE_SYSV    0x00000004 /* Old U*x filesystem ala System V */
#define FSTYPE_FTP     0x00000005 /* Transparent FTP */
#define FSTYPE_TAR     0x00000006 /* Transparent TAR */
#define FSTYPE_AR      0x00000007 /* Transparent AR */
#define FSTYPE_CPIO    0x00000008 /* Transparent CPIO */
#define FSTYPE_MSLOSS  0x00000009 /* MS-DOS */
#define FSTYPE_CPM     0x0000000a /* CP/M */
#define FSTYPE_HFS     0x0000000b /* Don't ask */
#define FSTYPE_DTFS    0x0000000c /* used by desktop to provide more info */
#define FSTYPE_GRFS    0x0000000d /* GNU Remote File System */
#define FSTYPE_TERM    0x0000000e /* GNU Terminal driver */
#define FSTYPE_DEV     0x0000000f /* GNU Special file server */
#define FSTYPE_PROC    0x00000010 /* /proc filesystem ala Version 9 */
#define FSTYPE_IFSOCK  0x00000011 /* PF_LOCAL socket naming point */
#define FSTYPE_AFS     0x00000012 /* Andrew File System 3.xx */
#define FSTYPE_DFS     0x00000013 /* Distributed File Sys (OSF) == AFS 4.xx */
#define FSTYPE_PROC9   0x00000014 /* /proc filesystem ala Plan 9 */

/* Bits for flags in file_exec and exec_* calls are as follows: */
#define EXEC_NEWTASK	0x00000001 /* create new task; kill old one */
#define EXEC_SECURE	0x00000002 /* use secure values of portarray, etc. */

/* Standard port assignments for file_exec and exec_* */
enum
  {
    INIT_PORT_CWDIR,
    INIT_PORT_CRDIR,
    INIT_PORT_AUTH,
    INIT_PORT_PROC,
    INIT_PORT_LOGINCOLL,
    /* If MACH_PORT_NULL is given for the bootstrap port,
       the bootstrap port of the old task is used.  */
    INIT_PORT_BOOTSTRAP,
    INIT_PORT_MAX
  };

/* Standard ints for file_exec and exec_* */
enum
  {
    INIT_UMASK,
    INIT_CTTY_FSTYPE,
    INIT_CTTY_FSID1,
    INIT_CTTY_FSID2,
    INIT_CTTY_FILEID,
    INIT_SIGMASK,
    INIT_SIGIGN,
    INIT_INT_MAX,
  };

/* Bits for flags in dir_pathtrans call are as follows: */
#define FS_LOOKUP_READ     0x00000001 /* return read-validated port */
#define FS_LOOKUP_WRITE    0x00000002 /* return write-validated port */
#define FS_LOOKUP_EXEC     0x00000004 /* return exec-validated port */
#define FS_LOOKUP_NDELAY   0x00000008 /* don't delay open */
#define FS_LOOKUP_CREATE   0x00000020 /* create if nonexistent */
#define FS_LOOKUP_TRUNCATE 0x00000040 /* truncate atomically */
#define FS_LOOKUP_EXCL     0x00000080 /* error if exists and CREATE */
#define FS_LOOKUP_NOLINK   0x00000100 /* no name mappings on last name */
#define	FS_LOOKUP_NOTRANS  0x00000200 /* No translator on last name.  */

/* Bits for flags in file_set_translator call are as follows: */
#define FS_TRANS_FORCE     0x00000001 /* must use translator(no sht circuit) */
#define FS_TRANS_EXCL      0x00000002 /* don't do it if already translated */

/* Bits which live past the open call: */
#define FS_LOOKUP_LONGLIFE 0x00000017 /* append and access modes */

/* Values for retry field in dir_pathtrans */
enum retry_type
{
  FS_RETRY_NONE,		/* no retry necessary */
  FS_RETRY_NORMAL,		/* retry normally */
  FS_RETRY_REAUTH,		/* retry after reauthenticating retry port */

  /* These are magical and icky.  */
  FS_RETRY_FD,			/* RETRY_NAME is a decimal fd number.  */
  FS_RETRY_TTY,			/* Caller should use his controlling tty.  */
};
typedef enum retry_type retry_type;

/* Select types for io_select */
#define SELECT_READ  0x00000001
#define SELECT_WRITE 0x00000002
#define SELECT_URG   0x00000004

/* Flags for fsys_goaway and file_set_translator */
#define FSYS_GOAWAY_NOWAIT    0x00000001 /* Return immediately */
#define FSYS_GOAWAY_NOSYNC    0x00000002 /* Don't update physical media */
#define FSYS_GOAWAY_FORCE     0x00000004 /* Go away despite current users */
#define FSYS_GOAWAY_UNLINK    0x00000008 /* Go away only if non-dir */

/* This structure is known to be 19 ints long in hurd_types.defs */
struct fsys_statfsbuf
{
  long fsys_stb_type;
  long fsys_stb_bsize;
  long fsys_stb_fsize;
  long fsys_stb_blocks;
  long fsys_stb_bfree;
  long fsys_stb_bavail;
  long fsys_stb_files;
  long fsys_stb_ffree;
  long fsys_stb_fsid_1;
  long fsys_stb_fsid_2;
  long fsys_stb_spare[9];
};
typedef struct fsys_statfsbuf fsys_statfsbuf_t;

/* This structure is known to be 9 ints long in hurd_types.defs */
struct pathconf
{
  long link_max;
  long max_canon;
  long max_input;
  long name_max;
  long path_max;
  long pipe_buf;
  long _posix_chown_restricted;
  long _posix_no_trunc;
  long _posix_vdisable;
};
typedef struct pathconf pathconf_t;

/* Possible types of version info for proc_version.  */
enum verstype
{
  SYSNAME,
  RELEASE,
  VERSION,
  MACHINE,
};

struct procinfo
{
  int state;
  uid_t owner;
  pid_t ppid;
  pid_t pgrp;
  pid_t session;

  int nthreads;			/* size of pi_threadinfos */
  
  struct task_basic_info taskinfo;
  struct
    {
      struct thread_basic_info pis_bi;
      struct thread_sched_info pis_si;
    } threadinfos[0];
};
typedef int *procinfo_t;

/* Bits in state: */
#define PI_STOPPED 0x00000001	/* Proc server thinks is stopped  */
#define PI_EXECED  0x00000002	/* Has called proc_exec */
#define PI_ORPHAN  0x00000008	/* Process group is orphaned */
#define PI_SESSLD  0x00000020	/* Session leader */
#define PI_NOREG   0x00000040	/* Hasn't been registered */
#define PI_NOPARENT 0x0000080	/* Hasn't identified a parent */

/* Return values for sig_post and proc_ctty_kill in the willstop field:  */
enum termsig_stop_type
{
  WILLSTOP,			/* will stop in response to signal */
  IGNBLK,			/* signal is ignored or blocked */
  CATCH,			/* signal is caught */
  ORPHANED,			/* process group is orphaned */
  NOSIG,			/* used internally to term driver */
};

/* Types of ports the terminal driver can run on top of. */
#define TERM_ON_MACHDEV		1
#define TERM_ON_HURDIO		2
#define TERM_ON_MASTERPTY	3

/* Useful destructuring for auth arrays provided by the auth server */
struct idlist
{
  uid_t rid;
  uid_t svid;
  uid_t ids[0];
};


#endif
