#ifndef	_auth
#define	_auth

/* Module auth */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#ifdef	mig_external
mig_external
#else
extern
#endif
void init_auth
#if	(defined(__STDC__) || defined(c_plusplus))
    (mach_port_t rep_port);
#else
    ();
#endif
#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <gnu/types.h>
#include <hurd/hurd_types.h>
#include <lib/libhurd.h>
#include "auth_mig.h"

/* Routine auth_getids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_getids
#if	defined(LINTLIBRARY)
    (handle, id)
	idblockptr_t handle;
	idblock_t *id;
{ return auth_getids(handle, id); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	idblockptr_t handle,
	idblock_t *id
);
#else
    ();
#endif
#endif

/* Routine auth_makeauth */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_makeauth
#if	defined(LINTLIBRARY)
    (handle, id, newhandle)
	idblockptr_t handle;
	idblock_t id;
	mach_port_t *newhandle;
{ return auth_makeauth(handle, id, newhandle); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	idblockptr_t handle,
	idblock_t id,
	mach_port_t *newhandle
);
#else
    ();
#endif
#endif

/* Routine auth_user_authenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_user_authenticate
#if	defined(LINTLIBRARY)
    (handle, reply_port, reply_portPoly, rendezvous, newport)
	idblockptr_t handle;
	mach_port_t reply_port;
	mach_msg_type_name_t reply_portPoly;
	mach_port_t rendezvous;
	mach_port_t *newport;
{ return auth_user_authenticate(handle, reply_port, reply_portPoly, rendezvous, newport); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	idblockptr_t handle,
	mach_port_t reply_port,
	mach_msg_type_name_t reply_portPoly,
	mach_port_t rendezvous,
	mach_port_t *newport
);
#else
    ();
#endif
#endif

/* Routine auth_server_authenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_server_authenticate
#if	defined(LINTLIBRARY)
    (handle, reply_port, reply_portPoly, rendezvous, newport, id)
	idblockptr_t handle;
	mach_port_t reply_port;
	mach_msg_type_name_t reply_portPoly;
	mach_port_t rendezvous;
	mach_port_t newport;
	idblock_t *id;
{ return auth_server_authenticate(handle, reply_port, reply_portPoly, rendezvous, newport, id); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	idblockptr_t handle,
	mach_port_t reply_port,
	mach_msg_type_name_t reply_portPoly,
	mach_port_t rendezvous,
	mach_port_t newport,
	idblock_t *id
);
#else
    ();
#endif
#endif

#endif	_auth
