#include "misc.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port

mig_external void init_misc
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_port_t rep_port)
#else
	(rep_port)
	mach_port_t rep_port;
#endif
{
#ifdef	lint
	rep_port++;
#endif
}

/* Routine sig_post */
mig_external kern_return_t sig_post
#if	(defined(__STDC__) || defined(c_plusplus))
(
	sigthread_t process,
	int signal,
	int orphaned,
	int cttykill,
	int *willstop
)
#else
	(process, signal, orphaned, cttykill, willstop)
	sigthread_t process;
	int signal;
	int orphaned;
	int cttykill;
	int *willstop;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t signalType;
		int signal;
		mach_msg_type_t orphanedType;
		int orphaned;
		mach_msg_type_t cttykillType;
		int cttykill;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t willstopType;
		int willstop;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 48;

#if	UseStaticMsgType
	static mach_msg_type_t signalType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t orphanedType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t cttykillType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t willstopCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->signalType = signalType;
#else	UseStaticMsgType
	InP->signalType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->signalType.msgt_size = 32;
	InP->signalType.msgt_number = 1;
	InP->signalType.msgt_inline = TRUE;
	InP->signalType.msgt_longform = FALSE;
	InP->signalType.msgt_deallocate = FALSE;
	InP->signalType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->signal /* signal */ = /* signal */ signal;

#if	UseStaticMsgType
	InP->orphanedType = orphanedType;
#else	UseStaticMsgType
	InP->orphanedType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->orphanedType.msgt_size = 32;
	InP->orphanedType.msgt_number = 1;
	InP->orphanedType.msgt_inline = TRUE;
	InP->orphanedType.msgt_longform = FALSE;
	InP->orphanedType.msgt_deallocate = FALSE;
	InP->orphanedType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->orphaned /* orphaned */ = /* orphaned */ orphaned;

#if	UseStaticMsgType
	InP->cttykillType = cttykillType;
#else	UseStaticMsgType
	InP->cttykillType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->cttykillType.msgt_size = 32;
	InP->cttykillType.msgt_number = 1;
	InP->cttykillType.msgt_inline = TRUE;
	InP->cttykillType.msgt_longform = FALSE;
	InP->cttykillType.msgt_deallocate = FALSE;
	InP->cttykillType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->cttykill /* cttykill */ = /* cttykill */ cttykill;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = process;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 23000;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 23100)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 40) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->willstopType != * (int *) &willstopCheck)
#else	UseStaticMsgType
	if ((OutP->willstopType.msgt_inline != TRUE) ||
	    (OutP->willstopType.msgt_longform != FALSE) ||
	    (OutP->willstopType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->willstopType.msgt_number != 1) ||
	    (OutP->willstopType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*willstop /* willstop */ = /* *willstop */ OutP->willstop;

	return OutP->RetCode;
}

/* Routine io_select_done */
mig_external kern_return_t io_select_done
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t notify_port,
	int select_result,
	int id_tag
)
#else
	(notify_port, select_result, id_tag)
	mach_port_t notify_port;
	int select_result;
	int id_tag;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t select_resultType;
		int select_result;
		mach_msg_type_t id_tagType;
		int id_tag;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 40;

#if	UseStaticMsgType
	static mach_msg_type_t select_resultType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t id_tagType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->select_resultType = select_resultType;
#else	UseStaticMsgType
	InP->select_resultType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->select_resultType.msgt_size = 32;
	InP->select_resultType.msgt_number = 1;
	InP->select_resultType.msgt_inline = TRUE;
	InP->select_resultType.msgt_longform = FALSE;
	InP->select_resultType.msgt_deallocate = FALSE;
	InP->select_resultType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->select_result /* select_result */ = /* select_result */ select_result;

#if	UseStaticMsgType
	InP->id_tagType = id_tagType;
#else	UseStaticMsgType
	InP->id_tagType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->id_tagType.msgt_size = 32;
	InP->id_tagType.msgt_number = 1;
	InP->id_tagType.msgt_inline = TRUE;
	InP->id_tagType.msgt_longform = FALSE;
	InP->id_tagType.msgt_deallocate = FALSE;
	InP->id_tagType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->id_tag /* id_tag */ = /* id_tag */ id_tag;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = notify_port;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 23001;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 23101)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine proc_newids */
mig_external kern_return_t proc_newids
#if	(defined(__STDC__) || defined(c_plusplus))
(
	sigthread_t process,
	pid_t ppid,
	pid_t pgrp,
	int orphaned
)
#else
	(process, ppid, pgrp, orphaned)
	sigthread_t process;
	pid_t ppid;
	pid_t pgrp;
	int orphaned;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t ppidType;
		pid_t ppid;
		mach_msg_type_t pgrpType;
		pid_t pgrp;
		mach_msg_type_t orphanedType;
		int orphaned;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 48;

#if	UseStaticMsgType
	static mach_msg_type_t ppidType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pgrpType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t orphanedType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->ppidType = ppidType;
#else	UseStaticMsgType
	InP->ppidType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->ppidType.msgt_size = 32;
	InP->ppidType.msgt_number = 1;
	InP->ppidType.msgt_inline = TRUE;
	InP->ppidType.msgt_longform = FALSE;
	InP->ppidType.msgt_deallocate = FALSE;
	InP->ppidType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->ppid /* ppid */ = /* ppid */ ppid;

#if	UseStaticMsgType
	InP->pgrpType = pgrpType;
#else	UseStaticMsgType
	InP->pgrpType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->pgrpType.msgt_size = 32;
	InP->pgrpType.msgt_number = 1;
	InP->pgrpType.msgt_inline = TRUE;
	InP->pgrpType.msgt_longform = FALSE;
	InP->pgrpType.msgt_deallocate = FALSE;
	InP->pgrpType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->pgrp /* pgrp */ = /* pgrp */ pgrp;

#if	UseStaticMsgType
	InP->orphanedType = orphanedType;
#else	UseStaticMsgType
	InP->orphanedType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->orphanedType.msgt_size = 32;
	InP->orphanedType.msgt_number = 1;
	InP->orphanedType.msgt_inline = TRUE;
	InP->orphanedType.msgt_longform = FALSE;
	InP->orphanedType.msgt_deallocate = FALSE;
	InP->orphanedType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->orphaned /* orphaned */ = /* orphaned */ orphaned;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = process;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 23002;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 23102)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}
