/* Module misc */

#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/mig_errors.h>

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

/* Due to pcc compiler bug, cannot use void */
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(hc)
#define novalue void
#else
#define novalue int
#endif

#define msgh_request_port	msgh_local_port
#define MACH_MSGH_BITS_REQUEST(bits)	MACH_MSGH_BITS_LOCAL(bits)
#define msgh_reply_port		msgh_remote_port
#define MACH_MSGH_BITS_REPLY(bits)	MACH_MSGH_BITS_REMOTE(bits)

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <gnu/types.h>
#include <hurd/hurd_types.h>
#include <lib/libhurd.h>

/* Routine sig_post */
mig_internal novalue _Xsig_post
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t signalType;
		int signal;
		mach_msg_type_t orphanedType;
		int orphaned;
		mach_msg_type_t cttykillType;
		int cttykill;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t willstopType;
		int willstop;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t sig_post
#if	(defined(__STDC__) || defined(c_plusplus))
		(sigthread_t process, int signal, int orphaned, int cttykill, int *willstop);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t signalCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t orphanedCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t cttykillCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t willstopType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->signalType != * (int *) &signalCheck)
#else	UseStaticMsgType
	if ((In0P->signalType.msgt_inline != TRUE) ||
	    (In0P->signalType.msgt_longform != FALSE) ||
	    (In0P->signalType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->signalType.msgt_number != 1) ||
	    (In0P->signalType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->orphanedType != * (int *) &orphanedCheck)
#else	UseStaticMsgType
	if ((In0P->orphanedType.msgt_inline != TRUE) ||
	    (In0P->orphanedType.msgt_longform != FALSE) ||
	    (In0P->orphanedType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->orphanedType.msgt_number != 1) ||
	    (In0P->orphanedType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->cttykillType != * (int *) &cttykillCheck)
#else	UseStaticMsgType
	if ((In0P->cttykillType.msgt_inline != TRUE) ||
	    (In0P->cttykillType.msgt_longform != FALSE) ||
	    (In0P->cttykillType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->cttykillType.msgt_number != 1) ||
	    (In0P->cttykillType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = sig_post(In0P->Head.msgh_request_port, In0P->signal, In0P->orphaned, In0P->cttykill, &OutP->willstop);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->willstopType = willstopType;
#else	UseStaticMsgType
	OutP->willstopType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->willstopType.msgt_size = 32;
	OutP->willstopType.msgt_number = 1;
	OutP->willstopType.msgt_inline = TRUE;
	OutP->willstopType.msgt_longform = FALSE;
	OutP->willstopType.msgt_deallocate = FALSE;
	OutP->willstopType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine io_select_done */
mig_internal novalue _Xio_select_done
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t select_resultType;
		int select_result;
		mach_msg_type_t id_tagType;
		int id_tag;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_select_done
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_port_t notify_port, int select_result, int id_tag);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t select_resultCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t id_tagCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->select_resultType != * (int *) &select_resultCheck)
#else	UseStaticMsgType
	if ((In0P->select_resultType.msgt_inline != TRUE) ||
	    (In0P->select_resultType.msgt_longform != FALSE) ||
	    (In0P->select_resultType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->select_resultType.msgt_number != 1) ||
	    (In0P->select_resultType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->id_tagType != * (int *) &id_tagCheck)
#else	UseStaticMsgType
	if ((In0P->id_tagType.msgt_inline != TRUE) ||
	    (In0P->id_tagType.msgt_longform != FALSE) ||
	    (In0P->id_tagType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->id_tagType.msgt_number != 1) ||
	    (In0P->id_tagType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = io_select_done(In0P->Head.msgh_request_port, In0P->select_result, In0P->id_tag);
}

/* Routine proc_newids */
mig_internal novalue _Xproc_newids
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t ppidType;
		pid_t ppid;
		mach_msg_type_t pgrpType;
		pid_t pgrp;
		mach_msg_type_t orphanedType;
		int orphaned;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_newids
#if	(defined(__STDC__) || defined(c_plusplus))
		(sigthread_t process, pid_t ppid, pid_t pgrp, int orphaned);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t ppidCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pgrpCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t orphanedCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->ppidType != * (int *) &ppidCheck)
#else	UseStaticMsgType
	if ((In0P->ppidType.msgt_inline != TRUE) ||
	    (In0P->ppidType.msgt_longform != FALSE) ||
	    (In0P->ppidType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->ppidType.msgt_number != 1) ||
	    (In0P->ppidType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->pgrpType != * (int *) &pgrpCheck)
#else	UseStaticMsgType
	if ((In0P->pgrpType.msgt_inline != TRUE) ||
	    (In0P->pgrpType.msgt_longform != FALSE) ||
	    (In0P->pgrpType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->pgrpType.msgt_number != 1) ||
	    (In0P->pgrpType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->orphanedType != * (int *) &orphanedCheck)
#else	UseStaticMsgType
	if ((In0P->orphanedType.msgt_inline != TRUE) ||
	    (In0P->orphanedType.msgt_longform != FALSE) ||
	    (In0P->orphanedType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->orphanedType.msgt_number != 1) ||
	    (In0P->orphanedType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_newids(In0P->Head.msgh_request_port, In0P->ppid, In0P->pgrp, In0P->orphaned);
}

/* Routine alix_ptrace */
mig_internal novalue _Xalix_ptrace
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t requestType;
		int request;
		mach_msg_type_t addrType;
		int addr;
		mach_msg_type_t dataType;
		int data;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t retType;
		int ret;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t alix_ptrace
#if	(defined(__STDC__) || defined(c_plusplus))
		(sigthread_t process, int request, int addr, int data, int *ret);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t requestCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t addrCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t dataCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t retType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->requestType != * (int *) &requestCheck)
#else	UseStaticMsgType
	if ((In0P->requestType.msgt_inline != TRUE) ||
	    (In0P->requestType.msgt_longform != FALSE) ||
	    (In0P->requestType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->requestType.msgt_number != 1) ||
	    (In0P->requestType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->addrType != * (int *) &addrCheck)
#else	UseStaticMsgType
	if ((In0P->addrType.msgt_inline != TRUE) ||
	    (In0P->addrType.msgt_longform != FALSE) ||
	    (In0P->addrType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->addrType.msgt_number != 1) ||
	    (In0P->addrType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->dataType != * (int *) &dataCheck)
#else	UseStaticMsgType
	if ((In0P->dataType.msgt_inline != TRUE) ||
	    (In0P->dataType.msgt_longform != FALSE) ||
	    (In0P->dataType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->dataType.msgt_number != 1) ||
	    (In0P->dataType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = alix_ptrace(In0P->Head.msgh_request_port, In0P->request, In0P->addr, In0P->data, &OutP->ret);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->retType = retType;
#else	UseStaticMsgType
	OutP->retType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->retType.msgt_size = 32;
	OutP->retType.msgt_number = 1;
	OutP->retType.msgt_inline = TRUE;
	OutP->retType.msgt_longform = FALSE;
	OutP->retType.msgt_deallocate = FALSE;
	OutP->retType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine startup_dosync */
mig_internal novalue _Xstartup_dosync
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t startup_dosync
#if	(defined(__STDC__) || defined(c_plusplus))
		(sigthread_t process);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = startup_dosync(In0P->Head.msgh_request_port);
}

mig_external boolean_t misc_server
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	register mach_msg_header_t *InP =  InHeadP;
	register mig_reply_header_t *OutP = (mig_reply_header_t *) OutHeadP;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	typedef novalue (*SERVER_STUB_PROC)
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_msg_header_t *, mach_msg_header_t *);
#else
		();
#endif
	static SERVER_STUB_PROC routines[] = {
		_Xsig_post,
		_Xio_select_done,
		_Xproc_newids,
		_Xalix_ptrace,
		_Xstartup_dosync,
	};

	register SERVER_STUB_PROC routine;

	OutP->Head.msgh_bits = MACH_MSGH_BITS(MACH_MSGH_BITS_REPLY(InP->msgh_bits), 0);
	OutP->Head.msgh_size = sizeof *OutP;
	OutP->Head.msgh_remote_port = InP->msgh_reply_port;
	OutP->Head.msgh_local_port = MACH_PORT_NULL;
	OutP->Head.msgh_seqno = 0;
	OutP->Head.msgh_id = InP->msgh_id + 100;

#if	UseStaticMsgType
	OutP->RetCodeType = RetCodeType;
#else	UseStaticMsgType
	OutP->RetCodeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->RetCodeType.msgt_size = 32;
	OutP->RetCodeType.msgt_number = 1;
	OutP->RetCodeType.msgt_inline = TRUE;
	OutP->RetCodeType.msgt_longform = FALSE;
	OutP->RetCodeType.msgt_deallocate = FALSE;
	OutP->RetCodeType.msgt_unused = 0;
#endif	UseStaticMsgType

	if ((InP->msgh_id > 23004) || (InP->msgh_id < 23000) ||
	    ((routine = routines[InP->msgh_id - 23000]) == 0)) {
		OutP->RetCode = MIG_BAD_ID;
		return FALSE;
	}
	(*routine) (InP, &OutP->Head);
	return TRUE;
}
