/* Startup routines for emulator
   Copyright (C) 1991 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

/* Various initialization depended on by everybody. */
void
mach_init ()
{
  vm_statistics_data_t vm_stat;

  /* Parens force procedure call instead of macro */
  mach_task_self_ = (mach_task_self)();
  vm_statistics (mach_task_self_, &vm_stat);
  vm_page_size = vm_stat.pagesize;
}

/* When the machine dependent start routine begins, it calls mach_init
   (above), and mman_init (in alix_mman.c).  Then it gets a real stack to
   run on, and calls this routine. */
startup ()
{
  mach_port_t bootport;
  void *argv, *envp;
  int argvlen, envplen;
  int argvdealloc, envpdealloc;
  int startaddr;
  file_t init_cwdir, init_crdir;
  auth_t init_auth;
  process_t init_proc;
  file_t *init_fds;
  int init_fdslen;
  int init_fdsdealloc;
    
  task_get_special_port (mach_task_self (), TASK_BOOTSTRAP_PORT, &bootport);
  init_fdslen = argvlen = envplen = 0;
  exec_newtask_startup (bootport, &argv, &argvlen, &argvdealloc,
			&envp, &envplen, &envpdealloc, &startaddr, 
			&init_fds, &init_fdslen, &init_fdsdealloc,
			&init_crdir, &init_cwdir, &init_auth, &init_proc);
  setargs (argv, argvlen, envp, envplen);
  if (argvdealloc)
    vm_deallocate (mach_task_self (), argv, argvlen);
  if (envpdealloc)
    vm_deallocate (mach_task_self (), envp, envplen);
 
  /* init auth */
  mutex_init (&authlock);
  authserver = init_auth;
  idblockvalid = 0;
  
  /* init io */
  mutex_init (&iolock);
  dtablesize = init_fdslen;
  dtable = malloc (init_fdslen * sizeof (struct filed));
  for (i = 0; i < init_fdslen; i++)
    dtable[i] = init_fds[i];
  /* CTTY? XXX */
  cwdir = init_cwdir;
  crdir = init_crdir;
  ccdir = init_cwdir;
  
  /* 



