#ifndef	_io_server_
#define	_io_server_

/* Module io */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <hurd/hurd_types.h>
#include "ufs.h"

/* Routine io_write */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_write
#if	defined(LINTLIBRARY)
    (io_object, data, dataCnt, offset, amount)
	protid_t io_object;
	data_t data;
	mach_msg_type_number_t dataCnt;
	int offset;
	int *amount;
{ return io_write(io_object, data, dataCnt, offset, amount); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	data_t data,
	mach_msg_type_number_t dataCnt,
	int offset,
	int *amount
);
#else
    ();
#endif
#endif

/* Routine io_read */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_read
#if	defined(LINTLIBRARY)
    (io_object, data, dataCnt, offset, amount)
	protid_t io_object;
	data_t *data;
	mach_msg_type_number_t *dataCnt;
	int offset;
	int amount;
{ return io_read(io_object, data, dataCnt, offset, amount); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	data_t *data,
	mach_msg_type_number_t *dataCnt,
	int offset,
	int amount
);
#else
    ();
#endif
#endif

/* Routine io_readable */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_readable
#if	defined(LINTLIBRARY)
    (io_object, amount)
	protid_t io_object;
	int *amount;
{ return io_readable(io_object, amount); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	int *amount
);
#else
    ();
#endif
#endif

/* Routine io_mod_nonblock */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_mod_nonblock
#if	defined(LINTLIBRARY)
    (io_object, on_or_off)
	protid_t io_object;
	int on_or_off;
{ return io_mod_nonblock(io_object, on_or_off); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	int on_or_off
);
#else
    ();
#endif
#endif

/* Routine io_get_nonblock */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_get_nonblock
#if	defined(LINTLIBRARY)
    (io_object, on_or_off)
	protid_t io_object;
	int *on_or_off;
{ return io_get_nonblock(io_object, on_or_off); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	int *on_or_off
);
#else
    ();
#endif
#endif

/* Routine io_mod_append */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_mod_append
#if	defined(LINTLIBRARY)
    (io_object, on_or_off)
	protid_t io_object;
	int on_or_off;
{ return io_mod_append(io_object, on_or_off); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	int on_or_off
);
#else
    ();
#endif
#endif

/* Routine io_get_append */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_get_append
#if	defined(LINTLIBRARY)
    (io_object, on_or_off)
	protid_t io_object;
	int *on_or_off;
{ return io_get_append(io_object, on_or_off); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	int *on_or_off
);
#else
    ();
#endif
#endif

/* Routine io_async */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_async
#if	defined(LINTLIBRARY)
    (io_object, notify_port, async_id_port)
	protid_t io_object;
	mach_port_t notify_port;
	mach_port_t *async_id_port;
{ return io_async(io_object, notify_port, async_id_port); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	mach_port_t notify_port,
	mach_port_t *async_id_port
);
#else
    ();
#endif
#endif

/* Routine io_mod_owner */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_mod_owner
#if	defined(LINTLIBRARY)
    (io_object, owner)
	protid_t io_object;
	pid_t owner;
{ return io_mod_owner(io_object, owner); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	pid_t owner
);
#else
    ();
#endif
#endif

/* Routine io_get_owner */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_get_owner
#if	defined(LINTLIBRARY)
    (io_object, owner)
	protid_t io_object;
	pid_t *owner;
{ return io_get_owner(io_object, owner); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	pid_t *owner
);
#else
    ();
#endif
#endif

/* Routine io_mod_async_icky */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_mod_async_icky
#if	defined(LINTLIBRARY)
    (io_object, on_or_off, icky_async_id_port)
	protid_t io_object;
	int on_or_off;
	mach_port_t *icky_async_id_port;
{ return io_mod_async_icky(io_object, on_or_off, icky_async_id_port); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	int on_or_off,
	mach_port_t *icky_async_id_port
);
#else
    ();
#endif
#endif

/* Routine io_get_icky_async_id */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_get_icky_async_id
#if	defined(LINTLIBRARY)
    (io_object, icky_async_id_port)
	protid_t io_object;
	mach_port_t *icky_async_id_port;
{ return io_get_icky_async_id(io_object, icky_async_id_port); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	mach_port_t *icky_async_id_port
);
#else
    ();
#endif
#endif

/* Routine io_get_async_icky */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_get_async_icky
#if	defined(LINTLIBRARY)
    (io_object, on_or_off)
	protid_t io_object;
	int *on_or_off;
{ return io_get_async_icky(io_object, on_or_off); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	int *on_or_off
);
#else
    ();
#endif
#endif

/* Routine io_get_openstat */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_get_openstat
#if	defined(LINTLIBRARY)
    (io_object, open_stat)
	protid_t io_object;
	int *open_stat;
{ return io_get_openstat(io_object, open_stat); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	int *open_stat
);
#else
    ();
#endif
#endif

/* Routine io_select */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_select
#if	defined(LINTLIBRARY)
    (io_object, select_type, return_port, id_tag, select_result)
	protid_t io_object;
	int select_type;
	mach_port_t return_port;
	int id_tag;
	int *select_result;
{ return io_select(io_object, select_type, return_port, id_tag, select_result); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	int select_type,
	mach_port_t return_port,
	int id_tag,
	int *select_result
);
#else
    ();
#endif
#endif

/* Routine io_stat */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_stat
#if	defined(LINTLIBRARY)
    (stat_object, stat_info)
	protid_t stat_object;
	io_statbuf_t *stat_info;
{ return io_stat(stat_object, stat_info); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t stat_object,
	io_statbuf_t *stat_info
);
#else
    ();
#endif
#endif

/* SimpleRoutine io_reauthenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_reauthenticate
#if	defined(LINTLIBRARY)
    (auth_object)
	protid_t auth_object;
{ return io_reauthenticate(auth_object); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t auth_object
);
#else
    ();
#endif
#endif

/* Routine io_server_version */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_server_version
#if	defined(LINTLIBRARY)
    (vers_object, server_name, server_major_version, server_minor_version, server_edit_level)
	protid_t vers_object;
	string_t server_name;
	int *server_major_version;
	int *server_minor_version;
	int *server_edit_level;
{ return io_server_version(vers_object, server_name, server_major_version, server_minor_version, server_edit_level); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t vers_object,
	string_t server_name,
	int *server_major_version,
	int *server_minor_version,
	int *server_edit_level
);
#else
    ();
#endif
#endif

/* Routine io_map */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_map
#if	defined(LINTLIBRARY)
    (io_object, memobjxx, memobjrd, memobjwt)
	protid_t io_object;
	mach_port_t *memobjxx;
	mach_port_t *memobjrd;
	mach_port_t *memobjwt;
{ return io_map(io_object, memobjxx, memobjrd, memobjwt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	mach_port_t *memobjxx,
	mach_port_t *memobjrd,
	mach_port_t *memobjwt
);
#else
    ();
#endif
#endif

/* Routine io_map_cntl */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_map_cntl
#if	defined(LINTLIBRARY)
    (io_object, memobj)
	protid_t io_object;
	mach_port_t *memobj;
{ return io_map_cntl(io_object, memobj); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	mach_port_t *memobj
);
#else
    ();
#endif
#endif

/* Routine io_get_it */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_get_it
#if	defined(LINTLIBRARY)
    (io_object, cntl)
	protid_t io_object;
	mach_port_t cntl;
{ return io_get_it(io_object, cntl); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	mach_port_t cntl
);
#else
    ();
#endif
#endif

/* Routine io_release_it */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_release_it
#if	defined(LINTLIBRARY)
    (io_object, cntl)
	protid_t io_object;
	mach_port_t cntl;
{ return io_release_it(io_object, cntl); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	mach_port_t cntl
);
#else
    ();
#endif
#endif

/* Routine io_eofnotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_eofnotify
#if	defined(LINTLIBRARY)
    (io_object, cntl)
	protid_t io_object;
	mach_port_t cntl;
{ return io_eofnotify(io_object, cntl); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	mach_port_t cntl
);
#else
    ();
#endif
#endif

/* Routine io_prenotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_prenotify
#if	defined(LINTLIBRARY)
    (io_object, cntl, write_start, write_end)
	protid_t io_object;
	mach_port_t cntl;
	int write_start;
	int write_end;
{ return io_prenotify(io_object, cntl, write_start, write_end); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	mach_port_t cntl,
	int write_start,
	int write_end
);
#else
    ();
#endif
#endif

/* Routine io_postnotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_postnotify
#if	defined(LINTLIBRARY)
    (io_object, cntl, write_start, write_end)
	protid_t io_object;
	mach_port_t cntl;
	int write_start;
	int write_end;
{ return io_postnotify(io_object, cntl, write_start, write_end); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	mach_port_t cntl,
	int write_start,
	int write_end
);
#else
    ();
#endif
#endif

/* Routine io_readsleep */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_readsleep
#if	defined(LINTLIBRARY)
    (io_object, cntl)
	protid_t io_object;
	mach_port_t cntl;
{ return io_readsleep(io_object, cntl); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	mach_port_t cntl
);
#else
    ();
#endif
#endif

/* Routine io_sigio */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_sigio
#if	defined(LINTLIBRARY)
    (io_object, cntl)
	protid_t io_object;
	mach_port_t cntl;
{ return io_sigio(io_object, cntl); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	protid_t io_object,
	mach_port_t cntl
);
#else
    ();
#endif
#endif

#endif	_io_server_
