#include "auth_reply.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port

mig_external void init_auth_reply
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_port_t rep_port)
#else
	(rep_port)
	mach_port_t rep_port;
#endif
{
#ifdef	lint
	rep_port++;
#endif
}

/* SimpleRoutine auth_user_authenticate_reply */
mig_external kern_return_t auth_user_authenticate_reply
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t reply_port,
	mach_msg_type_name_t reply_portPoly,
	kern_return_t return_code,
	mach_port_t newhandle
)
#else
	(reply_port, reply_portPoly, return_code, newhandle)
	mach_port_t reply_port;
	mach_msg_type_name_t reply_portPoly;
	kern_return_t return_code;
	mach_port_t newhandle;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t return_codeType;
		kern_return_t return_code;
		mach_msg_type_t newhandleType;
		mach_port_t newhandle;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;

	mach_msg_return_t msg_result;
	unsigned int msgh_size = 40;

#if	UseStaticMsgType
	static mach_msg_type_t return_codeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t newhandleType = {
		/* msgt_name = */		MACH_MSG_TYPE_MAKE_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->return_codeType = return_codeType;
#else	UseStaticMsgType
	InP->return_codeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->return_codeType.msgt_size = 32;
	InP->return_codeType.msgt_number = 1;
	InP->return_codeType.msgt_inline = TRUE;
	InP->return_codeType.msgt_longform = FALSE;
	InP->return_codeType.msgt_deallocate = FALSE;
	InP->return_codeType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->return_code /* return_code */ = /* return_code */ return_code;

#if	UseStaticMsgType
	InP->newhandleType = newhandleType;
#else	UseStaticMsgType
	InP->newhandleType.msgt_name = MACH_MSG_TYPE_MAKE_SEND;
	InP->newhandleType.msgt_size = 32;
	InP->newhandleType.msgt_number = 1;
	InP->newhandleType.msgt_inline = TRUE;
	InP->newhandleType.msgt_longform = FALSE;
	InP->newhandleType.msgt_deallocate = FALSE;
	InP->newhandleType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->newhandle /* newhandle */ = /* newhandle */ newhandle;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(reply_portPoly, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = reply_port;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL;
	InP->Head.msgh_id = 25102;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, msgh_size, 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	return msg_result;
}

/* SimpleRoutine auth_server_authenticate_reply */
mig_external kern_return_t auth_server_authenticate_reply
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t reply_port,
	mach_msg_type_name_t reply_portPoly,
	kern_return_t return_code,
	idblock_t idblock
)
#else
	(reply_port, reply_portPoly, return_code, idblock)
	mach_port_t reply_port;
	mach_msg_type_name_t reply_portPoly;
	kern_return_t return_code;
	idblock_t idblock;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t return_codeType;
		kern_return_t return_code;
		mach_msg_type_t idblockType;
		idblock_t idblock;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;

	mach_msg_return_t msg_result;
	unsigned int msgh_size = 548;

#if	UseStaticMsgType
	static mach_msg_type_t return_codeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t idblockType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_16,
		/* msgt_size = */		16,
		/* msgt_number = */		256,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->return_codeType = return_codeType;
#else	UseStaticMsgType
	InP->return_codeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->return_codeType.msgt_size = 32;
	InP->return_codeType.msgt_number = 1;
	InP->return_codeType.msgt_inline = TRUE;
	InP->return_codeType.msgt_longform = FALSE;
	InP->return_codeType.msgt_deallocate = FALSE;
	InP->return_codeType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->return_code /* return_code */ = /* return_code */ return_code;

#if	UseStaticMsgType
	InP->idblockType = idblockType;
#else	UseStaticMsgType
	InP->idblockType.msgt_name = MACH_MSG_TYPE_INTEGER_16;
	InP->idblockType.msgt_size = 16;
	InP->idblockType.msgt_number = 256;
	InP->idblockType.msgt_inline = TRUE;
	InP->idblockType.msgt_longform = FALSE;
	InP->idblockType.msgt_deallocate = FALSE;
	InP->idblockType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->idblock /* idblock */ = /* idblock */ idblock;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(reply_portPoly, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = reply_port;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL;
	InP->Head.msgh_id = 25103;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, msgh_size, 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	return msg_result;
}
