#ifndef	_auth_user_
#define	_auth_user_

/* Module auth */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <gnu/types.h>
#include <hurd/hurd_types.h>
#include <lib/libhurd.h>

/* Routine auth_getids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_getids
#if	defined(LINTLIBRARY)
    (handle, id)
	auth_t handle;
	idblock_t *id;
{ return auth_getids(handle, id); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	auth_t handle,
	idblock_t *id
);
#else
    ();
#endif
#endif

/* Routine auth_makeauth */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_makeauth
#if	defined(LINTLIBRARY)
    (handle, id, newhandle)
	auth_t handle;
	idblock_t id;
	mach_port_t *newhandle;
{ return auth_makeauth(handle, id, newhandle); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	auth_t handle,
	idblock_t id,
	mach_port_t *newhandle
);
#else
    ();
#endif
#endif

/* Routine auth_user_authenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_user_authenticate
#if	defined(LINTLIBRARY)
    (handle, rendezvous, newport)
	auth_t handle;
	mach_port_t rendezvous;
	mach_port_t *newport;
{ return auth_user_authenticate(handle, rendezvous, newport); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	auth_t handle,
	mach_port_t rendezvous,
	mach_port_t *newport
);
#else
    ();
#endif
#endif

/* Routine auth_server_authenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_server_authenticate
#if	defined(LINTLIBRARY)
    (handle, rendezvous, newport, id)
	auth_t handle;
	mach_port_t rendezvous;
	mach_port_t newport;
	idblock_t *id;
{ return auth_server_authenticate(handle, rendezvous, newport, id); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	auth_t handle,
	mach_port_t rendezvous,
	mach_port_t newport,
	idblock_t *id
);
#else
    ();
#endif
#endif

#endif	_auth_user_
