/* Definitions for access from alix to I/O servers
   Copyright (C) 1991 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

struct mutex iolock;

int dtablesize;

/* To lock a filed, you must already hold the iolock.  */
struct filed 
{
  io_t ioserver;		/* server for requests */
};

/* This defines our controlling terminal so we can identify it:  */
int ctty_fstype;
fsid_t ctty_fsid;
ino_t ctty_fileid;
int hasctty;

struct filed *dtable;

file_t cwdir, crdir;		/* current working and root directories */
file_t ccdir;			/* where a core file goes */

int falloc (void);
int ctty_check (int);
