#pragma once

#include <sys/file.h>

/* values for the first argument to fcntl */

#define F_DUPFD 0		/* Duplicate file descriptor */
#define F_GETFD 1		/* Get file descriptor flags */
#define F_SETFD 2		/* Set file descriptor flags */
#define F_GETFL 3		/* Get file status flags */
#define F_SETFL 4		/* Set file status flags */
#define F_GETLK 7		/* Get record locking information */
#define F_SETLK 8		/* Set record locking information */
#define F_SETLKW 9		/* Set record locking information, wait */

#ifndef _POSIX_SOURCE
#define F_GETOWN 5		/* Get file descriptor owner */
#define F_SETOWN 6		/* Set file descriptor owner */
#endif

/* File descriptor flag */
#define FD_CLOEXEC 1

/* File status flags are in sys/file.h */

/* Third fcntl argument for F_GETLK, F_SETLK, F_SETLKW commands */
struct flock 
{
  short l_type;
  short l_whence;
  off_t l_start;
  off_t l_len;
  pid_t l_pid;
};

/* l_type field of flock structure */
#define F_RDLCK 1
#define F_WRLCK 2
#define F_UNLCK 3


