/* 
 * Mach Operating System
 * Copyright (c) 1991 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon 
 * the rights to redistribute these changes.
 */

/*
 * HISTORY
 * $Log:	thread.c,v $
 * Revision 2.2  91/08/24  12:35:41  af
 * 	Created.
 * 	[91/07/19  18:45:28  danner]
 * 
 * Revision 2.1.3.1  91/08/19  13:49:41  danner
 * 	Created by rwd
 * 
 * 	              90/09/11            ohm@astem.or.jp
 * 	Re-ported to luna88k.
 * 	[91/07/19  18:45:28  danner]
 * 
 * Revision 1.2  89/05/05  19:02:59  mrt
 * 	Cleanup for Mach 2.5
 * 
 */
/*
 * luna/thread.c
 *
 * Cproc startup for LUNA88K MTHREAD implementation.
 */

#ifndef	lint
static char rcs_id[] = "$Header: thread.c,v 2.2 91/08/24 12:35:41 af Exp $";
#endif	not lint



#include <cthreads.h>
#include "cthread_internals.h"

int
cthread_sp()
{
	int x;

	return (int) &x;
}


#include <mach/mach.h>

/*
 * C library imports:
 */
extern bzero();

/*
 * Set up the initial state of a MACH thread
 * so that it will invoke cthread_body(child)
 * when it is resumed.
 */
void
cproc_setup(child, thread, routine)
	register cproc_t child;
	int thread;
	int routine;
{
	register int *top = (int *) (child->stack_base + child->stack_size);
	struct luna88k_thread_state state;
	register struct luna88k_thread_state *ts = &state;
	kern_return_t r;

	/*
	 * Set up M88000 call frame and registers.
	 * See M88100 Manual, Object Compatibility Standard/88open,
	 * GNU C compiler documentation, GreenHills C compiler documentation,
	 * etc.
	 */
	bzero((char *) ts, sizeof(struct luna88k_thread_state));
	/*
	 * Set pc(fetch instruction pointer) to location of procedure entry.
	 * Inner cast needed since too many C compilers choke on the type void (*)().
	 */
	ts->fip = routine;
	ts->r[2] = (int) child;	/* argument to function */
	ts->fpcr = 0x1f;	/* matched with locore.s, signal is default */
	ts->r[30] = 0; /* frame pointer, points 0 */
	ts->r[31] = ((int)top - 2*sizeof(int)); /* stack pointer, points arg area */

	MACH_CALL(thread_set_state(thread, \
				   LUNA88K_THREAD_STATE, \
				   (thread_state_t) &state, \
				   LUNA88K_THREAD_STATE_COUNT),
		  r);
}
