/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	bsd_ioctl.h,v $
 * Revision 2.2  90/09/08  00:07:22  rwd
 * 	First checkin
 * 	[90/08/31  13:31:40  rwd]
 * 
 */
/*
 *	File:	bsd_ioctl.h
 *	Author:	Joseph S. Barrera III, Randall W. Dean
 *
 *	Copyright (c) 1990 Joseph S. Barrera III, Randall W. Dean
 */

/*
 * Get command byte from an ioctl definition (eg icmd(TIOCGETP) = 8))
 */
#define	icmd(xxx)	((xxx) & 0xff)

/*
 * Copy server structure in or out.
 * Should be invoked inside xxx_ioctl fnode op with
 * first argument declared as rw and
 * last two arguments declared as param and psize.
 */
#define	PCOPY(server)	pcopy(rw, server, param, psize)
