/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	bsd_fops2.c,v $
 * Revision 2.2  90/09/08  00:07:02  rwd
 * 	First checkin
 * 	[90/08/31  13:29:41  rwd]
 * 
 */
/*
 *	File:	./bsd_fops2.c
 *	Author:	Joseph S. Barrera III, Randall W. Dean
 *
 *	Copyright (c) 1990 Joseph S. Barrera III, Randall W. Dean
 */

#include <mach.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fnode.h>
#include <ux_user.h>

fnode_stat(ut, fn, stp)
	struct ux_task *ut;
	struct fnode *fn;
	struct stat *stp;
{
	int error;

	error = FOP_GETSTAT(fn, stp, FATTR_ALL);
	FOP_DECR(fn);
	if (error) {
		return error;
	}
	return 0;
}

fnode_chmod(ut, fn, mode)
	struct ux_task *ut;
	struct fnode *fn;
	int mode;
{
	struct stat st;
	int error;

	st.st_mode = mode;
	error = FOP_SETSTAT(fn, &st, FATTR_MODE);
	FOP_DECR(fn);
	return error;
}

fnode_chown(ut, fn, uid, gid)
	struct ux_task *ut;
	struct fnode *fn;
	int uid;
	int gid;
{
	struct stat st;
	int error, mask;

	mask = 0;
	if (uid != -1) {
		mask |= FATTR_UID;
		st.st_uid = uid;
	}
	if (gid != -1) {
		mask |= FATTR_GID;
		st.st_gid = gid;
	}
	error = FOP_SETSTAT(fn, &st, mask);
	FOP_DECR(fn);
	return error;
}

fnode_truncate(ut, fn, size)
	struct ux_task *ut;
	struct fnode *fn;
	int size;
{
	struct stat st;
	int error;

	error = FOP_GETSTAT(fn, &st, FATTR_SIZE);
	if (error || st.st_size <= size) {
		FOP_DECR(fn);
		return error;
	}
	st.st_size = size;
	error = FOP_SETSTAT(fn, &st, FATTR_SIZE);
	FOP_DECR(fn);
	return error;
}
