/* 
 * Mach Operating System
 * Copyright (c) 1992 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon 
 * the rights to redistribute these changes.
 */
/*
 *	File:	sun3/thread.h
 *	Author:	Avadis Tevanian, Jr.
 *
 *	This file defines machine specific, thread related structures,
 *	variables and macros.
 *
 * HISTORY
 * $Log:	thread.h,v $
 * Revision 2.4  92/03/03  14:22:55  rpd
 * 	Added dummy definition of syscall_emulation_sync.
 * 	[92/03/03            rpd]
 * 
 * Revision 2.3  91/07/31  18:14:39  dbg
 * 	Support stack switching.
 * 	[91/03/25            dbg]
 * 
 * Revision 2.2  91/01/08  15:52:50  rpd
 * 	Added KEEP_STACKS support.
 * 	[91/01/06            rpd]
 * 
 * Revision 2.1  89/08/03  16:53:40  rwd
 * Created.
 * 
 * 20-Jul-88  David Golub (dbg) at Carnegie-Mellon University
 *	Move kernel state fields to this file.
 *
 * 25-Jan-88  Robert Baron (rvb) at Carnegie-Mellon University
 *	Rather than have "u" expand to current_thread()->u_address, have
 *	it expand to the constant U_ADDRESS which is updated by load_context
 *	when the thread changes.  If "u" is defined then user.h won't define
 *	it.  U_ADDRESS is extern because when we are included by sys/thread.h
 *	u_address has not been defined yet.
 *
 *  2-Apr-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Created, no definitions here yet.
 *
 */

#ifndef	_SUN3_THREAD_
#define	_SUN3_THREAD_

#include <mach/kern_return.h>

#include <sun3/buserr.h>
#include <sun3/reg.h>

/*
 * User registers are pushed on PCB stack.  Bus error frame
 * follows this.  Variable length - the end address is fixed.
 *
 * Kernel registers are pushed on kernel stack.
 */
struct mc68020_saved_state {
	int		d0;		/* data registers */
	int		d1;
	int		d2;
	int		d3;
	int		d4;
	int		d5;
	int		d6;
	int		d7;
	int		a0;		/* address registers */
	int		a1;
	int		a2;
	int		a3;
	int		a4;
	int		a5;
	int		a6;
	int		sp;		/* stack pointer */
	unsigned short	sr;		/* status register */
	unsigned int	pc;		/* program counter - UNALIGNED!!! */
	unsigned int	stkfmt	: 4;	/* rte stack frame format */
	unsigned int	vector	: 12;	/* vector number */
};


/*
 * Other user machine state, saved on context switch.
 */

/*
 * 68881 floating-point state.
 */
struct mc68881_state {
	struct fp_status	fp_status;	/* user-visible 68881 state */
	struct fp_istate	fp_istate;	/* internal 68881 state */
};

/*
 * Weitek floating-point accelerator.
 */
struct fpa_stack {
	short		fpst_save_size;		/* size of saved frame */
	short		fpst_alloc_size;	/* size of this structure */
	long		fpst_ast_bits;		/* saved AST bits */
	struct mc68020_saved_state
			fpst_regs;		/* saved registers and fmt */
	struct bei_longb fpst_longb;		/* and frame */
};

struct fpa_state {
	struct fpa_status	fpa_status;	/* fpa internal status */
	struct fpa_exception {
	    struct fpa_stack *	fe_fmtptr;	/* points to saved
						   bus error frame */
	    int			fe_pc;		/* user pc where
	    					   bus error occurred */
	} fpa_exception;
#define	fpa_fmtptr		fpa_exception.fe_fmtptr
#define	fpa_pc			fpa_exception.fe_pc
	fpa_long		fpa_data[FPA_NDATA_REGS];
						/* fpa registers */
};

/*
 * User state is allocated lots of space, since it varies in
 * size and moves.  Its TOP is fixed, not its bottom.
 */
#define	USER_STATE_EXTRA	64
					/* 16 words for stack switching */
#define	USER_STATE_SIZE	(USER_STATE_EXTRA \
			+sizeof(struct mc68020_saved_state) \
			+sizeof(struct bei_longb))

struct pcb {
	unsigned char		flag;		/* user - trace flags */
	unsigned char		discard_frame;	/* user - discard bus-error
							  info on exit */
	unsigned short		fault_type;	/* user - fault type */
	vm_offset_t		fault_addr;	/* user - faulting address */
	struct mc68020_saved_state *
				user_regs;	/* pointer to user state */
	char			user_state[USER_STATE_SIZE];
						/* user state pushed here */
	struct mc68881_state	mc68881s;	/* 68881 state, if in use */
	struct fpa_state *	fpas;		/* fpa state, if in use */
};
typedef struct pcb	*pcb_t;

/*
 * Bits in flag byte.
 */
#define	AST_STEP	0x40		/* force a single step */
#define	TRACE_USER	0x20		/* user has requested tracing */
#define	TRACE_AST	0x10		/* AST has requested tracing */
#define	TRACE_PENDING	0x08		/* user trace caught in supervisor
					   mode */
#define	TRACE_KDB	0x04		/* trace is for KDB (single step
					   supervisor mode) */
#define	AST_CLR		(AST_STEP|TRACE_USER|TRACE_AST|TRACE_PENDING)

#define	FPA_USED	0x02		/* FPA used by this thread */
#define	FPA_SAVED	0x01		/* FPA context saved in PCB,
					   if FPA_USED; otherwise,
					   pcb_fpa_status.fpas_state
					   gives the register set. */


/*
 * State saved on kernel context switch.
 */
struct mc68020_kernel_state {
	int		d2;
	int		d3;
	int		d4;
	int		d5;
	int		d6;
	int		d7;
	int		a2;
	int		a3;
	int		a4;
	int		a5;
	int		a6;
	int		sp;
	int		pc;
};

#define	STACK_MKS(stack) \
	((struct mc68020_kernel_state *)((stack) + KERNEL_STACK_SIZE) - 1)


/*
 *	Routine definitions
 */
extern void		pcb_init();
extern void		pcb_terminate();
extern kern_return_t	thread_setstatus();
extern kern_return_t	thread_getstatus();

#define syscall_emulation_sync(task)	/* do nothing */

#endif  /* _SUN3_THREAD_H_ */
