/* 
 * Mach Operating System
 * Copyright (c) 1991,1990,1989 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator   or   Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they made and grant Carnegie Mellon
 * the rights to redistribute these changes.
 **********************************************************************
 * Author:  Alessandro Forin (af) at Carnegie-Mellon University
 *
 * HISTORY
 * $Log:	emul_vector.s,v $
 * Revision 2.4  92/02/02  13:01:20  rpd
 * 	Fixed for gcc.
 * 	[92/01/30            rpd]
 * 
 * Revision 2.3  91/12/19  20:25:43  mrt
 * 	Updated to new copyright
 * 
 * Revision 2.2  90/11/16  11:41:35  rwd
 * 	Taken from UX21
 * 	[90/11/14  15:05:31  rwd]
 * 
 * Revision 2.3  89/08/31  16:28:24  rwd
 * 	Always pop 6 bytes.  Everything else is taken care of elsewhere.
 * 	[89/08/24            rwd]
 * 	Changed to reflect change in trampline code which includes
 * 	syscall #
 * 	[89/08/23            rwd]
 * 
 * 	Pop only 2 bytes if emul_syscall returns 1.
 * 	[89/08/21            rwd]
 * 
 * Revision 2.2  89/08/09  14:35:23  rwd
 * 	Fixed register saving and child init carry clear.
 * 	[89/06/22            rwd]
 * 
 * 10-May-89  David Golub (dbg) at Carnegie-Mellon University
 *	Created SUN3 version from VAX version.
 *
 * 29-Apr-89  David Golub (dbg) at Carnegie-Mellon University
 *	Switch to emulator-mode stack to avoid problems with user code
 *	with small stacks (VICE) and signal return bugs (thread_abort).
 *	Move most of the work into C code.
 *
 * 13-Apr-89  David Golub (dbg) at Carnegie-Mellon University
 *	Added more individual entry points.
 *
 * 10-Apr-89  David Golub (dbg) at Carnegie-Mellon University
 *	getrusage(), sigreturn(), osigcleanup() now call individual
 *	routines.
 *
 *  7-Apr-89  David Golub (dbg) at Carnegie-Mellon University
 *	Added entry points for execv, execve.  Made fork and vfork call
 *	e_fork.
 *
 * DBG - mangled for temporary emulator.
 */

#include <sys/syscall.h>
#include <sys/errno.h>
#include <sun3/psl.h>

/*
 * Emulator vector entry - allocate new stack
 */
	.data
	.globl	_emul_stack_lock
_emul_stack_lock:
	.long	0
	.text

/*
 * Both of these sequences must be 8 bytes long, and leave the stacked
 * PC pointing at the end of the sequence.
 */
/*
 * Generic emulator entry
 */
#define	EE		nop; nop; bsr _emul_common

/*
 * Generic call
 */
	.globl	_emul_common
_emul_common:
	subql	#2,sp			| align SP on longword
	moveml	d0/d1/a0/a1,sp@-	| save registers that C does not
0:	tas	_emul_stack_lock	| lock emul_stack lock
	bne	0b
	movl	_emul_stack_list,d0	| grab an emulator stack
	bne	3f			| if none:
	clrb	_emul_stack_lock	|   release the lock
	jsr	_emul_stack_alloc	|   allocate a stack
	movl	d0,a0			|
	bra	4f			|   and use it
3:	movl	d0,a0			| else
	movl	a0@,_emul_stack_list	|   remove the stack from list
	clrb	_emul_stack_lock	|   and unlock the lock
4:	movl	sp,a0@			| Save users SP at top of new stack
	movl	a0,sp			| switch to emulators stack
	moveml	d2-d7/a2-a6,sp@-	| save the remaining registers
	pea	sp@			| push address of registers
	jsr	_emul_syscall		| call C code
	addql	#4,sp			| pop parameter
/*
 * Return
 */
	.globl	emul_exit
emul_exit:
	moveml	sp@+,d2-d7/a2-a6	| restore registers
	movl	sp,a0			| save emulator stack address
	movl	sp@,sp			| return to users stack
0:	tas	_emul_stack_lock	| lock emul_stack lock
	bne	0b
	movl	_emul_stack_list,a0@	| chain emulator stack on list
	movl	a0,_emul_stack_list
	clrb	_emul_stack_lock	| release the lock

	moveml	sp@+,d0/d1/a0/a1	| restore regs that C does not save
	addql	#6,sp			| pop padding and syscall #
	rtr				| and return to user

/*
 * Child starts executing here with return values in d0/d1,
 * stack pointing to saved d0/d1/a0/a1/sr/pc.
 */
	.globl	_child_fork
_child_fork:
	movl	d0,sp@			| save d0
	movl	d1,sp@(4)		| and d1
	jsr	_child_init		| initialize emulator for child
	moveml	sp@+,d0/d1/a0/a1	| restore registers that C does not save
	addql	#6,sp			| pop jump table address and padding
	andw	#0xfffe,sp@		| turn carry off for success
	rtr				| and return to user


/*
 * Amazingly enough, the easiest way to exec /etc/init is to take
 * an emulator trap!
 */
	.globl	_emul_execve
_emul_execve:
	pea	SYS_execve
	trap	#0
	/* we only get here on failure */
	movl	#-1,d0
	rts
