.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	vm_allocate.man,v $
.\" Revision 2.5  93/03/18  15:16:34  mrt
.\" 	corrected types
.\" 	[93/03/12  16:55:09  lli]
.\" 
.\" Revision 2.4  91/05/14  17:15:11  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:15:56  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:16:54  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:47:08  rpd
.\" 	Created.
.\" 
.TH vm_allocate 2 9/19/86
.CM 4
.SH NAME
.nf
vm_allocate  \-  allocates virtual memory for a task
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t vm_allocate(target_task, address, size, anywhere)
	mach_port_t	target_task;
	vm_address_t	*address;	/* in/out */
	vm_size_t	size;
	boolean_t	anywhere;


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
target_task
Task whose virtual address space is to be affected.
.TP 15
.B
address
Starting address.  If the 
.B anywhere
option is false, 
an attempt is made to allocate virtual memory starting at
this virtual address. If this address is not at the beginning
of a virtual page, it will be rounded down to one. 
If there is not enough space at this address, no memory will be allocated.
If the anywhere option is true, the input value of this address will
be ignored, and the space will be allocated wherever it is available.
In either case, the address at which memory was actually allocated will 
be returned in 
.B address
.
.TP 15
.B
size
Number of bytes to allocate (rounded by the system in a 
machine dependent way to an integral number of virtual pages).
.TP 15
.B
anywhere
If true, the kernel should find and allocate any region of 
the specified size, and return the address of the resulting region in 
.B address
.  If false, virtual memory will be allocated starting at
.B address
, rounded to a virtual page boundary if there 
is sufficient space.

.SH DESCRIPTION
.B vm_allocate
allocates a region of virtual memory, placing it in the
specified task's address space.  The physical memory is not actually
allocated until the new virtual memory is referenced.  By default, 
the kernel rounds all addresses down 
to the nearest page boundary and all memory sizes up to the nearest page 
size.  The global variable 
.B vm_page_size
contains the page size.
.B task_self_
returns
the value of the current task port which should be used as 
the 
.B target_task
argument in order to allocate
memory in the caller's address space. For languages other than C, these values
can be obtained by the calls 
.B vm_statistics
and 
.B task_self
.
Initially, the pages of allocated memory will be protected
to allow all forms of access, and will be inherited in child tasks as
a copy.  Subsequent calls to 
.B vm_protection
and 
.B vm_inheritance
may
be used to change these properties.  The allocated region is always 
zero-filled. 

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
Memory allocated.
.TP 25
KERN_INVALID_ADDRESS
Illegal address specified.
.TP 25
KERN_NO_SPACE
Not enough space left to satisfy this request

.SH SEE ALSO
.B vm_deallocate, vm_inherit, vm_protect, vm_regions, vm_statistics,
.B task_self_


