/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                      File: MOTIF_stop_button.c
 *                    Author: Lisa Sobierajski 
 *                      Date: 7/19/93
 *               Description: Creates a stop button in a dialog 
 *      Modification History:
 *
 *              Who?            When?           Why?
 *      --------------------------------------------------------------------
 *
 */

#include <X11/Intrinsic.h>
#include <Xm/DialogS.h>
#include <Xm/SelectioB.h>
#include <Xm/MessageB.h>
#include <Xm/RowColumn.h>
#include <Xm/PushBG.h>
#include <Xm/PushB.h>
#include <Xm/LabelG.h>
#include <Xm/Xm.h>
#include <Xm/PanedW.h>
#include <Xm/Form.h>
#include <Xm/Text.h> 

#include "C_volvis.h"
#include "MOTIF_windefs.h"
#include "C_help.h"

#include "bitmaps/stop_bitmap"


int	user_pressed_stop;
Widget  global_stop_dialog;

/*
 *        Procedure Name: C_setup_stop_button
 */

void C_setup_stop_button( stop_label )
char  * stop_label;			/* the stop message to display */
{
	extern Widget			vv_toplevel;
	extern C_WindowDefs		window_defs;
	
	void				stop_callback();

  	Widget  	stop_dialog;			/* the message dialog */
  	int	  	i,n;
  	Arg	  	args[20];
  	XmString  	stop_string;
	Pixmap	  	pixmap;


	user_pressed_stop = FALSE;
	
	stop_string = XmStringCreateSimple( stop_label );

	n=0;
	/* only this application is disabled while dialog is up */
	XtSetArg( args[n], XmNdialogStyle, 
			    XmDIALOG_FULL_APPLICATION_MODAL);	n++;
	XtSetArg( args[n], XmNmessageString, stop_string );	n++;
        pixmap = XCreatePixmapFromBitmapData( XtDisplay( vv_toplevel ),
                RootWindowOfScreen( XtScreen( vv_toplevel ) ),
                stop_bitmap_bits, stop_bitmap_width, stop_bitmap_height,
                window_defs.button_exit.pixel,
                window_defs.window_background.pixel, window_defs.depth );
	XtSetArg( args[n], XmNsymbolPixmap, pixmap );	n++;
	XtSetArg( args[n], XmNcancelLabelString, 
		XmStringCreateSimple("Cancel"));	n++;
	C_Set_Color_Dialog(args,n,window_defs);
	stop_dialog = XmCreateMessageDialog(vv_toplevel, "dialog", args, n);

	XtAddCallback(stop_dialog, XmNcancelCallback, stop_callback, 
		      &user_pressed_stop);

   	XmStringFree( stop_string );

	XtUnmanageChild(XmMessageBoxGetChild(stop_dialog,XmDIALOG_OK_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(stop_dialog,XmDIALOG_HELP_BUTTON));

	XtManageChild(stop_dialog);
	XtPopup(XtParent(stop_dialog), XtGrabNone);

	global_stop_dialog = stop_dialog;
}


void stop_callback(w, user_pressed_stop, call_data )
Widget w;
int *user_pressed_stop;
XmAnyCallbackStruct *call_data;
{
	*user_pressed_stop = TRUE;
}

int C_process_stop_event()
{
	extern XtAppContext	vv_app_context;

	if ( global_stop_dialog == NULL ) return FALSE;

	while ( XtAppPending( vv_app_context ) )
		XtAppProcessEvent( vv_app_context, XtIMAll );
	
	return user_pressed_stop;
}


void C_remove_stop_button( )
{
	if ( !global_stop_dialog ) return;

	XtDestroyWidget( XtParent( global_stop_dialog ) );
	global_stop_dialog = NULL;
}

