/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: MOTIF_ren_ui.c
 *		      Author: Lisa Sobierajski 
 *			Date: 03/07/92
 *		 Description: Motif Windowing Routines Of The Rendering Window 
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/BulletinB.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/DrawingA.h>
#include <Xm/Frame.h>
#include <Xm/ToggleBG.h>
#include <Xm/ToggleB.h>
#include <math.h>


#include "C_volvis.h"
#include "MOTIF_windefs.h"
#include "C_help.h"

void projection_type_option();

/* Global Variables For Motif Windowing */
extern Widget		vv_toplevel;	/* Bulletin Board Dialog */
extern Widget		ren_bbdialog;	/* Bulletin Board Dialog */
extern C_WindowDefs	window_defs;

extern C_World		world;
extern C_View		view;
extern C_ImageTable	image_table;

Widget	ren_setup_bbdialog;

create_ren_window()
{
	extern void	close_callback();
	extern void	help_callback();

	void		ren_project_callback();
	void		ren_setup_callback();

	Arg		args[20];	/* Argument List */
	int		n;		/* Argument Count */

	Widget		label;
	Widget		pulldown;
	Widget		options[3];
	Widget		option_menu;
	Widget		button;
	Widget		text;
	XmString	label_string;
	int		i;
	Widget		frame;
	Widget		rowcolumn;

	/********************************************************/		
	/* Create The Renderer Bulletin Board			*/
	/********************************************************/		
	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 0 ); n++;
	XtSetArg( args[n], XmNautoUnmanage, False ); n++;
	C_Set_Color_Dialog( args, n, window_defs );
	label_string = XmStringCreate("Rendering", XmSTRING_DEFAULT_CHARSET);
	XtSetArg( args[n], XmNdialogTitle, label_string ); n++;
	ren_bbdialog = XmCreateBulletinBoardDialog( vv_toplevel,
		       "Rendering Control", args, n );

	
	/********************************************************/		
	/*	Create a Pulldown Selection for Render Type	*/
	/********************************************************/		
        n = 0;
	C_Set_Color_PullDown( args, n, window_defs );
        pulldown = 
		XmCreatePulldownMenu(ren_bbdialog, "pulldown", args, n);

        n = 0;
        label_string = XmStringCreate ("PARC", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        options[0] = 
		XmCreatePushButtonGadget(pulldown, "PARC", args, n);
        XmStringFree (label_string);
        XtAddCallback (options[0], XmNactivateCallback,
                       projection_type_option, C_PARC);

        n = 0;
        label_string = XmStringCreate ("Ray Trace", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        options[1] = 
		XmCreatePushButtonGadget(pulldown, "Ray Trace", args, n);
        XmStringFree (label_string);
        XtAddCallback (options[1], XmNactivateCallback,
                       projection_type_option, C_RAY_TRACE);

/***
        n = 0;
        label_string = XmStringCreate ("Test New", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        options[2] = 
		XmCreatePushButtonGadget(pulldown, "Test New", args, n);
        XmStringFree (label_string);
        XtAddCallback (options[2], XmNactivateCallback,
                       projection_type_option, C_VOLRAD);
***/

        XtManageChildren (options, 2);

	/********************************************************/		
	/*	Create An Option Menu, And Attach The Pulldown	*/
	/********************************************************/		

        n = 0;
        label_string = XmStringCreate ("Projection Type:", 
				      XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        XtSetArg (args[n], XmNsubMenuId, pulldown); n++;
	C_Set_Color_OptionMenu( args, n, window_defs );

	switch( view.projection_type )
	{
	  case C_PARC:
        	XtSetArg (args[n], XmNmenuHistory, options[0]); n++;
		break;
	  case C_RAY_TRACE:
        	XtSetArg (args[n], XmNmenuHistory, options[1]); n++;
		break;
	}
        option_menu = XmCreateOptionMenu(ren_bbdialog, 
				"option_menu", args, n);

        XtManageChild(option_menu);
        XmStringFree( label_string );

	
	/************************************************/
	/*     Create The Image Name Label		*/
	/************************************************/
        label_string = XmStringCreate("Image Name: ",XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 15 ); n++;
        XtSetArg( args[n], XmNy, 55 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( ren_bbdialog, "Image Name:", 
						args, n );
        XtManageChild( label );
        XmStringFree( label_string );



        /************************************************/
        /*     Create The Image Name Text Input Area    */
        /************************************************/
        n=0;
        XtSetArg( args[n], XmNx, 115 ); n++;
        XtSetArg( args[n], XmNy, 50 ); n++;
        XtSetArg( args[n], XmNcolumns, 20 ); n++;
        XtSetArg( args[n], XmNvalue, "Image" ); n++;
	C_Set_Color_Text( args, n, window_defs );
        text = XmCreateTextField( ren_bbdialog, "text", 
					     args, n );
        XtManageChild( text );

        n = 0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 120 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = XmCreateFrame( ren_bbdialog, "frame", args, n );
        XtManageChild( frame );

        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        C_Set_Color_RowColumn( args, n, window_defs );
        rowcolumn =
                XmCreateRowColumn(frame, "rowcolumn", args, n);
        XtManageChild (rowcolumn);


	/************************************************/
	/*     Create The Project  Button		*/
	/************************************************/
	n=0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget( "Project", 
		xmPushButtonWidgetClass, rowcolumn, args, n );
	XtAddCallback( button, XmNactivateCallback, 
		       ren_project_callback, text );
		

	/************************************************/
	/*     Create The Setup  Button			*/
	/************************************************/
	n=0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget( "Setup", 
		xmPushButtonWidgetClass, rowcolumn, args, n );
	XtAddCallback( button, XmNactivateCallback, 
		       ren_setup_callback, NULL );

	/************************************************/
	/*     Create The Close Button			*/
	/************************************************/
	n=0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget( "Close", 
		xmPushButtonWidgetClass, rowcolumn, args, n );
	XtAddCallback( button, XmNactivateCallback,
		       close_callback, ren_bbdialog );

	/************************************************/
	/*     Create The Help Button			*/
	/************************************************/
	n=0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget( "Help", 
		xmPushButtonWidgetClass, rowcolumn, args, n );
	XtAddCallback( button, XmNactivateCallback,
		       help_callback, C_REN_HELP );

}


void ren_project_callback( w, client_data, call_data )
Widget 		w;
Widget		client_data;
caddr_t		call_data;
{
/***
	extern void 	C_create_rad_image();
***/
	extern C_ReturnStatus	C_cast_rays();
        extern void     C_setup_stop_button();
        extern void     C_remove_stop_button();
 

	C_Image		*image;
	char		*image_name;
	int		image_num;
	int		return_val;

	if (world.num_volumes == 0)
	{
		C_error_message("There isn't anything to project!!\n");
		return;
	}

	image = C_New( C_Image );
	C_create_image_from_view( image, &view );
	
	image_name = (char *)XmTextGetString(client_data);
	printf("the image name is %s\n",image_name);
	
	C_enter_image( &image_table, image, image_name, (char *)NULL );
	image_num = image_table.num_images - 1;

	if (view.display_during_projection)
		create_ivi_display_window( image_table.num_images - 1);

	C_setup_stop_button( "Press Here To Cancel Rendering" );

	switch( view.projection_type )
	{
	    case C_PARC:
			return_val = C_cast_rays(&world, &view, 
				    image, TRUE);
			break;
	    case C_RAY_TRACE:
			return_val = C_cast_rays(&world, &view, 
				    image, FALSE);
			break;
	    case C_VOLRAD:
/***
			C_create_rad_image(&world, &view, image );
***/
			break;
	}
	if (view.display_during_projection && return_val == C_OK )
	    ivi_display_image( image_num );

	C_remove_stop_button();
}


void projection_type_option( w, client_data, call_data )
Widget          w;
int             client_data;
XtPointer       call_data;
{
	view.projection_type = client_data;
}

void ren_setup_callback( w, client_data, call_data )
Widget          w;
XtPointer       client_data;
XtPointer       call_data;
{

        void    create_ren_setup_window();

        if( ren_setup_bbdialog )
        {
                if( XtIsManaged(ren_setup_bbdialog) )
                {
                        XtUnmanageChild( ren_setup_bbdialog );
                }
                XtManageChild( ren_setup_bbdialog );
	}
        else
	{
                        create_ren_setup_window();
	}

}

void create_ren_setup_window()
{
	extern void	close_callback();
	extern void	help_callback();

	void		ren_shadow_toggle_callback();
	void		ren_reflect_level_callback();
	void		ren_transmit_level_callback();
	void		ren_indirect_light_level_callback();
	void		ren_image_accuracy_callback();
	void		ren_image_display_rate_callback();
	void		ren_set_shadows_on_callback();
	void		ren_unset_shadows_off_callback();

	extern C_View	view;

	Arg		args[20];
	int		n;

	Widget		label;
	Widget		toggle;
	Widget		shadow_on_toggle;
	Widget		shadow_off_toggle;
	Widget		button;
	Widget		frame;
	Widget		radiobox;
	Widget		rowcolumn;
	XmString	label_string;
	int		frame_y;


	frame_y = 10;

	n = 0;
	XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        XtSetArg( args[n], XmNautoUnmanage, False ); n++;
        C_Set_Color_Dialog( args, n, window_defs );
        label_string = XmStringCreate( "Rendering Setup",
                                        XmSTRING_DEFAULT_CHARSET);
        XtSetArg( args[n], XmNdialogTitle, label_string ); n++;
        ren_setup_bbdialog = XmCreateBulletinBoardDialog( vv_toplevel,
                       "ren_setup", args, n );
	
        label_string = XmStringCreate("Compute Shadows: ",
			XmSTRING_DEFAULT_CHARSET );        
	n=0;
        XtSetArg( args[n], XmNx, 5 ); n++;
        XtSetArg( args[n], XmNy, frame_y + 10 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( ren_setup_bbdialog, "label",
                                                args, n );
        XtManageChild( label );
        XmStringFree( label_string );

	n = 0;
	XtSetArg( args[n], XmNx, 200 ); n++;
        XtSetArg( args[n], XmNy, frame_y ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( ren_setup_bbdialog, "frame", args, n );
	XtManageChild( frame );

	n = 0;
	XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
	C_Set_Color_RadioBox( args, n, window_defs );
        XtSetArg( args[n], XmNx, 200 ); n++;
        XtSetArg( args[n], XmNy, frame_y ); n++;
	radiobox = XmCreateRadioBox( frame, "radiobox", args, n );
	XtManageChild( radiobox );


	n = 0;
        label_string = XmStringCreate ("Off", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.shadows_enabled )
		XtSetArg( args[n], XmNset, FALSE ); 
	else
		XtSetArg( args[n], XmNset, TRUE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        shadow_off_toggle = XtCreateWidget ("Off", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( shadow_off_toggle );
        XmStringFree (label_string);

	n = 0;
        label_string = XmStringCreate ("On", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.shadows_enabled )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        shadow_on_toggle = XtCreateWidget ("On", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( shadow_on_toggle );
        XmStringFree (label_string);
        XtAddCallback (shadow_on_toggle, XmNvalueChangedCallback, 
		       ren_shadow_toggle_callback, NULL);

	frame_y += 50;

        label_string = XmStringCreate("Level Of Reflection: ",
			XmSTRING_DEFAULT_CHARSET );        
	n=0;
        XtSetArg( args[n], XmNx, 5 ); n++;
        XtSetArg( args[n], XmNy, frame_y + 10 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( ren_setup_bbdialog, "label",
                                                args, n );
        XtManageChild( label );
        XmStringFree( label_string );

	n = 0;
	XtSetArg( args[n], XmNx, 200 ); n++;
        XtSetArg( args[n], XmNy, frame_y ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( ren_setup_bbdialog, "frame", args, n );
	XtManageChild( frame );

	n = 0;
	XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
	C_Set_Color_RadioBox( args, n, window_defs );
        XtSetArg( args[n], XmNx, 200 ); n++;
        XtSetArg( args[n], XmNy, frame_y ); n++;
	radiobox = XmCreateRadioBox( frame, "radiobox", args, n );
	XtManageChild( radiobox );


	n = 0;
        label_string = XmStringCreate ("Off", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.max_reflect_ray_level == 0 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("Off", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_reflect_level_callback, 0);

	n = 0;
        label_string = XmStringCreate ("1", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.max_reflect_ray_level == 1 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("1", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_reflect_level_callback, 1);

	n = 0;
        label_string = XmStringCreate ("2", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.max_reflect_ray_level == 2 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("2", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_reflect_level_callback, 2);

	n = 0;
        label_string = XmStringCreate ("3", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.max_reflect_ray_level == 3 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("3", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_reflect_level_callback, 3);

	n = 0;
        label_string = XmStringCreate ("4", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.max_reflect_ray_level == 4 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("4", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_reflect_level_callback, 4);

	frame_y += 50;

        label_string = XmStringCreate("Level Of Transmission: ",
			XmSTRING_DEFAULT_CHARSET );        
	n=0;
        XtSetArg( args[n], XmNx, 5 ); n++;
        XtSetArg( args[n], XmNy, frame_y + 10 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( ren_setup_bbdialog, "label",
                                                args, n );
        XtManageChild( label );
        XmStringFree( label_string );

	n = 0;
	XtSetArg( args[n], XmNx, 200 ); n++;
        XtSetArg( args[n], XmNy, frame_y ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( ren_setup_bbdialog, "frame", args, n );
	XtManageChild( frame );

	n = 0;
	XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
	C_Set_Color_RadioBox( args, n, window_defs );
        XtSetArg( args[n], XmNx, 200 ); n++;
        XtSetArg( args[n], XmNy, frame_y ); n++;
	radiobox = XmCreateRadioBox( frame, "radiobox", args, n );
	XtManageChild( radiobox );


	n = 0;
        label_string = XmStringCreate ("Off", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.max_transmit_ray_level == 0 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("Off", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_transmit_level_callback, 0);

	n = 0;
        label_string = XmStringCreate ("1", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.max_transmit_ray_level == 1 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("1", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_transmit_level_callback, 1);

	n = 0;
        label_string = XmStringCreate ("2", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.max_transmit_ray_level == 2 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("2", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_transmit_level_callback, 2);

	n = 0;
        label_string = XmStringCreate ("3", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.max_transmit_ray_level == 3 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("3", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_transmit_level_callback, 3);

	n = 0;
        label_string = XmStringCreate ("4", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.max_transmit_ray_level == 4 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("4", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_transmit_level_callback, 4);

	frame_y += 50;

/***
        label_string = XmStringCreate("Level Of Indirect Light: ",
			XmSTRING_DEFAULT_CHARSET );        
	n=0;
        XtSetArg( args[n], XmNx, 5 ); n++;
        XtSetArg( args[n], XmNy, 175 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( ren_setup_bbdialog, "label",
                                                args, n );
        XtManageChild( label );
        XmStringFree( label_string );

	n = 0;
	XtSetArg( args[n], XmNx, 200 ); n++;
        XtSetArg( args[n], XmNy, 165 ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( ren_setup_bbdialog, "frame", args, n );
	XtManageChild( frame );

	n = 0;
	XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
	C_Set_Color_RadioBox( args, n, window_defs );
        XtSetArg( args[n], XmNx, 200 ); n++;
        XtSetArg( args[n], XmNy, 165 ); n++;
	radiobox = XmCreateRadioBox( frame, "radiobox", args, n );
	XtManageChild( radiobox );


	n = 0;
        label_string = XmStringCreate ("Off", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.max_indirect_light_level == 0 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("Off", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_indirect_light_level_callback, 0);

	n = 0;
        label_string = XmStringCreate ("1", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.max_indirect_light_level == 1 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("1", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_indirect_light_level_callback, 1);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_set_shadows_on_callback, shadow_on_toggle);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_unset_shadows_off_callback, shadow_off_toggle);

***/

        label_string = XmStringCreate("Image Accuracy: ",
			XmSTRING_DEFAULT_CHARSET );        
	n=0;
        XtSetArg( args[n], XmNx, 5 ); n++;
        XtSetArg( args[n], XmNy, frame_y + 10 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( ren_setup_bbdialog, "label",
                                                args, n );
        XtManageChild( label );
        XmStringFree( label_string );

	n = 0;
	XtSetArg( args[n], XmNx, 200 ); n++;
        XtSetArg( args[n], XmNy, frame_y ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( ren_setup_bbdialog, "frame", args, n );
	XtManageChild( frame );

	n = 0;
	XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
	C_Set_Color_RadioBox( args, n, window_defs );
        XtSetArg( args[n], XmNx, 200 ); n++;
        XtSetArg( args[n], XmNy, frame_y ); n++;
	radiobox = XmCreateRadioBox( frame, "radiobox", args, n );
	XtManageChild( radiobox );


	n = 0;
        label_string = XmStringCreate ("Low", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.image_accuracy == 0 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("Low", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_image_accuracy_callback, C_LOW_IMAGE_ACCURACY);

	n = 0;
        label_string = XmStringCreate ("Medium", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.image_accuracy == 1 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("Medium", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_image_accuracy_callback, C_MEDIUM_IMAGE_ACCURACY);

	n = 0;
        label_string = XmStringCreate ("High", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.image_accuracy == 2 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("High", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_image_accuracy_callback, C_HIGH_IMAGE_ACCURACY);

	frame_y += 50;

        label_string = XmStringCreate("Image Display Rate: ",
			XmSTRING_DEFAULT_CHARSET );        
	n=0;
        XtSetArg( args[n], XmNx, 5 ); n++;
        XtSetArg( args[n], XmNy, frame_y + 10 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( ren_setup_bbdialog, "label",
                                                args, n );
        XtManageChild( label );
        XmStringFree( label_string );

	n = 0;
	XtSetArg( args[n], XmNx, 200 ); n++;
        XtSetArg( args[n], XmNy, frame_y ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( ren_setup_bbdialog, "frame", args, n );
	XtManageChild( frame );

	n = 0;
	XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
	C_Set_Color_RadioBox( args, n, window_defs );
        XtSetArg( args[n], XmNx, 200 ); n++;
        XtSetArg( args[n], XmNy, frame_y ); n++;
	radiobox = XmCreateRadioBox( frame, "radiobox", args, n );
	XtManageChild( radiobox );


	n = 0;
        label_string = XmStringCreate ("Off", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.display_during_projection == 0 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("Off", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_image_display_rate_callback, 0);

	n = 0;
        label_string = XmStringCreate ("100", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.display_during_projection == 100 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("100", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_image_display_rate_callback, 100);

	n = 0;
        label_string = XmStringCreate ("10", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.display_during_projection == 10 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("10", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_image_display_rate_callback, 10);

	n = 0;
        label_string = XmStringCreate ("50", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
	if ( view.display_during_projection == 50 )
		XtSetArg( args[n], XmNset, TRUE ); 
	else
		XtSetArg( args[n], XmNset, FALSE );
	n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle = XtCreateWidget ("50", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
	XtManageChild( toggle );
        XmStringFree (label_string);
        XtAddCallback (toggle, XmNvalueChangedCallback, 
		       ren_image_display_rate_callback, 50);

	n = 0;
	XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 300 ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( ren_setup_bbdialog, "frame", args, n );
	XtManageChild( frame );

	n = 0;
	XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
	C_Set_Color_RowColumn( args, n, window_defs );
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 300 ); n++;
	rowcolumn = XmCreateRowColumn( frame, "RowColumn", args, n );
	XtManageChild( rowcolumn );

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Close",
                xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       close_callback, ren_setup_bbdialog );
        n = 0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget("Help",
                        xmPushButtonWidgetClass, rowcolumn, args, n );
	XtAddCallback( button, XmNactivateCallback,
		       help_callback, C_REN_SETUP_HELP );


	XtManageChild( ren_setup_bbdialog );
	
}

void ren_shadow_toggle_callback( w, client_data, call_data )
Widget				w;
int				client_data;
XmToggleButtonCallbackStruct	*call_data;
{
	extern C_View	view;

	view.shadows_enabled = call_data->set;
}

void ren_reflect_level_callback( w, client_data, call_data )
Widget				w;
int				client_data;
XmToggleButtonCallbackStruct	*call_data;
{
	extern C_View	view;

	if ( call_data->set )
		view.max_reflect_ray_level = client_data;
}


void ren_transmit_level_callback( w, client_data, call_data )
Widget				w;
int				client_data;
XmToggleButtonCallbackStruct	*call_data;
{
	extern C_View	view;

	if ( call_data->set )
		view.max_transmit_ray_level = client_data;
}

void ren_indirect_light_level_callback( w, client_data, call_data )
Widget				w;
int				client_data;
XmToggleButtonCallbackStruct	*call_data;
{
	extern C_View	view;

	if ( call_data->set )
		view.max_indirect_light_level = client_data;
}

void ren_set_shadows_on_callback( w, client_data, call_data )
Widget				w;
Widget				client_data;
XmToggleButtonCallbackStruct	*call_data;
{
	extern C_View	view;

	Arg	args[1];

	if ( call_data->set )
	{
		XtSetArg( args[0], XmNset, TRUE );
		XtSetValues( client_data, args, 1 );
		view.shadows_enabled = TRUE;
	}
}

void ren_unset_shadows_off_callback( w, client_data, call_data )
Widget				w;
Widget				client_data;
XmToggleButtonCallbackStruct	*call_data;
{
	extern C_View	view;

	Arg	args[1];

	if ( call_data->set )
	{
		XtSetArg( args[0], XmNset, FALSE );
		XtSetValues( client_data, args, 1 );
	}
}

void ren_image_accuracy_callback( w, client_data, call_data )
Widget				w;
C_ImageAccuracy			client_data;
XmToggleButtonCallbackStruct	*call_data;
{
	extern C_View	view;

	if ( call_data->set )
		view.image_accuracy = client_data;
}

void ren_image_display_rate_callback( w, client_data, call_data )
Widget				w;
int				client_data;
XmToggleButtonCallbackStruct	*call_data;
{
	extern C_View	view;

	if ( call_data->set )
		view.display_during_projection = client_data;
}

