/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: MOTIF_pre_ui.c
 *		      Author: Jiang (John) Qian
 *			Date: 06/22/93
 *		 Description: Motif Windowing Routines Of VolVis
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/BulletinB.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/DrawingA.h>
#include <Xm/Frame.h>
# include <Xm/ToggleBG.h>
# include <Xm/ToggleB.h>
# include <math.h>


#include "C_volvis.h"
#include "MOTIF_windefs.h"

/* Global Variables For Motif Windowing */
extern Widget		vv_toplevel;	/* VolVis toplevel Shell Widget */
extern Widget		pre_bbdialog;
extern C_WindowDefs	window_defs;

C_Preference	pre_info;

void create_pre_window()
{
  	extern		void close_callback();
	void  		user_level_callback();

        Widget          label;
        Widget          toggle;
        Widget          beg_user_toggle;
        Widget          pro_user_toggle;
        Widget          button;
        Widget          frame;
        Widget          radiobox;
        Widget          rowcolumn;
        XmString        label_string;

	Arg		args[20];	/* Argument List */
	int		n;		/* Argument Count */


	/************************************************/
	/*     Create The File Input Output Window	*/
	/************************************************/

	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 0 ); n++;
	XtSetArg( args[n], XmNautoUnmanage, False ); n++;
	label_string = XmStringCreate( "Preferences", XmSTRING_DEFAULT_CHARSET);
	XtSetArg( args[n], XmNdialogTitle, label_string ); n++;
	C_Set_Color_Dialog( args, n, window_defs );
	pre_bbdialog = XmCreateBulletinBoardDialog( vv_toplevel,
		       				"Preferences", args, n );
	XmStringFree(label_string);

printf("made dialog\n");

        label_string = XmStringCreate("User Levels: ",
        		                XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 5 ); n++;
        XtSetArg( args[n], XmNy, 15 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( pre_bbdialog, "label",
                                                args, n );
        XtManageChild( label );
        XmStringFree( label_string );

printf("created label\n");

        n = 0;
        XtSetArg( args[n], XmNx, 200 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = XmCreateFrame( pre_bbdialog, "frame", args, n );
        XtManageChild( frame );

        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        C_Set_Color_RadioBox( args, n, window_defs );
        XtSetArg( args[n], XmNx, 200 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        radiobox = XmCreateRadioBox( frame, "radiobox", args, n );
        XtManageChild( radiobox );

        n = 0;
        label_string = XmStringCreate ("Beginner", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        if (  pre_info.user == C_BEGINNER   )
                XtSetArg( args[n], XmNset, FALSE );
        else
                XtSetArg( args[n], XmNset, TRUE );
        n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        beg_user_toggle = XtCreateWidget ("Off", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
        XtManageChild( beg_user_toggle );
        XmStringFree (label_string);
	XtAddCallback (beg_user_toggle, XmNvalueChangedCallback,
                       user_level_callback, C_BEGINNER);

printf("beginner toggle created\n");

        n = 0;
        label_string = XmStringCreate ("Proficient", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        if (  pre_info.user == C_PROFICIENT )
                XtSetArg( args[n], XmNset, TRUE );
        else
                XtSetArg( args[n], XmNset, FALSE );
        n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        pro_user_toggle = XtCreateWidget ("On", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
        XtManageChild( pro_user_toggle );
        XmStringFree (label_string);
	XtAddCallback (pro_user_toggle, XmNvalueChangedCallback,
                       user_level_callback, C_PROFICIENT);

        n = 0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 120 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = XmCreateFrame( pre_bbdialog, "frame", args, n );
        XtManageChild( frame );

        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        C_Set_Color_RowColumn( args, n, window_defs );
        rowcolumn =
                XmCreateRowColumn(frame, "rowcolumn", args, n);
        XtManageChild (rowcolumn);

printf("get past this point\n");

        /************************************************/
        /*     Create The Close Button                  */
        /************************************************/
        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Close",
                xmPushButtonWidgetClass, rowcolumn, args, n );
        XtAddCallback( button, XmNactivateCallback,
                       close_callback, pre_bbdialog );

        /************************************************/
        /*     Create The Help Button                   */
        /************************************************/
        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Help",
                xmPushButtonWidgetClass, rowcolumn, args, n );

printf("close and help buttons\n");

	/* make beg_user_toggle to be pressed first */
	n=0;
	XtSetArg(args[n], XmNset, TRUE);  n++;
	XtSetValues(beg_user_toggle, args, n);
	pre_info.user = C_BEGINNER;
}


void user_level_callback( w, client_data, call_data )
Widget                          w;
C_UserType			client_data;
XmToggleButtonCallbackStruct    *call_data;
{

	pre_info.user = client_data;

	if (pre_info.user == C_BEGINNER)
		printf("level is C_BEGINNER\n");
	else
		printf("level is C_PROFICIENT\n"); 
}
