/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *                  File: MOTIF_nav_ui_callbacks.c
 *                Author: Hui Chen 
 *                  Date: 03/06/92
 *           Description: 
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */

#include <math.h>
# include <stdio.h>
# include <string.h>

#include "C_volvis.h"
#include "C_navigator.h"

extern C_NavCWInfo     nav_cw_info;

void nav_set_mode();
void nav_set_coord();
void nav_set_ref();
void nav_global_option();
void nav_accept_proc();
void nav_undo_proc();
void nav_close_proc();

/***** accept_proc *********************************************************/

void nav_accept_proc (w, client_data, call_data)
Widget 		w;
XtPointer 	client_data;
XtPointer 	call_data;
{
	extern void nav_push();

	nav_push();
}

/***** undo_proc *********************************************************/

void nav_undo_proc (w, client_data, call_data)
Widget 		w;
XtPointer 	client_data;
XtPointer 	call_data;
{
	extern void nav_pop();

	nav_pop();
}


/*****  close_proc  ******************************************************/

void nav_close_proc(w, client_data, call_data)
Widget		w;
Widget		client_data;
XtPointer	call_data;
{
	XtUnmanageChild( client_data );
}

/*****  set_mode   ******************************************************/

void nav_set_mode(w, mode_client, mode_data)
Widget				w;
int				mode_client;
XmToggleButtonCallbackStruct	*mode_data;
{
	Arg args[10];
	XmString string;

	int n;

	if ( mode_data->set == 0 )
		return;

	switch (mode_client)
	{
	    case C_TRANSLATE :
			nav_cw_info.nav_global.nav_mode = C_TRANSLATE;
			nav_cw_info.nav_label_name[0] = "X unit:";
			nav_cw_info.nav_label_name[1] = "Y unit:";
			nav_cw_info.nav_label_name[2] = "Z unit:";
			n = 0;
			string = XmStringCreate (nav_cw_info.nav_label_name[0], 
						 XmSTRING_DEFAULT_CHARSET);
			XtSetArg (args[n], XmNlabelString, string); n++;
			XtSetValues (nav_cw_info.nav_label[0], args, n);
			XmStringFree (string);

			n = 0;
			string = XmStringCreate (nav_cw_info.nav_label_name[1], 
						 XmSTRING_DEFAULT_CHARSET);
			XtSetArg (args[n], XmNlabelString, string); n++;
			XtSetValues (nav_cw_info.nav_label[1], args, n);
			XmStringFree (string);

			n = 0;
			string = XmStringCreate (nav_cw_info.nav_label_name[2], 
						 XmSTRING_DEFAULT_CHARSET);
			XtSetArg (args[n], XmNlabelString, string); n++;
			XtSetValues (nav_cw_info.nav_label[2], args, n);
			XmStringFree (string);

			XtSetSensitive(nav_cw_info.nav_global_toggle, True);
 			XtSetSensitive(nav_cw_info.nav_global_rc, True);
			XtSetSensitive(nav_cw_info.nav_ref_radiobox, False);
			XtSetSensitive(nav_cw_info.nav_bb, False);

			break;
	    case C_ROTATE :
			nav_cw_info.nav_global.nav_mode = C_ROTATE;
			nav_cw_info.nav_label_name[0] = "X angle:";
			nav_cw_info.nav_label_name[1] = "Y angle:";
			nav_cw_info.nav_label_name[2] = "Z angle:";
			n = 0;
			string = XmStringCreate (nav_cw_info.nav_label_name[0], 
						 XmSTRING_DEFAULT_CHARSET);
			XtSetArg (args[n], XmNlabelString, string); n++;
			XtSetValues (nav_cw_info.nav_label[0], args, n);
			XmStringFree (string);

			n = 0;
			string = XmStringCreate (nav_cw_info.nav_label_name[1], 
						 XmSTRING_DEFAULT_CHARSET);
			XtSetArg (args[n], XmNlabelString, string); n++;
			XtSetValues (nav_cw_info.nav_label[1], args, n);
			XmStringFree (string);

			n = 0;
			string = XmStringCreate (nav_cw_info.nav_label_name[2], 
						 XmSTRING_DEFAULT_CHARSET);
			XtSetArg (args[n], XmNlabelString, string); n++;
			XtSetValues (nav_cw_info.nav_label[2], args, n);
			XmStringFree (string);

			XtSetSensitive(nav_cw_info.nav_global_toggle, True);
 			XtSetSensitive(nav_cw_info.nav_global_rc, True);
			XtSetSensitive(nav_cw_info.nav_ref_radiobox, True);
			XtSetSensitive(nav_cw_info.nav_bb, True);
			break;
	    case C_SCALE :
			nav_cw_info.nav_global.nav_mode = C_SCALE;
			nav_cw_info.nav_label_name[0] = "X factor:";
			nav_cw_info.nav_label_name[1] = "Y factor:";
			nav_cw_info.nav_label_name[2] = "Z factor:";
			n = 0;
			string = XmStringCreate (nav_cw_info.nav_label_name[0], 
						 XmSTRING_DEFAULT_CHARSET);
			XtSetArg (args[n], XmNlabelString, string); n++;
			XtSetValues (nav_cw_info.nav_label[0], args, n);
			XmStringFree (string);

			n = 0;
			string = XmStringCreate (nav_cw_info.nav_label_name[1], 
						 XmSTRING_DEFAULT_CHARSET);
			XtSetArg (args[n], XmNlabelString, string); n++;
			XtSetValues (nav_cw_info.nav_label[1], args, n);
			XmStringFree (string);

			n = 0;
			string = XmStringCreate (nav_cw_info.nav_label_name[2], 
						 XmSTRING_DEFAULT_CHARSET);
			XtSetArg (args[n], XmNlabelString, string); n++;
			XtSetValues (nav_cw_info.nav_label[2], args, n);
			XmStringFree (string);

			n = 0;
        		XtSetArg( args[n], XmNset, False ); n++;
        		XtSetValues (nav_cw_info.nav_global_toggle, args, n);

			n = 0;
        		XtSetArg( args[n], XmNset, TRUE ); n++;
        		XtSetValues (nav_cw_info.nav_local_toggle, args, n);

			nav_cw_info.nav_global.nav_coord = C_LOCAL_COORD;

			XtSetSensitive(nav_cw_info.nav_global_toggle, False);
 			XtSetSensitive(nav_cw_info.nav_global_rc, False);
			XtSetSensitive(nav_cw_info.nav_ref_radiobox, True);
			XtSetSensitive(nav_cw_info.nav_bb, True);

			break;
	}
}

/*****  set_coord   ******************************************************/

void nav_set_coord(w, ref_client, ref_data)
Widget				w;
int				ref_client;
XmToggleButtonCallbackStruct	*ref_data;
{
	if( ref_data->set == 0 )
		return;

	switch (ref_client)
	{
	    case C_LOCAL_COORD :
			nav_cw_info.nav_global.nav_coord = C_LOCAL_COORD;
			break;
	    case C_GLOBAL_COORD :
			nav_cw_info.nav_global.nav_coord = C_GLOBAL_COORD;
			break;
	}
}

/*****  global option callback   ***********************************/

void nav_global_option( w, client_data, call_data )
Widget		w;
int		client_data;
XtPointer	call_data;
{
	nav_cw_info.nav_global.nav_option = client_data;
}
	

/*****  set_ref   ******************************************************/

void nav_set_ref (w, ref_client, ref_data)
Widget				w;
int				ref_client;
XmToggleButtonCallbackStruct	*ref_data;
{
	if( ref_data->set == 0 )
		return;

	switch (ref_client)
	{
	    case C_ORIGIN_REF :
			nav_cw_info.nav_global.nav_ref = C_ORIGIN_REF;
			break;
	    case C_CENTER_REF :
			nav_cw_info.nav_global.nav_ref = C_CENTER_REF;
			break;
	    case C_OTHER_REF :
			nav_cw_info.nav_global.nav_ref = C_OTHER_REF;
			break;
	}
}

/***** x, y, z input call back *****/

float nav_set_x()
{
	char	*string;
	
	float	nav_x;
	
	string = (char *)XmTextGetString( nav_cw_info.nav_text[0] );
	sscanf( string, "%f", &nav_x );

	return(nav_x);
}

float nav_set_y()
{
	char	*string;
	
	float	nav_y;

	string = (char *)XmTextGetString( nav_cw_info.nav_text[1] );
	sscanf( string, "%f", &nav_y );

	return(nav_y);
}

float nav_set_z()
{
	char	*string;
	
	float	nav_z;
	
	string = (char *)XmTextGetString( nav_cw_info.nav_text[2] );
	sscanf( string, "%f", &nav_z );

	return(nav_z);
}

/***** "Other" reference point x, y, z input call back *****/

float nav_ref_x()
{
	char	*string;
	
	float	nav_other_x;
	
	string = (char *)XmTextGetString( nav_cw_info.nav_other_text[0] );
	sscanf( string, "%f", &nav_other_x );

	return(nav_other_x);
}

float nav_ref_y()
{
	char	*string;

	float	nav_other_y;
	
	string = (char *)XmTextGetString( nav_cw_info.nav_other_text[1] );
	sscanf( string, "%f", &nav_other_y );

	return(nav_other_y);
}

float nav_ref_z()
{
	char	*string;

	float	nav_other_z;
	
	string = (char *)XmTextGetString( nav_cw_info.nav_other_text[2] );
	sscanf( string, "%f", &nav_other_z );

	return(nav_other_z);
}

